/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.benchmark;

import com.sap.dbtechtest.jdbc.benchmark.SimulatedUser;
import com.sap.dbtechtest.jdbc.benchmark.TP2;
import com.sap.dbtechtest.xlog.Failure;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class JavaUser
extends SimulatedUser
implements Runnable {
    private static ThreadGroup javaUserThreads = null;
    protected Connection connection = null;
    private Thread userThread = null;
    private int transactionCount = 0;
    private int errorCount = 0;
    private boolean abort = false;
    protected TP2 test;

    public static ThreadGroup getThreadGroup() {
        return javaUserThreads;
    }

    public Thread getThread() {
        return this.userThread;
    }

    public JavaUser(int n, TP2 tP2) throws SQLException {
        super(n);
        this.test = tP2;
        this.connection = this.test.connect();
        this.connection.setAutoCommit(false);
        int n2 = this.test.getOptions().getInt("isolationlevel");
        this.connection.setTransactionIsolation(n2);
        this.test.getLog().addInfo("TransactionIsolationLevel: " + this.connection.getTransactionIsolation());
    }

    protected abstract void executeTransaction() throws SQLException;

    protected abstract void executeTransactionPlDBProc() throws SQLException;

    protected abstract void executeTransactionCppDBProc() throws SQLException;

    protected void closeSQL() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.currentState = 2;
        while (waitingForBegin) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.currentState = 3;
        long l = System.currentTimeMillis();
        long l2 = System.currentTimeMillis();
        long l3 = this.test.getTestDuration() * 1000L;
        try {
            while (l2 - l < l3 && !this.abort) {
                this.executeTransaction();
                ++this.transactionCount;
                l2 = System.currentTimeMillis();
                Thread.yield();
            }
        }
        catch (SQLException sQLException) {
            this.test.getLogWriter().addFailure(new Failure(sQLException.toString()));
            ++this.errorCount;
        }
        if (this.abort) {
            this.currentState = 5;
        } else {
            try {
                this.test.preStoreResults(this.getId(), this.test.getTestDuration(), this.transactionCount, this.errorCount);
                this.currentState = 4;
            }
            catch (Exception exception) {
                this.currentState = 5;
            }
        }
        this.closeSQL();
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void runUser() {
        this.userThread = new Thread(javaUserThreads, this, "JavaUser[" + this.getId() + "]");
        this.userThread.setPriority(1);
        this.userThread.start();
    }

    public int getExitValue() throws IllegalThreadStateException {
        if (this.currentState == 4) {
            return 0;
        }
        if (this.currentState == 5) {
            return 1;
        }
        throw new IllegalThreadStateException("JavaUser is not finished. Current state is " + SimulatedUser.convertState(this.currentState));
    }

    public void abort() {
        if (this.currentState != 4 && this.currentState != 5) {
            this.abort = true;
        }
    }

    static {
        javaUserThreads = new ThreadGroup("JavaUserThreads");
    }
}

