/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.protocol;

import com.sap.sapdb.WebDAVTest.protocol.URLStreamHandlerFactory;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvHTTPHeaders;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvHttpConnection;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvStatus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WDVTestJ_WebDAVCore {
    protected URL url = null;
    protected WDVTestJ_WdvHTTPHeaders requestContext = new WDVTestJ_WdvHTTPHeaders();
    protected WDVTestJ_WdvHTTPHeaders responseContext = new WDVTestJ_WdvHTTPHeaders();
    protected WDVTestJ_WdvStatus status = new WDVTestJ_WdvStatus();
    protected WDVTestJ_WdvHttpConnection connection = null;

    public WDVTestJ_WebDAVCore() {
    }

    public WDVTestJ_WebDAVCore(URL myUrl) {
        this.url = myUrl;
    }

    public WDVTestJ_WebDAVCore(URL myUrl, String user, String password) {
        this.url = myUrl;
        this.requestContext.setBasicAuthorization(user, password);
    }

    public void setBasicAuthorization(String user, String password) {
        this.requestContext.setBasicAuthorization(user, password);
    }

    protected InputStream getContentsInputStream() throws WDVTestJ_WdvException, IOException {
        this.setupRequest("GET");
        this.getResults();
        InputStream stream = null;
        stream = this.connection.getInputStream();
        return stream;
    }

    public OutputStream getContentsOutputStream() throws WDVTestJ_WdvException, IOException {
        if (this.requestContext.contentType() == null) {
            this.requestContext.contentType("text/plain");
        }
        this.setupRequest("PUT");
        this.connection.setDoOutput(true);
        OutputStream stream = null;
        stream = this.connection.getOutputStream();
        return stream;
    }

    public byte[] GET() throws WDVTestJ_WdvException, IOException {
        byte[] cachedContents = null;
        InputStream is = this.getContentsInputStream();
        cachedContents = this.readBody(is);
        return cachedContents;
    }

    public byte[] GET_Chunked() throws WDVTestJ_WdvException, IOException {
        InputStream is;
        byte[] cachedContents = null;
        this.requestContext.sapdb_Chunked("T");
        try {
            is = this.getContentsInputStream();
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException e) {
            throw e;
        }
        try {
            cachedContents = this.readBody(is);
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException e) {
            throw e;
        }
        return cachedContents;
    }

    public byte[] GET(String contentRange) throws WDVTestJ_WdvException, IOException {
        byte[] cachedContents = null;
        if (contentRange != null) {
            this.requestContext.contentRange(contentRange);
        }
        try {
            InputStream is = this.getContentsInputStream();
            cachedContents = this.readBody(is);
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw exc;
        }
        return cachedContents;
    }

    public void POST(String contents, String contentType) throws WDVTestJ_WdvException, IOException {
        if (contentType != null) {
            this.requestContext.contentType(contentType);
        }
        if (this.requestContext.contentType() == null) {
            this.requestContext.contentType("text/plain");
        }
        this.setupRequest("POST");
        this.connection.setDoOutput(true);
        OutputStream os = null;
        os = this.connection.getOutputStream();
        try {
            this.writeBody(os, contents);
            this.getResults();
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException ioexc) {
            throw ioexc;
        }
    }

    public void PUT(String contents, String contentType, String locktoken) throws WDVTestJ_WdvException, IOException {
        this.requestContext.initialize();
        if (contentType != null) {
            this.requestContext.contentType(contentType);
        }
        if (locktoken != null) {
            this.requestContext.precondition("(<" + locktoken + ">)");
        }
        OutputStream os = this.getContentsOutputStream();
        try {
            this.writeBody(os, contents);
            this.getResults();
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException ioexc) {
            throw ioexc;
        }
    }

    public void PUT_chunked(String contents, String contentType, String locktoken) throws WDVTestJ_WdvException, IOException {
        this.requestContext.initialize();
        if (contentType != null) {
            this.requestContext.contentType(contentType);
        }
        if (locktoken != null) {
            this.requestContext.precondition("(<" + locktoken + ">)");
        }
        this.requestContext.contentLength(-1L);
        this.requestContext.transferEncoding("chunked");
        OutputStream os = this.getContentsOutputStream();
        try {
            this.writeBody(os, contents);
            this.getResults();
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException ioexc) {
            throw ioexc;
        }
    }

    public void PUT(URL contents, String contentType, String locktoken) throws WDVTestJ_WdvException, IOException {
        OutputStream os;
        this.requestContext.initialize();
        try {
            if (contentType != null) {
                this.requestContext.contentType(contentType);
            }
            if (locktoken != null) {
                this.requestContext.precondition("(<" + locktoken + ">)");
            }
            os = this.getContentsOutputStream();
        }
        catch (IOException exc) {
            throw new WDVTestJ_WdvException(500, "IO Error");
        }
        try {
            this.writeBody(os, contents);
            this.getResults();
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw exc;
        }
    }

    public void PUTWithNoCheck(String contents, String contentType, String locktoken) throws WDVTestJ_WdvException, IOException {
        OutputStream os;
        this.requestContext.initialize();
        try {
            if (contentType != null) {
                this.requestContext.contentType(contentType);
            }
            if (locktoken != null) {
                this.requestContext.precondition("(<" + locktoken + ">)");
            }
            os = this.getContentsOutputStream();
        }
        catch (IOException exc) {
            throw new WDVTestJ_WdvException(500, "IO Error");
        }
        try {
            this.writeBody(os, contents);
            this.getResults();
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw exc;
        }
    }

    public void PUT() throws WDVTestJ_WdvException, IOException {
        this.requestContext.initialize();
        try {
            this.getContentsOutputStream();
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw exc;
        }
        try {
            this.getResults();
        }
        catch (IOException exc) {
            throw new WDVTestJ_WdvException(500, "IO Error");
        }
    }

    public void MKCOL(String locktoken) throws WDVTestJ_WdvException, IOException {
        this.requestContext.initialize();
        try {
            if (locktoken != null) {
                this.requestContext.precondition("(<" + locktoken + ">)");
            }
            this.setupRequest("MKCOL");
            this.getResults();
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw exc;
        }
    }

    public void DELETE(String locktoken) throws WDVTestJ_WdvException, IOException {
        this.requestContext.initialize();
        try {
            if (locktoken != null) {
                this.requestContext.precondition("(<" + locktoken + ">)");
            }
            this.setupRequest("DELETE");
        }
        catch (IOException exc) {
            throw new WDVTestJ_WdvException(500, "IO Exception");
        }
        try {
            this.getResults();
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw exc;
        }
    }

    public void DELETE(String locktoken, String sapdb_DeletedItems) throws WDVTestJ_WdvException, IOException {
        this.requestContext.initialize();
        try {
            if (locktoken != null) {
                this.requestContext.precondition("(<" + locktoken + ">)");
            }
            if (sapdb_DeletedItems != null) {
                this.requestContext.sapdb_DeletedItems(sapdb_DeletedItems);
            }
            this.setupRequest("DELETE");
        }
        catch (IOException exc) {
            throw new WDVTestJ_WdvException(500, "IO Exception");
        }
        try {
            this.getResults();
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw exc;
        }
    }

    public byte[] COPY(String destUrl, String overwrite, String body, String locktoken) throws WDVTestJ_WdvException, IOException {
        this.requestContext.initialize();
        byte[] cachedContents = null;
        try {
            if (destUrl != null) {
                this.requestContext.destination(destUrl);
            }
            if (overwrite != null) {
                this.requestContext.overwrite(overwrite);
            }
            if (locktoken != null) {
                this.requestContext.precondition("(<" + locktoken + ">)");
            }
            this.setupRequest("COPY");
            if (body != null) {
                this.connection.setDoOutput(true);
                OutputStream os = this.connection.getOutputStream();
                this.writeBody(os, body);
            }
            this.getResults();
            InputStream is = null;
            cachedContents = this.readBody(is);
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw exc;
        }
        return cachedContents;
    }

    public byte[] COPY(String destUrl, String overwrite, String body, String locktoken, String depth) throws WDVTestJ_WdvException, IOException {
        this.requestContext.initialize();
        byte[] cachedContents = null;
        try {
            if (destUrl != null) {
                this.requestContext.destination(destUrl);
            }
            if (overwrite != null) {
                this.requestContext.overwrite(overwrite);
            }
            if (locktoken != null) {
                this.requestContext.precondition("(<" + locktoken + ">)");
            }
            if (depth != null) {
                this.requestContext.depth(depth);
            }
            this.setupRequest("COPY");
            if (body != null) {
                this.connection.setDoOutput(true);
                OutputStream os = this.connection.getOutputStream();
                this.writeBody(os, body);
            }
            this.getResults();
            InputStream is = null;
            cachedContents = this.readBody(is);
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw exc;
        }
        return cachedContents;
    }

    public byte[] MOVE(String destUrl, String overwrite, String body, String locktoken) throws WDVTestJ_WdvException, IOException {
        this.requestContext.initialize();
        byte[] cachedContents = null;
        try {
            if (destUrl != null) {
                this.requestContext.destination(destUrl);
            }
            if (overwrite != null) {
                this.requestContext.overwrite(overwrite);
            }
            if (locktoken != null) {
                this.requestContext.precondition("(<" + locktoken + ">)");
            }
            this.setupRequest("MOVE");
            if (body != null) {
                this.connection.setDoOutput(true);
                OutputStream os = this.connection.getOutputStream();
                this.writeBody(os, body);
            }
            this.getResults();
            InputStream is = null;
            cachedContents = this.readBody(is);
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw exc;
        }
        return cachedContents;
    }

    public byte[] MOVE(String destUrl, String overwrite, String body, String locktoken, String depth) throws WDVTestJ_WdvException, IOException {
        this.requestContext.initialize();
        byte[] cachedContents = null;
        try {
            if (destUrl != null) {
                this.requestContext.destination(destUrl);
            }
            if (overwrite != null) {
                this.requestContext.overwrite(overwrite);
            }
            if (locktoken != null) {
                this.requestContext.precondition("(<" + locktoken + ">)");
            }
            if (depth != null) {
                this.requestContext.depth(depth);
            }
            this.setupRequest("MOVE");
            if (body != null) {
                this.connection.setDoOutput(true);
                OutputStream os = this.connection.getOutputStream();
                this.writeBody(os, body);
            }
            this.getResults();
            InputStream is = null;
            cachedContents = this.readBody(is);
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw exc;
        }
        return cachedContents;
    }

    public void PROPFIND_FILE(String body, String filename) throws WDVTestJ_WdvException {
        this.requestContext.initialize();
        try {
            this.setupRequest("PROPFIND");
            if (body != null) {
                this.connection.setDoOutput(true);
                OutputStream os = this.connection.getOutputStream();
                this.writeBody(os, body);
            }
            this.getResults();
            InputStream is = null;
            byte[] content_body = this.readBody(is);
            File output_file = new File("C:/" + filename);
            FileOutputStream fos = new FileOutputStream(output_file);
            fos.write(content_body);
            fos.flush();
            fos.close();
            output_file.deleteOnExit();
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new WDVTestJ_WdvException(500, "IO Exception");
        }
    }

    public void PROPFIND_FILE(String body, String depth, String filename) throws WDVTestJ_WdvException {
        this.requestContext.initialize();
        try {
            if (depth != null) {
                this.requestContext.depth(depth);
            }
            this.setupRequest("PROPFIND");
            if (body != null) {
                this.connection.setDoOutput(true);
                OutputStream os = this.connection.getOutputStream();
                this.writeBody(os, body);
            }
            this.getResults();
            InputStream is = null;
            byte[] content_body = this.readBody(is);
            File output_file = new File("C:/" + filename);
            FileOutputStream fos = new FileOutputStream(output_file);
            fos.write(content_body);
            fos.flush();
            fos.close();
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new WDVTestJ_WdvException(500, "IO Exception");
        }
    }

    public Document PROPFIND(String body, String depth) throws WDVTestJ_WdvException, SAXException, IOException {
        this.requestContext.initialize();
        Document xmlBody = null;
        try {
            if (depth != null) {
                this.requestContext.depth(depth);
            }
            this.setupRequest("PROPFIND");
            if (body != null) {
                this.connection.setDoOutput(true);
                OutputStream os = this.connection.getOutputStream();
                this.writeBody(os, body);
            }
            this.getResults();
            InputStream is = null;
            xmlBody = this.readXmlBody(is);
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (SAXParseException exc) {
            throw exc;
        }
        catch (SAXException exc) {
            System.out.println("********************Fehler in Parser!!!**********************");
            exc.printStackTrace();
        }
        catch (IOException exc) {
            throw exc;
        }
        return xmlBody;
    }

    public Document PROPFIND(String body) throws WDVTestJ_WdvException, SAXException, IOException {
        this.requestContext.initialize();
        Document xmlBody = null;
        try {
            this.setupRequest("PROPFIND");
            if (body != null) {
                this.connection.setDoOutput(true);
                OutputStream os = this.connection.getOutputStream();
                this.writeBody(os, body);
            }
            this.getResults();
            InputStream is = null;
            xmlBody = this.readXmlBody(is);
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (SAXParseException exc) {
            throw exc;
        }
        catch (SAXException exc) {
            System.out.println("********************Fehler in Parser!!!**********************");
            exc.printStackTrace();
        }
        catch (IOException exc) {
            throw exc;
        }
        return xmlBody;
    }

    public Document PROPPATCH(String body, String locktoken) throws WDVTestJ_WdvException, SAXException, IOException {
        this.requestContext.initialize();
        Document xmlBody = null;
        try {
            if (locktoken != null) {
                this.requestContext.precondition("(<" + locktoken + ">)");
            }
            this.setupRequest("PROPPATCH");
            if (body != null) {
                this.connection.setDoOutput(true);
                OutputStream os = this.connection.getOutputStream();
                this.writeBody(os, body);
            }
            this.getResults();
            InputStream is = null;
            xmlBody = this.readXmlBody(is);
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (SAXParseException exc) {
            throw exc;
        }
        catch (SAXException exc) {
            System.out.println("********************Fehler in Parser!!!**********************");
            exc.printStackTrace();
        }
        catch (IOException exc) {
            throw exc;
        }
        return xmlBody;
    }

    public byte[] HEAD(String body) throws WDVTestJ_WdvException, IOException {
        this.requestContext.initialize();
        byte[] cachedContents = null;
        try {
            this.setupRequest("HEAD");
            if (body != null) {
                this.connection.setDoOutput(true);
                OutputStream os = this.connection.getOutputStream();
                this.writeBody(os, body);
            }
            InputStream is = null;
            this.getResults();
            cachedContents = this.readBody(is);
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (NullPointerException exc) {
        }
        catch (IOException exc) {
            throw exc;
        }
        return cachedContents;
    }

    public Document LOCK(String body, String locktoken) throws WDVTestJ_WdvException, SAXException, IOException {
        this.requestContext.initialize();
        Document xmlBody = null;
        try {
            if (locktoken != null) {
                this.requestContext.precondition("(<" + locktoken + ">)");
            }
            this.requestContext.contentType("text/xml");
            this.setupRequest("LOCK");
            if (body != null) {
                this.connection.setDoOutput(true);
                OutputStream os = this.connection.getOutputStream();
                this.writeBody(os, body);
            }
            this.getResults();
            InputStream is = null;
            xmlBody = this.readXmlBody(is);
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (SAXParseException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw exc;
        }
        return xmlBody;
    }

    public byte[] UNLOCK(String body, String locktoken) throws WDVTestJ_WdvException, IOException {
        this.requestContext.initialize();
        byte[] cachedContents = null;
        try {
            if (locktoken != null) {
                this.requestContext.lockToken(locktoken);
            }
            this.setupRequest("UNLOCK");
            if (body != null) {
                this.connection.setDoOutput(true);
                OutputStream os = this.connection.getOutputStream();
                this.writeBody(os, body);
            }
            this.getResults();
            InputStream is = null;
            cachedContents = this.readBody(is);
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw exc;
        }
        return cachedContents;
    }

    public byte[] UNLOCKMalformed(String body, String locktoken) throws WDVTestJ_WdvException, IOException {
        this.requestContext.initialize();
        byte[] cachedContents = null;
        try {
            if (locktoken != null) {
                this.requestContext.lockTokenFalse(locktoken);
            }
            this.setupRequest("UNLOCK");
            if (body != null) {
                this.connection.setDoOutput(true);
                OutputStream os = this.connection.getOutputStream();
                this.writeBody(os, body);
            }
            this.getResults();
            InputStream is = null;
            cachedContents = this.readBody(is);
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw exc;
        }
        return cachedContents;
    }

    public byte[] OPTIONS(String body) throws WDVTestJ_WdvException, IOException {
        this.requestContext.initialize();
        byte[] cachedContents = null;
        try {
            this.setupRequest("OPTIONS");
            if (body != null) {
                this.connection.setDoOutput(true);
                OutputStream os = this.connection.getOutputStream();
                this.writeBody(os, body);
            }
            this.getResults();
            InputStream is = null;
            cachedContents = this.readBody(is);
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw exc;
        }
        return cachedContents;
    }

    protected void getResults() throws WDVTestJ_WdvException, IOException {
        this.responseContext.initialize();
        String statusMessage = null;
        int responseCode = 0;
        try {
            responseCode = this.connection.getResponseCode();
            this.status.setStatusCode(responseCode);
            statusMessage = this.connection.getResponseMessage();
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw exc;
        }
        if (statusMessage == null || statusMessage.equals("Unknown")) {
            statusMessage = WDVTestJ_WdvStatus.getStatusMessage(this.status.getStatusCode());
        }
        int i = 1;
        String name = null;
        while ((name = this.connection.getHeaderFieldKey(i)) != null) {
            name = name.toLowerCase();
            String value = this.connection.getHeaderField(i);
            this.responseContext.put(name, value);
            ++i;
        }
        if (responseCode >= 300 && responseCode <= 399) {
            throw new WDVTestJ_WdvException(responseCode, statusMessage);
        }
        if (responseCode >= 400 && responseCode <= 499) {
            throw new WDVTestJ_WdvException(responseCode, statusMessage);
        }
        if (responseCode >= 500 && responseCode <= 599) {
            throw new WDVTestJ_WdvException(responseCode, statusMessage);
        }
    }

    protected void setupRequest(String method) throws WDVTestJ_WdvException, IOException {
        try {
            this.connection = (WDVTestJ_WdvHttpConnection)this.url.openConnection();
            this.connection.setRequestMethod(method);
        }
        catch (ProtocolException exc) {
            exc.printStackTrace();
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw exc;
        }
        Enumeration<Object> propertyNames = this.requestContext.keys();
        while (propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            String value = (String)this.requestContext.get(name);
            if (!name.equalsIgnoreCase("content-length") && value.equals("-1")) continue;
            this.connection.setRequestProperty(name, value);
        }
    }

    protected void writeBody(OutputStream os, String body) throws WDVTestJ_WdvException, IOException {
        try {
            if (os == null) {
                os = this.connection.getOutputStream();
            }
            StringReader is = new StringReader(body);
            int ch = -1;
            while ((ch = is.read()) != -1) {
                os.write(ch);
            }
            is.close();
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw exc;
        }
    }

    protected void writeBody(OutputStream os, byte[] body) throws WDVTestJ_WdvException {
        try {
            if (os == null) {
                os = this.connection.getOutputStream();
            }
            for (int i = 0; i <= body.length; ++i) {
                os.write(body[i]);
            }
        }
        catch (IOException exc) {
            throw new WDVTestJ_WdvException(500, "IO Error");
        }
    }

    protected void writeBody(OutputStream os, URL body) throws WDVTestJ_WdvException {
        try {
            if (os == null) {
                os = this.connection.getOutputStream();
            }
            InputStream myIS = body.openStream();
            int ch = -1;
            while ((ch = myIS.read()) != -1) {
                os.write(ch);
            }
            myIS.close();
        }
        catch (IOException exc) {
            throw new WDVTestJ_WdvException(500, "IO Error");
        }
    }

    protected byte[] readBody(InputStream is) throws WDVTestJ_WdvException, IOException {
        byte[] cachedContents = null;
        try {
            if (is == null) {
                is = this.connection.getInputStream();
            }
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException e) {
            throw e;
        }
        try {
            int length = (int)this.responseContext.contentLength();
            if (length != -1) {
                int rcvd = 0;
                int size = 0;
                cachedContents = new byte[length];
                do {
                    rcvd = is.read(cachedContents, size += rcvd, length - size);
                } while (size < length && rcvd != -1);
                if (rcvd == -1) {
                    cachedContents = WDVTestJ_WebDAVCore.resizeArray(cachedContents, size);
                }
            } else {
                cachedContents = new byte[]{};
                int inc = 8192;
                int off = cachedContents.length;
                int rcvd = 0;
                while ((rcvd = is.read(cachedContents = WDVTestJ_WebDAVCore.resizeArray(cachedContents, (off += rcvd) + inc), off, inc)) != -1) {
                }
                cachedContents = WDVTestJ_WebDAVCore.resizeArray(cachedContents, off);
            }
            is.close();
        }
        catch (IOException exc) {
            throw exc;
        }
        catch (NullPointerException e) {
            throw e;
        }
        return cachedContents;
    }

    protected Document readXmlBody(InputStream is, String dtd) throws WDVTestJ_WdvException, IOException {
        File tempBody;
        byte[] cachedContents = null;
        Document xmlBody = null;
        try {
            if (is == null) {
                is = this.connection.getInputStream();
            }
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException e) {
            throw e;
        }
        try {
            tempBody = File.createTempFile("xmlbody", ".xml");
            FileOutputStream fos = new FileOutputStream(tempBody);
            StringReader sis = new StringReader(dtd);
            int ch = -1;
            while ((ch = sis.read()) != -1) {
                fos.write(ch);
            }
            sis.close();
            int length = (int)this.responseContext.contentLength();
            if (length != -1) {
                int rcvd = 0;
                int size = 0;
                cachedContents = new byte[length];
                do {
                    rcvd = is.read(cachedContents, size += rcvd, length - size);
                } while (size < length && rcvd != -1);
                if (rcvd == -1) {
                    cachedContents = WDVTestJ_WebDAVCore.resizeArray(cachedContents, size);
                }
            } else {
                cachedContents = new byte[]{};
                int inc = 8192;
                int off = cachedContents.length;
                int rcvd = 0;
                while ((rcvd = is.read(cachedContents = WDVTestJ_WebDAVCore.resizeArray(cachedContents, (off += rcvd) + inc), off, inc)) != -1) {
                }
                cachedContents = WDVTestJ_WebDAVCore.resizeArray(cachedContents, off);
                for (int i = 0; i < 39; ++i) {
                    cachedContents[i] = 32;
                }
            }
            is.close();
            fos.write(cachedContents);
            fos.close();
        }
        catch (IOException exc) {
            throw new WDVTestJ_WdvException(500, "IO Exception");
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            xmlBody = builder.parse(tempBody);
        }
        catch (FactoryConfigurationError e) {
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXException e) {
        }
        catch (IOException e) {
            System.out.println(e);
        }
        return xmlBody;
    }

    protected Document readXmlBody(InputStream is) throws WDVTestJ_WdvException, SAXException, IOException {
        this.responseContext = new WDVTestJ_WdvHTTPHeaders();
        byte[] cachedContents = null;
        Document xmlBody = null;
        try {
            if (is == null) {
                is = this.connection.getInputStream();
            }
        }
        catch (WDVTestJ_WdvException exc) {
            throw exc;
        }
        catch (IOException e) {
            throw e;
        }
        File tempBody = File.createTempFile("xmlbody", ".xml");
        FileOutputStream fos = new FileOutputStream(tempBody);
        int length = (int)this.responseContext.contentLength();
        if (length != -1) {
            int rcvd = 0;
            int size = 0;
            cachedContents = new byte[length];
            do {
                rcvd = is.read(cachedContents, size += rcvd, length - size);
            } while (size < length && rcvd != -1);
            if (rcvd == -1) {
                cachedContents = WDVTestJ_WebDAVCore.resizeArray(cachedContents, size);
            }
        } else {
            cachedContents = new byte[]{};
            int inc = 8192;
            int off = cachedContents.length;
            int rcvd = 0;
            while ((rcvd = is.read(cachedContents = WDVTestJ_WebDAVCore.resizeArray(cachedContents, (off += rcvd) + inc), off, inc)) != -1) {
            }
            cachedContents = WDVTestJ_WebDAVCore.resizeArray(cachedContents, off);
        }
        is.close();
        fos.write(cachedContents);
        fos.close();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            xmlBody = builder.parse(tempBody);
            tempBody.deleteOnExit();
        }
        catch (FactoryConfigurationError e) {
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            throw e;
        }
        catch (IOException e) {
            System.out.println(e);
        }
        return xmlBody;
    }

    public WDVTestJ_WdvHTTPHeaders getRequestHeaders() {
        return this.requestContext;
    }

    public WDVTestJ_WdvHTTPHeaders getResponseHeaders() {
        return this.responseContext;
    }

    public WDVTestJ_WdvStatus getStatus() {
        return this.status;
    }

    private static final byte[] resizeArray(byte[] src, int new_size) {
        byte[] tmp = new byte[new_size];
        System.arraycopy(src, 0, tmp, 0, src.length < new_size ? src.length : new_size);
        return tmp;
    }

    public WDVTestJ_WebDAVCore createResource(String host, int port, String baseUrl, String url_str) {
        URLStreamHandlerFactory fac = new URLStreamHandlerFactory();
        URLStreamHandler handler = fac.createURLStreamHandler("http");
        WDVTestJ_WebDAVCore resource = null;
        try {
            this.url = new URL("http", host, port, baseUrl + url_str, handler);
            resource = new WDVTestJ_WebDAVCore(this.url);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return resource;
    }

    public boolean exists() {
        try {
            this.HEAD(null);
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() != 404 && exc.getStatusCode() != 423) {
                System.err.println(exc.getStatusCode());
                return false;
            }
            if (exc.getStatusCode() == 404) {
                try {
                    this.PROPFIND("", "0");
                    return true;
                }
                catch (WDVTestJ_WdvException ex) {
                    return ex.getStatusCode() != 404;
                }
                catch (Exception ex) {
                    exc.printStackTrace();
                    return false;
                }
            }
            if (exc.getStatusCode() == 423) {
                return true;
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return true;
    }

    public static boolean createWebDAVSchema(Connection con, String dbversion, String use_servlet) {
        if (!use_servlet.equalsIgnoreCase("T")) {
            try {
                Statement stmt = con.createStatement();
                stmt.executeQuery("SELECT * FROM WEBDAV_INODE");
                return true;
            }
            catch (SQLException e) {
                if (e.getErrorCode() == -4004) {
                    if (dbversion.equals("7.6.00")) {
                        try {
                            Statement stmt = con.createStatement();
                            try {
                                stmt.execute("Drop Table WEBDAV_CONTAINER");
                            }
                            catch (SQLException exc) {
                                // empty catch block
                            }
                            try {
                                stmt.execute("Drop Table WEBDAV_INODE");
                            }
                            catch (SQLException exc) {
                                // empty catch block
                            }
                            try {
                                stmt.execute("Drop Table WEBDAV_NAME_SPACE");
                            }
                            catch (SQLException exc) {
                                // empty catch block
                            }
                            try {
                                stmt.execute("Drop Table WEBDAV_PROPERTY_MANAGEMENT");
                            }
                            catch (SQLException exc) {
                                // empty catch block
                            }
                            try {
                                stmt.execute("Drop Table WEBDAV_PROPERTY");
                            }
                            catch (SQLException exc) {
                                // empty catch block
                            }
                            stmt.execute("Create Table WEBDAV_CONTAINER\t(\t   CId\t\t\t\tChar(24)   Byte,\t   Short_Content\tChar(8000) Byte,\t   Content\t\t\tLong       Byte,\t\t   Primary Key (Cid)\t)");
                            stmt.execute("Create Table WEBDAV_INODE (\t   Pid              Char(24)\t\tByte        ,\t   Cid              Char(24)\t\tByte        ,\t   Name             Char(499)                   ,\t   State\t\t\tFixed(2)\t\tDefault 0\t,\t   XDBDocId          Fixed(20)        Default 0,\t   CompressedLength Fixed(10)\t\tDefault 0   , \t   Primary Key (Pid, Name)                      ,\t   Constraint WEBDAV_INODE_X Unique (Cid))");
                            stmt.execute("Create Table WEBDAV_NAME_SPACE (\t    Id         Char(24)    Byte,\t    Name_Space Char(499)      , \t    Primary Key (Name_Space),\t    Constraint WEBDAV_NAME_SPACE_X Unique (Id))");
                            stmt.execute("Create Table WEBDAV_PROPERTY_MANAGEMENT (\t   Id                Char(24)   Byte,\t   Name_Space_Id     Char(24)   Byte,\t   Name_Prefix       Char(300)      ,\t   Name              Char(2000)     , \t   Primary Key (Name_Space_Id, Name_Prefix))");
                            stmt.execute("Create Table WEBDAV_PROPERTY (\t   CId                  Char(24)  Byte,\t   Property_Id          Char(24)  Byte,\t   Property_Short_Value Char(450)     ,\t   Property_Long_Value  Long      Byte)");
                            stmt.execute("Create Index WEBDAV_PROPERTY_X1 On WEBDAV_PROPERTY (Property_Id, CId)");
                            stmt.execute("Create Index WEBDAV_PROPERTY_X2 On WEBDAV_PROPERTY (Cid DESC)");
                            stmt.execute("Insert into WEBDAV_NAME_SPACE Set  Id = X'000000000000000000000000000000000000000000000001',  Name_Space = 'DAV:'");
                            stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'000000000000000000000000000000000000000000000001',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'displayname'");
                            stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'000000000000000000000000000000000000000000000002',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'resourcetype'");
                            stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'000000000000000000000000000000000000000000000003',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'getcontenttype'");
                            stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'000000000000000000000000000000000000000000000004',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'getcontentlength'");
                            stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'000000000000000000000000000000000000000000000005',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'getlastmodified'");
                            stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'000000000000000000000000000000000000000000000006',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'lockdiscovery'");
                            stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'000000000000000000000000000000000000000000000006',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'lockid'");
                            stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'000000000000000000000000000000000000000000000007',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'lockowner'");
                            stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'000000000000000000000000000000000000000000000008',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'locktype'");
                            stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'000000000000000000000000000000000000000000000009',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'lockscope'");
                            stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'00000000000000000000000000000000000000000000000A',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'locktimeout'");
                            stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'00000000000000000000000000000000000000000000000B',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'lockdepth'");
                            stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'00000000000000000000000000000000000000000000000C',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'supportedlock'");
                            stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'00000000000000000000000000000000000000000000000D',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'docclassid'");
                            stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'00000000000000000000000000000000000000000000000E',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'parsestate'");
                            stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'00000000000000000000000000000000000000000000000F',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'originallocation'");
                            stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'000000000000000000000000000000000000000000000010',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'creationdate'");
                            stmt.execute("Insert into WEBDAV_INODE Set  PId = X'000000000000000000000000000000000000000000000000',  CId = X'000000000000000000000000000000000000000000000001',  Name = 'Deleted Items',  State = 0,  CompressedLength = 0");
                            stmt.execute("Insert into WEBDAV_PROPERTY Set  CId = X'000000000000000000000000000000000000000000000001',  Property_Id = X'000000000000000000000000000000000000000000000001',  Property_Short_Value = 'Deleted Items'");
                            stmt.execute("Insert into WEBDAV_PROPERTY Set  CId = X'000000000000000000000000000000000000000000000001',  Property_Id = X'000000000000000000000000000000000000000000000002',  Property_Short_Value = 'collection'");
                            stmt.execute("Insert into WEBDAV_PROPERTY Set  CId = X'000000000000000000000000000000000000000000000001',  Property_Id = X'000000000000000000000000000000000000000000000003',  Property_Short_Value = 'sapdbwww/directory'");
                            stmt.execute("Insert into WEBDAV_PROPERTY Set  CId = X'000000000000000000000000000000000000000000000001',  Property_Id = X'000000000000000000000000000000000000000000000004',  Property_Short_Value = '0'");
                            stmt.execute("Insert into WEBDAV_PROPERTY Set  CId = X'000000000000000000000000000000000000000000000001',  Property_Id = X'000000000000000000000000000000000000000000000005',  Property_Short_Value = TIMESTAMP");
                            stmt.execute("Insert into WEBDAV_PROPERTY Set  CId = X'000000000000000000000000000000000000000000000001',  Property_Id = X'000000000000000000000000000000000000000000000010',  Property_Short_Value = TIMESTAMP");
                            stmt.execute("Insert into WEBDAV_PROPERTY Set  CId = X'000000000000000000000000000000000000000000000000',  Property_Id = X'000000000000000000000000000000000000000000000001',  Property_Short_Value = '/'");
                            stmt.execute("Insert into WEBDAV_PROPERTY Set  CId = X'000000000000000000000000000000000000000000000000',  Property_Id = X'000000000000000000000000000000000000000000000002',  Property_Short_Value = 'collection'");
                            stmt.execute("Insert into WEBDAV_PROPERTY Set  CId = X'000000000000000000000000000000000000000000000000',  Property_Id = X'000000000000000000000000000000000000000000000003',  Property_Short_Value = 'sapdbwww/directory'");
                            stmt.execute("Insert into WEBDAV_PROPERTY Set  CId = X'000000000000000000000000000000000000000000000000',  Property_Id = X'000000000000000000000000000000000000000000000004',  Property_Short_Value = '0'");
                            stmt.execute("Insert into WEBDAV_PROPERTY Set  CId = X'000000000000000000000000000000000000000000000000',  Property_Id = X'000000000000000000000000000000000000000000000005',  Property_Short_Value = TIMESTAMP");
                            stmt.execute("Insert into WEBDAV_PROPERTY Set  CId = X'000000000000000000000000000000000000000000000000',  Property_Id = X'000000000000000000000000000000000000000000000010',  Property_Short_Value = TIMESTAMP");
                            return true;
                        }
                        catch (SQLException ex) {
                            System.out.println(ex.getMessage());
                            System.out.println(ex.getStackTrace());
                            return false;
                        }
                    }
                    try {
                        Statement stmt = con.createStatement();
                        try {
                            stmt.execute("Drop Table WEBDAV_CONTAINER");
                        }
                        catch (SQLException exc) {
                            // empty catch block
                        }
                        try {
                            stmt.execute("Drop Table WEBDAV_INODE");
                        }
                        catch (SQLException exc) {
                            // empty catch block
                        }
                        try {
                            stmt.execute("Drop Table WEBDAV_NAME_SPACE");
                        }
                        catch (SQLException exc) {
                            // empty catch block
                        }
                        try {
                            stmt.execute("Drop Table WEBDAV_PROPERTY_MANAGEMENT");
                        }
                        catch (SQLException exc) {
                            // empty catch block
                        }
                        try {
                            stmt.execute("Drop Table WEBDAV_PROPERTY");
                        }
                        catch (SQLException exc) {
                            // empty catch block
                        }
                        stmt.execute("Create Table WEBDAV_CONTAINER\t(\t   CId\t\t\t\tChar(24)   Byte,\t   Short_Content\tChar(8000) Byte,\t   Content\t\t\tLong       Byte,\t\t   Primary Key (Cid)\t)");
                        stmt.execute("Create Table WEBDAV_INODE (\t   Pid              Char(24)\t\tByte        ,\t   Cid              Char(24)\t\tByte        ,\t   Name             Char(499)                   ,\t   State\t\t\tFixed(2)\t\tDefault 0\t,\t   CompressedLength Fixed(10)\t\tDefault 0   , \t   Primary Key (Pid, Name)                      ,\t   Constraint WEBDAV_INODE_X Unique (Cid))");
                        stmt.execute("Create Table WEBDAV_NAME_SPACE (\t    Id         Char(24)    Byte,\t    Name_Space Char(499)      , \t    Primary Key (Name_Space),\t    Constraint WEBDAV_NAME_SPACE_X Unique (Id))");
                        stmt.execute("Create Table WEBDAV_PROPERTY_MANAGEMENT (\t   Id                Char(24)   Byte,\t   Name_Space_Id     Char(24)   Byte,\t   Name_Prefix       Char(300)      ,\t   Name              Char(2000)     , \t   Primary Key (Name_Space_Id, Name_Prefix))");
                        stmt.execute("Create Table WEBDAV_PROPERTY (\t   CId                  Char(24)  Byte,\t   Property_Id          Char(24)  Byte,\t   Property_Short_Value Char(450)     ,\t   Property_Long_Value  Long      Byte)");
                        stmt.execute("Create Index WEBDAV_PROPERTY_X1 On WEBDAV_PROPERTY (Property_Id, CId)");
                        stmt.execute("Create Index WEBDAV_PROPERTY_X2 On WEBDAV_PROPERTY (Cid DESC)");
                        stmt.execute("Insert into WEBDAV_NAME_SPACE Set  Id = X'000000000000000000000000000000000000000000000001',  Name_Space = 'DAV:'");
                        stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'000000000000000000000000000000000000000000000001',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'displayname'");
                        stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'000000000000000000000000000000000000000000000002',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'resourcetype'");
                        stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'000000000000000000000000000000000000000000000003',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'getcontenttype'");
                        stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'000000000000000000000000000000000000000000000004',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'getcontentlength'");
                        stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'000000000000000000000000000000000000000000000005',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'getlastmodified'");
                        stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'000000000000000000000000000000000000000000000006',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'lockdiscovery'");
                        stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'000000000000000000000000000000000000000000000006',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'lockid'");
                        stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'000000000000000000000000000000000000000000000007',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'lockowner'");
                        stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'000000000000000000000000000000000000000000000008',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'locktype'");
                        stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'000000000000000000000000000000000000000000000009',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'lockscope'");
                        stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'00000000000000000000000000000000000000000000000A',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'locktimeout'");
                        stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'00000000000000000000000000000000000000000000000B',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'lockdepth'");
                        stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'00000000000000000000000000000000000000000000000C',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'supportedlock'");
                        stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'00000000000000000000000000000000000000000000000D',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'docclassid'");
                        stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'00000000000000000000000000000000000000000000000E',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'parsestate'");
                        stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'00000000000000000000000000000000000000000000000F',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'originallocation'");
                        stmt.execute("Insert into WEBDAV_PROPERTY_MANAGEMENT Set Id = X'000000000000000000000000000000000000000000000010',  Name_Space_Id = X'000000000000000000000000000000000000000000000001',  Name_Prefix = 'creationdate'");
                        stmt.execute("Insert into WEBDAV_INODE Set  PId = X'000000000000000000000000000000000000000000000000',  CId = X'000000000000000000000000000000000000000000000001',  Name = 'Deleted Items',  State = 0,  CompressedLength = 0");
                        stmt.execute("Insert into WEBDAV_PROPERTY Set  CId = X'000000000000000000000000000000000000000000000001',  Property_Id = X'000000000000000000000000000000000000000000000001',  Property_Short_Value = 'Deleted Items'");
                        stmt.execute("Insert into WEBDAV_PROPERTY Set  CId = X'000000000000000000000000000000000000000000000001',  Property_Id = X'000000000000000000000000000000000000000000000002',  Property_Short_Value = 'collection'");
                        stmt.execute("Insert into WEBDAV_PROPERTY Set  CId = X'000000000000000000000000000000000000000000000001',  Property_Id = X'000000000000000000000000000000000000000000000003',  Property_Short_Value = 'sapdbwww/directory'");
                        stmt.execute("Insert into WEBDAV_PROPERTY Set  CId = X'000000000000000000000000000000000000000000000001',  Property_Id = X'000000000000000000000000000000000000000000000004',  Property_Short_Value = '0'");
                        stmt.execute("Insert into WEBDAV_PROPERTY Set  CId = X'000000000000000000000000000000000000000000000001',  Property_Id = X'000000000000000000000000000000000000000000000005',  Property_Short_Value = TIMESTAMP");
                        stmt.execute("Insert into WEBDAV_PROPERTY Set  CId = X'000000000000000000000000000000000000000000000001',  Property_Id = X'000000000000000000000000000000000000000000000010',  Property_Short_Value = TIMESTAMP");
                        stmt.execute("Insert into WEBDAV_PROPERTY Set  CId = X'000000000000000000000000000000000000000000000000',  Property_Id = X'000000000000000000000000000000000000000000000001',  Property_Short_Value = '/'");
                        stmt.execute("Insert into WEBDAV_PROPERTY Set  CId = X'000000000000000000000000000000000000000000000000',  Property_Id = X'000000000000000000000000000000000000000000000002',  Property_Short_Value = 'collection'");
                        stmt.execute("Insert into WEBDAV_PROPERTY Set  CId = X'000000000000000000000000000000000000000000000000',  Property_Id = X'000000000000000000000000000000000000000000000003',  Property_Short_Value = 'sapdbwww/directory'");
                        stmt.execute("Insert into WEBDAV_PROPERTY Set  CId = X'000000000000000000000000000000000000000000000000',  Property_Id = X'000000000000000000000000000000000000000000000004',  Property_Short_Value = '0'");
                        stmt.execute("Insert into WEBDAV_PROPERTY Set  CId = X'000000000000000000000000000000000000000000000000',  Property_Id = X'000000000000000000000000000000000000000000000005',  Property_Short_Value = TIMESTAMP");
                        stmt.execute("Insert into WEBDAV_PROPERTY Set  CId = X'000000000000000000000000000000000000000000000000',  Property_Id = X'000000000000000000000000000000000000000000000010',  Property_Short_Value = TIMESTAMP");
                        return true;
                    }
                    catch (SQLException ex) {
                        System.out.println(ex.getMessage());
                        System.out.println(ex.getStackTrace());
                        return false;
                    }
                }
                return true;
            }
        }
        return true;
    }
}

