/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.unlocktests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.io.IOException;
import java.sql.SQLException;

public class TestUnlock004
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestUnlock004.createWebDAVSchema();
        TestUnlock004.addGlobalMessage((String)("prepare test " + TestUnlock004.getTestClassId()), (char)'I', (String)"UNLOCK a locked file with a wrong Lock-Token");
        host = new String(TestUnlock004.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestUnlock004.getPort();
        baseUrl = TestUnlock004.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestUnlock004.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestUnlock004.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestUnlock004.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestUnlock004.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestUnlock004.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestUnlock004.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestUnlock004.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestUnlock004.addGlobalMessage((String)"1. DELETE resource /TestUnlock004.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (resource.exists()) {
            locktoken = TestUnlock004.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            TestUnlock004.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if (!TestUnlock004.doPut(resource, content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt", contentType = "text/plain", locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        TestUnlock004.doLock(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
        try {
            locktoken = TestUnlock004.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            String false_locktoken = locktoken.substring(0, locktoken.length() - 3) + "123";
            resource.UNLOCK(null, false_locktoken);
            if (resource.getStatus().getStatusCode() != 423) {
                TestUnlock004.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock004.txt with a wrong locktoken", (char)'E', (String)("WebDAV says: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestUnlock004.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock004.txt with a wrong locktoken", (char)'I', (String)"Test failed due to some WebDAV feature!");
                return;
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 423) {
                TestUnlock004.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock004.txt with a wrong locktoken", (char)'I', (String)("Test was successful! Status: " + exc.getStatusCode() + " " + exc.getLocalizedMessage()));
            }
            TestUnlock004.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock004.txt with a wrong locktoken", (char)'E', (String)("WebDAV says: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            TestUnlock004.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock004.txt with a wrong locktoken", (char)'I', (String)"Test failed due to some WebDAV feature.");
            return;
        }
        catch (Exception exc) {
            TestUnlock004.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock004.txt with a wrong locktoken", (char)'E', (String)("Java exception: " + exc.getLocalizedMessage()));
            TestUnlock004.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock004.txt with a wrong locktoken", (char)'I', (String)"Test failed due to some Java feature.");
            return;
        }
        boolean res_exists = false;
        try {
            res_exists = resource.exists();
        }
        catch (NullPointerException e) {
            this.handleExceptions(e);
        }
        if (res_exists) {
            TestUnlock004.addGlobalMessage((String)"5. verify that the resource was not unlocked by deleting it without using a locktoken", (char)'I', (String)"Deleting...");
            try {
                resource.DELETE(null);
            }
            catch (WDVTestJ_WdvException wdvexc) {
                if (wdvexc.getStatusCode() == 423) {
                    TestUnlock004.addGlobalMessage((String)"Could not delete resource", (char)'I', (String)"Resource is still locked. Test was successful!");
                } else {
                    TestUnlock004.addGlobalMessage((String)"verifying was not successful", (char)'E', (String)("WebDAV returned: " + wdvexc.getStatusCode() + " " + wdvexc.getMessage()));
                }
            }
            catch (IOException exc) {
                this.handleExceptions(exc);
            }
        }
    }

    public static void cleanUp() throws TestCaseException {
        if (resource.exists()) {
            locktoken = TestUnlock004.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            TestUnlock004.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }
}

