/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.unlocktests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestUnlock003
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestUnlock003.createWebDAVSchema();
        TestUnlock003.addGlobalMessage((String)("prepare test " + TestUnlock003.getTestClassId()), (char)'I', (String)"UNLOCK a locked file with a malformed Lock-Token header");
        host = new String(TestUnlock003.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestUnlock003.getPort();
        baseUrl = TestUnlock003.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestUnlock003.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestUnlock003.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestUnlock003.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestUnlock003.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestUnlock003.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestUnlock003.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestUnlock003.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource.exists()) {
            locktoken = TestUnlock003.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            TestUnlock003.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if (!TestUnlock003.doPut(resource, content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt", contentType = "text/plain", locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        TestUnlock003.doLock(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
        try {
            locktoken = TestUnlock003.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            resource.UNLOCKMalformed(null, locktoken + ">ghgd");
            if (TestUnlock003.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("F")) {
                if (resource.getStatus().getStatusCode() != 400) {
                    TestUnlock003.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock003.txt with a malformed locktoken header", (char)'E', (String)("WebDAV says: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                    TestUnlock003.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock003.txt with a malformed locktoken header", (char)'I', (String)"Test failed due to some WebDAV feature!");
                    return;
                }
            } else if (resource.getStatus().getStatusCode() != 423) {
                TestUnlock003.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock003.txt with a malformed locktoken header", (char)'E', (String)("WebDAV says: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestUnlock003.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock003.txt with a malformed locktoken header", (char)'I', (String)"Test failed due to some WebDAV feature!");
                return;
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (TestUnlock003.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("F")) {
                if (exc.getStatusCode() == 400) {
                    TestUnlock003.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock003.txt with a malformed locktoken header", (char)'I', (String)("Test was successful! Status: " + exc.getStatusCode() + " " + exc.getLocalizedMessage()));
                }
                TestUnlock003.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock003.txt with a malformed locktoken header", (char)'E', (String)("WebDAV says: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestUnlock003.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock003.txt with a malformed locktoken header", (char)'I', (String)"Test failed due to some WebDAV feature. Expected: 400 Bad Request.");
                return;
            }
            if (exc.getStatusCode() == 423) {
                TestUnlock003.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock003.txt with a malformed locktoken header", (char)'I', (String)("Test was successful! Status: " + exc.getStatusCode() + " " + exc.getLocalizedMessage()));
            }
            TestUnlock003.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock003.txt with a malformed locktoken header", (char)'E', (String)("WebDAV says: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            TestUnlock003.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock003.txt with a malformed locktoken header", (char)'I', (String)"Test failed due to some WebDAV feature. Expected: 400 Bad Request.");
            return;
        }
        catch (Exception exc) {
            TestUnlock003.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock003.txt with a malformed locktoken header", (char)'E', (String)("Java exception: " + exc.getLocalizedMessage()));
            TestUnlock003.addGlobalMessage((String)"4. UNLOCK the file /TestUnlock003.txt with a malformed locktoken header", (char)'I', (String)"Test failed due to some Java feature.");
            return;
        }
        boolean res_exists = false;
        try {
            res_exists = resource.exists();
        }
        catch (NullPointerException e) {
            this.handleExceptions(e);
        }
        if (res_exists) {
            TestUnlock003.addGlobalMessage((String)"5. verify that the resource was not unlocked by deleting it without using a locktoken", (char)'I', (String)"Deleting...");
            try {
                resource.DELETE(null);
                if (resource.getStatus().getStatusCode() != 423) {
                    TestUnlock003.addGlobalMessage((String)"5. verify that the resource was not unlocked by deleting it without using a locktoken", (char)'E', (String)"DELETE was possible. Test failed.");
                    return;
                }
            }
            catch (WDVTestJ_WdvException exc) {
                if (exc.getStatusCode() == 423) {
                    TestUnlock003.addGlobalMessage((String)"5. verify that the resource was not unlocked by deleting it without using a locktoken", (char)'I', (String)(exc.getStatusCode() + " " + exc.getMessage() + ". Test successful!"));
                }
                TestUnlock003.addGlobalMessage((String)"5. verify that the resource was not unlocked by deleting it without using a locktoken", (char)'E', (String)("Webdav says: " + exc.getStatusCode() + " " + exc.getMessage()));
                TestUnlock003.addGlobalMessage((String)"5. verify that the resource was not unlocked by deleting it without using a locktoken", (char)'I', (String)"Test failed due to some WebDAV feature.");
                return;
            }
            catch (Exception exc) {
                TestUnlock003.addGlobalMessage((String)"5. verify that the resource was not unlocked by deleting it without using a locktoken", (char)'E', (String)("Java exception: " + exc));
                TestUnlock003.addGlobalMessage((String)"call DELETE method", (char)'I', (String)"Test failed due to some Java feature");
                return;
            }
        }
    }

    public static void cleanUp() throws TestCaseException {
        if (resource.exists()) {
            locktoken = TestUnlock003.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            TestUnlock003.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }
}

