/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.puttests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;

public class TestPut010
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static boolean TEST_WAS_OK = true;

    public static void prepare() throws TestCaseException {
        TestPut010.createWebDAVSchema();
        TestPut010.addGlobalMessage((String)("prepare test " + TestPut010.getTestClassId()), (char)'I', (String)"****************************************************************************************************************************************\n* put on a not existing resource with 'contenttype' - property values that have to be declined by the server (type-part of contenttype)*\n****************************************************************************************************************************************");
        host = new String(TestPut010.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPut010.getPort();
        baseUrl = TestPut010.getParameterString((String)"baseUrl", (String)"/webdav");
        start_server = TestPut010.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPut010.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPut010.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPut010.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPut010.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on WDV_PORT " + WDV_PORT);
        }
        urlStr = new String("/TestPut010.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut010.addGlobalMessage((String)"1. DELETE the resource /TestPut010.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestPut010.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        Vector<Character> restrictedSigns = new Vector<Character>();
        restrictedSigns.add(new Character(' '));
        restrictedSigns.add(new Character('('));
        restrictedSigns.add(new Character(')'));
        restrictedSigns.add(new Character(','));
        restrictedSigns.add(new Character('/'));
        for (int j = 58; j <= 64; ++j) {
            restrictedSigns.add(new Character((char)j));
        }
        restrictedSigns.add(new Character('['));
        restrictedSigns.add(new Character('\\'));
        restrictedSigns.add(new Character(']'));
        restrictedSigns.add(new Character('{'));
        restrictedSigns.add(new Character('}'));
        restrictedSigns.add(new Character('\u007f'));
        if (System.getProperty("os.name").startsWith("Windows")) {
            restrictedSigns.add(new Character('\u008c'));
        }
        Vector<String> typeVector = new Vector<String>(10, 5);
        int i = 0;
        Enumeration typeEnum = restrictedSigns.elements();
        while (typeEnum.hasMoreElements()) {
            char typeSign = ((Character)typeEnum.nextElement()).charValue();
            if (typeSign != ' ') {
                typeVector.add(typeSign + "text/");
            }
            typeVector.add("te" + typeSign + "xt/");
            typeVector.add("text" + typeSign + "/");
            Enumeration enum1 = typeVector.elements();
            while (enum1.hasMoreElements() && TEST_WAS_OK) {
                String typeString = (String)enum1.nextElement();
                String subtypeString = "plain";
                content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
                contentType = typeString + subtypeString;
                contentLength = content.length();
                try {
                    for (int l = 0; l < 1000000; ++l) {
                    }
                    resource.PUT(content, contentType, locktoken);
                    if (resource.getStatus().getStatusCode() >= 400) continue;
                    TestPut010.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr + " with content-type = '" + typeString + subtypeString + "'"), (char)'E', (String)("WebDAV status: '" + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "'\n" + "'Type' - ASCII code is: " + new Integer(typeSign) + "\n"));
                    TEST_WAS_OK = false;
                }
                catch (WDVTestJ_WdvException exc) {
                    if (exc.getStatusCode() != 400) {
                        TestPut010.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr + " with content-type = '" + typeString + subtypeString + "'"), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                        TestPut010.addGlobalMessage((String)"PUT failed due to some WebDAV feature", (char)'I', (String)"Expected result: 400 Bad Request");
                        TEST_WAS_OK = false;
                        return;
                    }
                    if (exc.getStatusCode() != 400) continue;
                    TEST_WAS_OK = true;
                }
                catch (IOException exc) {
                    System.out.println("ContentType:" + contentType + " (No. " + i + ")");
                    TestPut010.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr + " with content-type = '" + typeString + subtypeString + "'"), (char)'W', (String)("Java exception: " + exc.getMessage() + "\n" + "This defect is caused by an socket connection error of the Java testframe. This is not a WebDAV server exception."));
                    this.handleExceptions(exc);
                    TEST_WAS_OK = false;
                    return;
                }
            }
            typeVector.clear();
        }
    }

    public static void cleanUp() throws TestCaseException {
        if (!TEST_WAS_OK) {
            return;
        }
        urlStr = new String("/TestPut010.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut010.addGlobalMessage((String)"3. DELETE the resource /TestPut010.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestPut010.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        if (TEST_WAS_OK) {
            TestPut010.addGlobalMessage((String)"Test status", (char)'I', (String)"Test was OK.");
        } else {
            TestPut010.addGlobalMessage((String)"Test status", (char)'I', (String)"Test failed.");
        }
    }
}

