/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.puttests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestPut006
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestPut006.createWebDAVSchema();
        TestPut006.addGlobalMessage((String)("prepare test " + TestPut006.getTestClassId()), (char)'I', (String)"put on a not existing resource in a not existing folder");
        host = new String(TestPut006.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPut006.getPort();
        baseUrl = TestPut006.getParameterString((String)"baseUrl", (String)"/webdav");
        start_server = TestPut006.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPut006.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPut006.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPut006.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPut006.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on WDV_PORT " + WDV_PORT);
        }
        urlStr = "/TestPut006.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut006.addGlobalMessage((String)"1. DELETE the resource /TestPut006.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestPut006.doDelete(resource, locktoken, host + ":" + WDV_PORT + "/" + baseUrl + urlStr);
    }

    public void run() {
        urlStr = "/TestPut006/TestPut006.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut006.addGlobalMessage((String)"2. PUT a resource to a folder that doesn't exist", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        try {
            resource.PUT(content, contentType, locktoken);
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() != 409) {
                TestPut006.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + " Expected result: 409 Conflict"));
                TestPut006.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature");
                return;
            }
            TestPut006.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test was successful");
        }
        catch (Exception exc) {
            TestPut006.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc));
            return;
        }
    }

    public static void cleanUp() throws TestCaseException {
        TestPut006.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

