/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.proppatchtests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class TestProppatch015
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlDocument = null;
    static Node property_node = null;

    public static void prepare() throws TestCaseException {
        TestProppatch015.createWebDAVSchema();
        TestProppatch015.addGlobalMessage((String)("prepare test " + TestProppatch015.getTestClassId()), (char)'I', (String)"try to do the 'set'-operation on all live properties (must fail)");
        host = new String(TestProppatch015.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestProppatch015.getPort();
        baseUrl = TestProppatch015.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestProppatch015.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestProppatch015.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestProppatch015.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestProppatch015.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestProppatch015.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestProppatch015.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestProppatch015.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestProppatch015.addGlobalMessage((String)"1. DELETE the resource /TestProppatch015.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestProppatch015.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        Vector<String[]> liveprop_names = new Vector<String[]>();
        String[] tagnameAndValue = new String[]{"getetag", "W"};
        liveprop_names.addElement(tagnameAndValue);
        String[] tagnameAndValue1 = new String[]{"lockdiscovery", "hier darf nichts ver\u00e4ndert werden"};
        liveprop_names.addElement(tagnameAndValue1);
        String[] tagnameAndValue2 = new String[]{"resourcetype", "text"};
        liveprop_names.addElement(tagnameAndValue2);
        String[] tagnameAndValue3 = new String[]{"source", "http://www.source_wird_ver\u00e4ndert.de"};
        liveprop_names.addElement(tagnameAndValue3);
        String[] tagnameAndValue4 = new String[]{"supportedlock", "hier darf nichts ver\u00e4ndert werden"};
        liveprop_names.addElement(tagnameAndValue4);
        Enumeration en = liveprop_names.elements();
        while (en.hasMoreElements()) {
            String[] tagnameAndValue_str = (String[])en.nextElement();
            String tagName = tagnameAndValue_str[0];
            String tagValue = tagnameAndValue_str[1];
            content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
            contentType = "text/plain";
            contentLength = content.length();
            TestProppatch015.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
            String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
            body = body + "\n<D:propertyupdate xmlns:D=\"DAV:\"";
            body = body + "\nxmlns:Z=\"DAV:\">";
            body = body + "\n<D:set>";
            body = body + "\n<D:prop>";
            body = body + "\n<Z:" + tagName + ">" + tagValue + "</Z:" + tagName + ">";
            body = body + "\n</D:prop>";
            body = body + "\n</D:set>";
            body = body + "\n</D:propertyupdate>";
            try {
                xmlDocument = resource.PROPPATCH(body, null);
            }
            catch (WDVTestJ_WdvException exc) {
                TestProppatch015.addGlobalMessage((String)"try to do the 'set'-operation on all live properties (must fail)", (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestProppatch015.addGlobalMessage((String)"try to do the 'set'-operation on all live properties (must fail)", (char)'I', (String)"expected result: 207 Multi Status");
                TestProppatch015.addGlobalMessage((String)"BODY: ", (char)'I', (String)body);
                return;
            }
            catch (SAXParseException exc) {
                TestProppatch015.addGlobalMessage((String)"try to do the 'set'-operation on all live properties (must fail)", (char)'E', (String)("parser says: " + exc.getMessage()));
                TestProppatch015.addGlobalMessage((String)"try to do the 'set'-operation on all live properties (must fail)", (char)'I', (String)("request body: " + body));
                return;
            }
            catch (Exception exc) {
                TestProppatch015.addGlobalMessage((String)"try to do the 'set'-operation on all live properties (must fail)", (char)'E', (String)("Java exception: " + exc));
                this.handleExceptions(exc);
                TestProppatch015.addGlobalMessage((String)"try to do the 'set'-operation on all live properties (must fail)", (char)'I', (String)"Test failed due to some Java feature");
                return;
            }
            if (resource.getStatus().getStatusCode() == 207) {
                try {
                    NodeList nl = xmlDocument.getElementsByTagName(tagName);
                    property_node = nl.item(0);
                }
                catch (NullPointerException exc) {
                    TestProppatch015.addGlobalMessage((String)("5. check if the property status of '" + tagName + "' is \"HTTP/1.1 409 Conflict\""), (char)'E', (String)"the 'getcontenttype'-element for the resource could not be retrieved");
                }
                String status = null;
                status = xmlDocument.getElementsByTagName("D:status").item(0).getFirstChild().getNodeValue();
                if (status.startsWith("HTTP/1.1 409")) {
                    TestProppatch015.addGlobalMessage((String)("5. check if the property status of '" + tagName + "' is \"HTTP/1.1 409\""), (char)'I', (String)"test succeeded!");
                } else {
                    TestProppatch015.addGlobalMessage((String)("5. check if the property status of '" + tagName + "' is \"HTTP/1.1 409\""), (char)'E', (String)"test failed due to some WebDAV feature");
                    TestProppatch015.addGlobalMessage((String)("5. check if the property status of '" + tagName + "' is \"HTTP/1.1 409\""), (char)'I', (String)("Status: " + status));
                }
            }
            if (resource.getStatus().getStatusCode() != 207 && resource.getStatus().getStatusCode() < 400 && resource.getStatus().getStatusCode() > 200) {
                TestProppatch015.addGlobalMessage((String)"try to do the 'set'-operation on all live properties (must fail)", (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestProppatch015.addGlobalMessage((String)"try to do the 'set'-operation on all live properties (must fail)", (char)'I', (String)"expected result: 207 Multi-Status");
            }
            TestProppatch015.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestProppatch015.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestProppatch015.addGlobalMessage((String)"6. clean up and DELETE the resource /TestProppatch015.txt at baseUrl", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestProppatch015.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

