/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.proppatchtests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class TestProppatch014
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlDocument = null;
    static Node getcontenttype_node = null;

    public static void prepare() throws TestCaseException {
        TestProppatch014.createWebDAVSchema();
        TestProppatch014.addGlobalMessage((String)("prepare test " + TestProppatch014.getTestClassId()), (char)'I', (String)"try to patch the the 'getcontent-type'-property with some values, the server must decline");
        host = new String(TestProppatch014.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestProppatch014.getPort();
        baseUrl = TestProppatch014.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestProppatch014.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestProppatch014.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestProppatch014.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestProppatch014.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestProppatch014.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestProppatch014.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestProppatch014.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestProppatch014.addGlobalMessage((String)"1. DELETE the resource /TestProppatch014.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestProppatch014.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        Vector<String> restrictedSigns = new Vector<String>();
        restrictedSigns.add(new Character('(').toString());
        restrictedSigns.add(new Character(')').toString());
        restrictedSigns.add(new Character(',').toString());
        restrictedSigns.add(new Character('/').toString());
        restrictedSigns.add(new Character(':').toString());
        restrictedSigns.add(new Character(';').toString());
        restrictedSigns.add(new Character('=').toString());
        restrictedSigns.add(new Character('@').toString());
        restrictedSigns.add(new Character('[').toString());
        restrictedSigns.add(new Character('\\').toString());
        restrictedSigns.add(new Character(']').toString());
        restrictedSigns.add(new Character('{').toString());
        restrictedSigns.add(new Character('}').toString());
        restrictedSigns.add(new Character('\u007f').toString());
        Vector<String> typeVector = new Vector<String>(10, 5);
        Vector<String> subtypeVector = new Vector<String>(10, 5);
        Enumeration e = restrictedSigns.elements();
        while (e.hasMoreElements()) {
            String sign = (String)e.nextElement();
            typeVector.add(sign + "text/");
            typeVector.add("te" + sign + "xt/");
            typeVector.add("text" + sign + "/");
            subtypeVector.add(sign + "plain");
            subtypeVector.add("pl" + sign + "ain");
            subtypeVector.add("plain" + sign + "");
        }
        typeVector.add("text/");
        typeVector.add("text /");
        subtypeVector.add(" plain");
        Enumeration enum1 = typeVector.elements();
        while (enum1.hasMoreElements()) {
            String typeString = (String)enum1.nextElement();
            Enumeration enum2 = subtypeVector.elements();
            while (enum2.hasMoreElements()) {
                String subtypeString = (String)enum2.nextElement();
                content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
                contentType = "text/plain";
                contentLength = content.length();
                try {
                    resource.PUT(content, contentType, locktoken);
                }
                catch (WDVTestJ_WdvException exc) {
                    TestProppatch014.addGlobalMessage((String)"2. PUT of resource /TestProppatch014.txt at baseUrl failed!", (char)'E', (String)"Test cannot be finished!!");
                    return;
                }
                catch (Exception e2) {
                    this.handleExceptions(e2);
                }
                String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
                body = body + "\n<D:propertyupdate xmlns:D=\"DAV:\"";
                body = body + "\nxmlns:Z=\"DAV:\">";
                body = body + "\n<D:set>";
                body = body + "\n<D:prop>";
                body = body + "\n<Z:getcontenttype>" + typeString + subtypeString + "</Z:getcontenttype>";
                body = body + "\n</D:prop>";
                body = body + "\n</D:set>";
                body = body + "\n</D:propertyupdate>";
                try {
                    xmlDocument = resource.PROPPATCH(body, null);
                }
                catch (WDVTestJ_WdvException exc) {
                    TestProppatch014.addGlobalMessage((String)"PROPPATCH (set) the write-enabled live prop 'getcontenttype'", (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "\n" + "expected result: 207 Multi Status\n" + "Test will be aborted.\n\n" + "BODY: \n" + body + "\n" + "See PTS message: http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1128004"));
                    return;
                }
                catch (SAXParseException exc) {
                    TestProppatch014.addGlobalMessage((String)"PROPPATCH (set) the write-enabled live prop 'getcontenttype'", (char)'E', (String)("parser says: " + exc.getMessage()));
                    TestProppatch014.addGlobalMessage((String)"PROPPATCH (set) the write-enabled live prop 'getcontenttype'", (char)'I', (String)("request body: " + body));
                }
                catch (Exception exc) {
                    TestProppatch014.addGlobalMessage((String)"PROPPATCH (set) the write-enabled live prop 'getcontenttype'", (char)'E', (String)("Java exception: " + exc));
                    exc.printStackTrace();
                    TestProppatch014.addGlobalMessage((String)"PROPPATCH (set) the write-enabled live prop 'getcontenttype'", (char)'I', (String)"Test failed due to some Java feature");
                }
                if (resource.getStatus().getStatusCode() == 207) {
                    try {
                        NodeList nl = xmlDocument.getElementsByTagName("s1:getcontenttype");
                        if (nl.item(0) == null) {
                            nl = xmlDocument.getElementsByTagName("N:getcontenttype");
                        }
                        getcontenttype_node = nl.item(0);
                    }
                    catch (NullPointerException exc) {
                        TestProppatch014.addGlobalMessage((String)"5. check if the property status of 'getcontenttype' is \"HTTP/1.1 409\"", (char)'E', (String)"the 'getcontenttype'-element for the resource could not be retrieved");
                    }
                    String status = null;
                    try {
                        status = !TestProppatch014.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("T") ? getcontenttype_node.getParentNode().getNextSibling().getFirstChild().getNodeValue().toString() : getcontenttype_node.getParentNode().getNextSibling().getNextSibling().getFirstChild().getNodeValue().toString();
                        if (!status.startsWith("HTTP/1.1 409")) {
                            TestProppatch014.addGlobalMessage((String)"5. check if the property status of 'getcontenttype' is \"HTTP/1.1 409\"", (char)'E', (String)"test failed due to some WebDAV feature");
                            TestProppatch014.addGlobalMessage((String)"5. check if the property status of 'getcontenttype' is \"HTTP/1.1 409\"", (char)'I', (String)("Status: " + status + "\n contentType:" + typeString + subtypeString));
                        }
                    }
                    catch (NullPointerException npex) {
                        TestProppatch014.addGlobalMessage((String)"5. check if the property status of 'getcontenttype' is \"HTTP/1.1 409\"", (char)'E', (String)"Java NullPointer Exception occured! Test cannot be finished.");
                        return;
                    }
                    String contentTypeR = TestProppatch014.doPropfindByTagName(resource, "getcontenttype", host + ":" + WDV_PORT + baseUrl + urlStr);
                    if (!contentType.equalsIgnoreCase(contentTypeR)) {
                        TestProppatch014.addGlobalMessage((String)"6. check if the content type was not overwritten", (char)'E', (String)"test was NOT successfull");
                        TestProppatch014.addGlobalMessage((String)"6. check if the content type was not overwritten", (char)'I', (String)("posted: " + contentType + ", received: " + contentTypeR));
                    }
                }
                if (resource.getStatus().getStatusCode() != 207 && resource.getStatus().getStatusCode() < 400) {
                    TestProppatch014.addGlobalMessage((String)"PROPPATCH (set) the write-enabled live prop 'getcontenttype'", (char)'E', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                    TestProppatch014.addGlobalMessage((String)"PROPPATCH (set) the write-enabled live prop 'getcontenttype'", (char)'I', (String)"expected result: 207 Multi-Status");
                }
                try {
                    resource.DELETE(locktoken);
                }
                catch (WDVTestJ_WdvException exc) {
                    TestProppatch014.addGlobalMessage((String)("7. DELETE of " + resource.toString() + " failed"), (char)'E', (String)"Test cannot be finished!");
                    return;
                }
                catch (IOException exc) {
                    this.handleExceptions(exc);
                }
            }
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e3) {
                TestProppatch014.handleGlobalExceptions((Exception)e3);
            }
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestProppatch014.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestProppatch014.addGlobalMessage((String)"8. clean up and DELETE the resource /TestProppatch014.txt at baseUrl", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestProppatch014.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

