/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.proppatchtests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class TestProppatch002
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource_a = null;
    static WDVTestJ_WebDAVCore resource_b = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlDocument_a = null;
    static Document xmlDocument_b = null;
    static Node creationdate_node_a = null;
    static Node creationdate_node_b = null;

    public static void prepare() throws TestCaseException {
        TestProppatch002.createWebDAVSchema();
        TestProppatch002.addGlobalMessage((String)("prepare test " + TestProppatch002.getTestClassId()), (char)'I', (String)"remove the live property 'creationdate' (use of two different empty tags)");
        host = new String(TestProppatch002.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestProppatch002.getPort();
        baseUrl = TestProppatch002.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestProppatch002.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestProppatch002.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestProppatch002.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestProppatch002.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestProppatch002.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestProppatch002.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestProppatch002a.txt");
        resource_a = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource_a == null) {
            TestProppatch002.addGlobalMessage((String)"1. DELETE the resource /TestProppatch002a.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestProppatch002.doDelete(resource_a, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestProppatch002.doPut(resource_a, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestProppatch002b.txt");
        resource_b = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource_b == null) {
            TestProppatch002.addGlobalMessage((String)"1. DELETE the resource /TestProppatch002b.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestProppatch002.doDelete(resource_b, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        TestProppatch002.doPut(resource_b, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        String body_a = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        body_a = body_a + "\n<D:propertyupdate xmlns:D=\"DAV:\"";
        body_a = body_a + "\nxmlns:Z=\"DAV:\">";
        body_a = body_a + "\n<D:remove>";
        body_a = body_a + "\n<D:prop>";
        body_a = body_a + "\n<Z:creationdate/>";
        body_a = body_a + "\n</D:prop>";
        body_a = body_a + "\n</D:remove>";
        body_a = body_a + "\n</D:propertyupdate>";
        String body_b = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        body_b = body_b + "\n<D:propertyupdate xmlns:D=\"DAV:\"";
        body_b = body_b + "\nxmlns:Z=\"DAV:\">";
        body_b = body_b + "\n<D:remove>";
        body_b = body_b + "\n<D:prop>";
        body_b = body_b + "\n<Z:creationdate></Z:creationdate>";
        body_b = body_b + "\n</D:prop>";
        body_b = body_b + "\n</D:remove>";
        body_b = body_b + "\n</D:propertyupdate>";
        try {
            TestProppatch002.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'creationdate'", (char)'I', (String)"empty tag: '<Z:creationdate/>'");
            xmlDocument_a = resource_a.PROPPATCH(body_a, null);
        }
        catch (WDVTestJ_WdvException exc) {
            TestProppatch002.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'creationdate'", (char)'E', (String)("status: " + resource_a.getStatus().getStatusCode() + " " + resource_a.getStatus().getStatusMessage()));
            TestProppatch002.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'creationdate'", (char)'I', (String)"test failed due to some WebDAV feature");
            TestProppatch002.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'creationdate'", (char)'I', (String)"expected result: 207 Multi-Status");
        }
        catch (SAXParseException exc) {
            TestProppatch002.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'creationdate'", (char)'E', (String)("parser says: " + exc.getMessage()));
            TestProppatch002.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'creationdate'", (char)'I', (String)("request body: " + body_a));
        }
        catch (Exception exc) {
            TestProppatch002.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'creationdate'", (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestProppatch002.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'creationdate'", (char)'I', (String)"Test failed due to some Java feature");
        }
        TestProppatch002.addGlobalMessage((String)"check if the property status of 'creationdate' is \"HTTP/1.1 409\"", (char)'I', (String)"empty tag: '<Z:creationdate/>'");
        if (resource_a.getStatus().getStatusCode() == 207) {
            try {
                NodeList nl_a = xmlDocument_a.getElementsByTagName("D:propstat");
                creationdate_node_a = nl_a.item(0);
            }
            catch (NullPointerException exc) {
                TestProppatch002.addGlobalMessage((String)"check if the property status of 'creationdate' is \"HTTP/1.1 409\"", (char)'E', (String)"the 'creationdate'-element for the resource_a could not be retrieved");
            }
            if (xmlDocument_a.getElementsByTagName("D:status").item(0).getFirstChild().getNodeValue().startsWith("HTTP/1.1 409")) {
                TestProppatch002.addGlobalMessage((String)"check if the property status of 'creationdate' is \"HTTP/1.1 409\"", (char)'I', (String)"test succeeded!");
            } else {
                TestProppatch002.addGlobalMessage((String)"check if the property status of 'creationdate' is \"HTTP/1.1 409\"", (char)'E', (String)"test failed due to some WebDAV features");
            }
        } else {
            TestProppatch002.addGlobalMessage((String)"Status '207 Multi-Session' expected", (char)'E', (String)("actual status: " + resource_a.getStatus().getStatusCode() + " " + resource_a.getStatus().getStatusMessage()));
        }
        try {
            TestProppatch002.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'creationdate'", (char)'I', (String)"empty tag: '<Z:creationdate></Z:creationdate>'");
            xmlDocument_b = resource_b.PROPPATCH(body_b, null);
        }
        catch (WDVTestJ_WdvException exc) {
            TestProppatch002.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'creationdate'", (char)'E', (String)("status: " + resource_b.getStatus().getStatusCode() + " " + resource_b.getStatus().getStatusMessage()));
            TestProppatch002.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'creationdate'", (char)'I', (String)"test failed due to some WebDAV feature");
            TestProppatch002.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'creationdate'", (char)'I', (String)"expected result: 207 Multi-Status");
        }
        catch (SAXParseException exc) {
            TestProppatch002.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'creationdate'", (char)'E', (String)("parser says: " + exc.getMessage()));
            TestProppatch002.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'creationdate'", (char)'I', (String)("request body: " + body_b));
        }
        catch (Exception exc) {
            TestProppatch002.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'creationdate'", (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestProppatch002.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'creationdate'", (char)'I', (String)"Test failed due to some Java feature");
        }
        TestProppatch002.addGlobalMessage((String)"check if the property status of 'creationdate' is \"HTTP/1.1 409\"", (char)'I', (String)"empty tag: '<Z:creationdate></Z:creationdate>'");
        if (resource_b.getStatus().getStatusCode() == 207) {
            try {
                NodeList nl_b = xmlDocument_b.getElementsByTagName("creationdate");
                creationdate_node_b = nl_b.item(0);
            }
            catch (NullPointerException exc) {
                TestProppatch002.addGlobalMessage((String)"check if the property status of 'creationdate' is \"HTTP/1.1 409\"", (char)'E', (String)"the 'creationdate'-element for the resource_b could not be retrieved");
            }
            if (xmlDocument_b.getElementsByTagName("D:status").item(0).getFirstChild().getNodeValue().startsWith("HTTP/1.1 409")) {
                TestProppatch002.addGlobalMessage((String)"check if the property status of 'creationdate' is \"HTTP/1.1 409\"", (char)'I', (String)"test succeeded!");
            } else {
                TestProppatch002.addGlobalMessage((String)"check if the property status of 'creationdate' is \"HTTP/1.1 409\"", (char)'E', (String)"test failed due to some WebDAV features");
            }
        } else {
            TestProppatch002.addGlobalMessage((String)"Status '207 Multi-Session' expected", (char)'E', (String)("actual status: " + resource_b.getStatus().getStatusCode() + " " + resource_b.getStatus().getStatusMessage()));
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestProppatch002a.txt");
        resource_b = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource_b == null) {
            TestProppatch002.addGlobalMessage((String)"6. clean up and DELETE the resource /TestProppatch002a.txt at baseUrl ", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestProppatch002.doDelete(resource_b, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestProppatch002b.txt");
        resource_b = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource_b == null) {
            TestProppatch002.addGlobalMessage((String)"7. clean up and DELETE the resource /TestProppatch002b.txt at baseUrl ", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestProppatch002.doDelete(resource_b, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

