/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.propfindtests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestPropfind012
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlDocument = null;
    static Node property_node = null;
    static Properties lockProps = null;

    public static void prepare() throws TestCaseException {
        TestPropfind012.createWebDAVSchema();
        TestPropfind012.addGlobalMessage((String)("prepare test " + TestPropfind012.getTestClassId()), (char)'I', (String)"**************************************************************************\n* create a resource and check whether the properties 'locktype',         *\n* 'lockscope', 'depth', 'owner', 'timeout' and 'locktoken'\t\t\t\t  *\n* supplied by lockdiscovery-PROPFIND are correct or not                  *\n**************************************************************************");
        host = new String(TestPropfind012.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPropfind012.getPort();
        baseUrl = TestPropfind012.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestPropfind012.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestPropfind012.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPropfind012.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPropfind012.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPropfind012.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPropfind012.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestPropfind012.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPropfind012.addGlobalMessage((String)"1. DELETE the resource /TestPropfind012.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        locktoken = TestPropfind012.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
        TestPropfind012.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestPropfind012.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        TestPropfind012.doLock(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
        lockProps = new Properties();
        lockProps.put("locktype", "write");
        lockProps.put("lockscope", "exclusive");
        lockProps.put("depth", "infinity");
        lockProps.put("owner", "D041249");
        if (TestPropfind012.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("T")) {
            lockProps.put("timeout", "Second-604800");
        } else {
            lockProps.put("timeout", "600");
        }
        lockProps.put("locktoken", TestPropfind012.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr));
    }

    public void run() {
        String body = new String("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
        body = body + "\n<D:propfind xmlns:D=\"DAV:\">";
        body = body + "\n<D:prop>";
        body = body + "\n<D:lockdiscovery/>";
        body = body + "\n</D:prop>";
        body = body + "\n</D:propfind>";
        try {
            xmlDocument = resource.PROPFIND(body);
            TestPropfind012.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"results are going to be compared to posted data");
        }
        catch (WDVTestJ_WdvException exc) {
            TestPropfind012.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestPropfind012.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature");
            exc.printStackTrace();
        }
        catch (Exception exc) {
            TestPropfind012.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestPropfind012.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Preparations failed due to some Java feature");
        }
        Enumeration<Object> e = lockProps.keys();
        while (e.hasMoreElements()) {
            String tempPropName = (String)e.nextElement();
            try {
                NodeList nl = xmlDocument.getElementsByTagName("D:" + tempPropName);
                if (nl.getLength() == 0) {
                    nl = xmlDocument.getElementsByTagName(tempPropName);
                }
                property_node = nl.item(0);
            }
            catch (NullPointerException exc) {
                TestPropfind012.addGlobalMessage((String)("retrieving the '" + tempPropName + "'-element"), (char)'E', (String)("the '" + tempPropName + "'-element of the resource could not be retrieved"));
            }
            if (xmlDocument.getElementsByTagName("D:status").item(0).getFirstChild().getNodeValue().equalsIgnoreCase("HTTP/1.1 200 OK")) {
                String expectedValue;
                String receivedValue;
                if (tempPropName.equalsIgnoreCase("locktype") || tempPropName.equalsIgnoreCase("lockscope")) {
                    try {
                        receivedValue = property_node.getFirstChild().getLocalName().toString();
                        expectedValue = lockProps.getProperty(tempPropName).toString();
                        if (receivedValue.compareToIgnoreCase(expectedValue) == 0) {
                            TestPropfind012.addGlobalMessage((String)("comparing the expected and the received " + tempPropName + " - value"), (char)'I', (String)"test was succesful");
                        } else {
                            TestPropfind012.addGlobalMessage((String)("comparing the expected and the received " + tempPropName + " - value"), (char)'E', (String)"test failed");
                            TestPropfind012.addGlobalMessage((String)("comparing the expected and the received " + tempPropName + " - value"), (char)'I', (String)("expected: " + expectedValue + "\n" + "received: " + receivedValue));
                        }
                    }
                    catch (NullPointerException npexc) {
                        TestPropfind012.addGlobalMessage((String)("receiving the value of the '" + tempPropName + "'-node of the resource"), (char)'E', (String)("value of '" + tempPropName + "'-node is not set"));
                    }
                }
                if (tempPropName.equalsIgnoreCase("locktoken")) {
                    try {
                        receivedValue = property_node.getFirstChild().getFirstChild().getNodeValue().toString();
                        expectedValue = lockProps.getProperty(tempPropName).toString();
                        if (receivedValue.compareToIgnoreCase(expectedValue) == 0) {
                            TestPropfind012.addGlobalMessage((String)("comparing the expected and the received " + tempPropName + " - value"), (char)'I', (String)"test was succesful");
                        } else {
                            TestPropfind012.addGlobalMessage((String)("comparing the expected and the received " + tempPropName + " - value"), (char)'E', (String)"test failed");
                            TestPropfind012.addGlobalMessage((String)("comparing the expected and the received " + tempPropName + " - value"), (char)'I', (String)("expected: " + expectedValue + "\n" + "received: " + receivedValue));
                        }
                    }
                    catch (NullPointerException npexc) {
                        TestPropfind012.addGlobalMessage((String)("receiving the value of the '" + tempPropName + "'-node of the resource"), (char)'E', (String)("value of '" + tempPropName + "'-node is not set"));
                    }
                }
                if (!tempPropName.equalsIgnoreCase("depth") && !tempPropName.equalsIgnoreCase("owner") && !tempPropName.equalsIgnoreCase("timeout")) continue;
                try {
                    receivedValue = property_node.getFirstChild().getNodeValue().toString();
                    expectedValue = lockProps.getProperty(tempPropName).toString();
                    if (receivedValue.compareToIgnoreCase(expectedValue) == 0) {
                        TestPropfind012.addGlobalMessage((String)("comparing the expected and the received " + tempPropName + " - value"), (char)'I', (String)"test was succesful");
                        continue;
                    }
                    TestPropfind012.addGlobalMessage((String)("comparing the expected and the received " + tempPropName + " - value"), (char)'E', (String)"test failed");
                    TestPropfind012.addGlobalMessage((String)("comparing the expected and the received " + tempPropName + " - value"), (char)'I', (String)("expected: " + expectedValue + "\n" + "received: " + receivedValue));
                }
                catch (NullPointerException npexc) {
                    TestPropfind012.addGlobalMessage((String)("receiving the value of the '" + tempPropName + "'-node of the resource"), (char)'E', (String)("value of '" + tempPropName + "'-node is not set"));
                }
                continue;
            }
            TestPropfind012.addGlobalMessage((String)("receiving '" + tempPropName + "'-node of the resource"), (char)'E', (String)("'" + tempPropName + "'-node is not existing"));
        }
        if (resource.getStatus().getStatusCode() != 207) {
            TestPropfind012.addGlobalMessage((String)"checking the received status code", (char)'E', (String)("WebDAV code: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            TestPropfind012.addGlobalMessage((String)"checking the received status code", (char)'I', (String)"207 Multistatus expected");
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestPropfind012.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPropfind012.addGlobalMessage((String)"4. clean up and DELETE the resource /TestPropfind012.txt at baseUrl", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        locktoken = TestPropfind012.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
        TestPropfind012.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

