/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.propfindtests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import org.w3c.dom.Document;

public class TestPropfind004
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlbody = null;

    public static void prepare() throws TestCaseException {
        TestPropfind004.createWebDAVSchema();
        TestPropfind004.addGlobalMessage((String)("prepare test " + TestPropfind004.getTestClassId()), (char)'I', (String)"*********************************************************\n* Propfind on the baseUrl for the element 'displayname' *\n*********************************************************");
        host = new String(TestPropfind004.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPropfind004.getPort();
        baseUrl = TestPropfind004.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestPropfind004.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestPropfind004.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPropfind004.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPropfind004.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPropfind004.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPropfind004.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        urlStr = new String("/");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        String body = new String("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
        body = body + new String("<D:propfind xmlns:D=\"DAV:\">\n");
        body = body + new String("<D:prop>\n");
        body = body + new String("<D:displayname/>\n");
        body = body + new String("</D:prop>\n");
        body = body + new String("</D:propfind>\n");
        try {
            resource.PROPFIND(body, "infinity");
        }
        catch (WDVTestJ_WdvException exc) {
            TestPropfind004.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "\n" + "Test failed due to some WebDAV feature"));
        }
        catch (Exception exc) {
            TestPropfind004.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc + "\n" + "Preparations failed due to some Java feature"));
        }
        if (resource.getStatus().getStatusCode() != 207) {
            TestPropfind004.addGlobalMessage((String)"checking the received status code", (char)'E', (String)("WebDAV code: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "\n" + "'207 Multistatus' expected"));
        }
    }

    public static void cleanUp() throws TestCaseException {
    }
}

