/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.movetests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;

public class TestMove006
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static String depth = null;

    public static void prepare() throws TestCaseException {
        TestMove006.createWebDAVSchema();
        TestMove006.addGlobalMessage((String)("prepare test " + TestMove006.getTestClassId()), (char)'I', (String)"*********************************************************\n* Move a collection with subfolders and resources using *\n* explicitly the depth header = 1                       *\n*********************************************************");
        host = new String(TestMove006.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestMove006.getPort();
        baseUrl = TestMove006.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestMove006.getParameterString((String)"var_overwrite", (String)"F");
        depth = "1";
        start_server = TestMove006.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestMove006.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestMove006.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestMove006.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestMove006.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestMove006");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove006.addGlobalMessage((String)"1. DELETE /tempMove006 and /TestMove006 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMove006.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempMove006");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove006.addGlobalMessage((String)"1. DELETE /tempMove006 and /TestMove006 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMove006.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestMove006");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove006.addGlobalMessage((String)"2. create the folder /TestMove006 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestMove006.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/tempMove006");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove006.addGlobalMessage((String)"2. create the folder /tempMove006 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMove006.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempMove006/folder006");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove006.addGlobalMessage((String)"3. create sub-folder /folder006 at /tempMove006", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMove006.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempMove006/res006.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove006.addGlobalMessage((String)"4. create resource /res006.txt at /tempMove006", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        TestMove006.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempMove006/folder006/res006.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove006.addGlobalMessage((String)"5. create resource /res006.txt at /tempMove006/folder006", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        TestMove006.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        urlStr = new String("/tempMove006");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove006.addGlobalMessage((String)"6. MOVE the collection /tempMove006 to /TestMove006 with depth = 1", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        try {
            String dest_Url = new URL("http", host, WDV_PORT, baseUrl + "/TestMove006/tempMove006").toString();
            String body = null;
            locktoken = null;
            TestMove006.doMove(resource, dest_Url, var_overwrite, body, locktoken, depth);
        }
        catch (MalformedURLException exc) {
            TestMove006.addGlobalMessage((String)"6. MOVE the collection /tempMove006 to /TestMove006 with depth = 1", (char)'E', (String)"Test failed due to some Java-URL feature");
        }
        urlStr = new String("/TestMove006/tempMove006");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove006.addGlobalMessage((String)"7. test, if the collection /TestMove006/tempMove006 doesn't exist", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        try {
            String contentR = new String(resource.GET());
            if (contentR != null) {
                TestMove006.addGlobalMessage((String)"collection /TestMove006/tempMove006 must not exist", (char)'E', (String)"collection /TestMove006/tempMove006/folder006 was copied, despite of depth = '1'");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 404) {
                TestMove006.addGlobalMessage((String)"collection /TestMove006/tempMove006 must not exist", (char)'I', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                TestMove006.addGlobalMessage((String)"Check succeeded", (char)'I', (String)"Expected result: 404 Not Found");
            } else {
                TestMove006.addGlobalMessage((String)("CHECK: GET http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                exc.printStackTrace();
                TestMove006.addGlobalMessage((String)"Test failed due to some WebDAV feature", (char)'I', (String)"Expected result: 404 Not Found");
            }
        }
        catch (Exception exc) {
            TestMove006.addGlobalMessage((String)("CHECK: GET http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestMove006.addGlobalMessage((String)"Test failed due to some Java feature", (char)'I', (String)"Skipping test");
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestMove006");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove006.addGlobalMessage((String)"8. CleanUp and DELETE /tempMove006 and /TestMove006 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMove006.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempMove006");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove006.addGlobalMessage((String)"8. CleanUp and DELETE /tempMove006 and /TestMove006 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMove006.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

