/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.movetests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;

public class TestMove005
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static String depth = null;

    public static void prepare() throws TestCaseException {
        TestMove005.createWebDAVSchema();
        TestMove005.addGlobalMessage((String)("prepare test " + TestMove005.getTestClassId()), (char)'I', (String)"************************************************************************\n* Move collection with sub-folders and resource and depth - header = 0 *\n************************************************************************");
        host = new String(TestMove005.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestMove005.getPort();
        baseUrl = TestMove005.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestMove005.getParameterString((String)"var_overwrite", (String)"F");
        depth = "0";
        start_server = TestMove005.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestMove005.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestMove005.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestMove005.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestMove005.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestMove005");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove005.addGlobalMessage((String)"1. DELETE /tempMove005 and /TestMove005 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMove005.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempMove005");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove005.addGlobalMessage((String)"1. DELETE /tempMove005 and /TestMove005 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMove005.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestMove005");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove005.addGlobalMessage((String)"2. create the folder /TestMove005 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestMove005.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/tempMove005");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove005.addGlobalMessage((String)"2. create the folder /tempMove005 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMove005.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempMove005/folder005");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove005.addGlobalMessage((String)"3. create sub-folder /folder005 at /tempMove005", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMove005.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempMove005/res005.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove005.addGlobalMessage((String)"4. create resource /res005.txt at /tempMove005", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        TestMove005.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempMove005/folder005/res005.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove005.addGlobalMessage((String)"5. create resource /res005.txt at /tempMove005/folder005", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        TestMove005.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        urlStr = new String("/tempMove005");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove005.addGlobalMessage((String)"6. MOVE the collection /tempMove005 to /TestMove005 with depth = 0", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        try {
            String dest_Url = new URL("http", host, WDV_PORT, baseUrl + "/TestMove005/tempMove005").toString();
            String body = null;
            locktoken = null;
            TestMove005.doMove(resource, dest_Url, var_overwrite, body, locktoken, depth);
        }
        catch (MalformedURLException exc) {
            TestMove005.addGlobalMessage((String)"6. MOVE the collection /tempMove005 to /TestMove005 with depth = 0", (char)'E', (String)"Test failed due to some Java-URL feature");
        }
        urlStr = new String("/TestMove005/tempMove005");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove005.addGlobalMessage((String)"7. test, if the collection /TestMove005/tempMove005 doesn't exist", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        try {
            String contentR = new String(resource.GET());
            if (contentR != null) {
                TestMove005.addGlobalMessage((String)"collection /TestMove005/tempMove005 must not exist", (char)'E', (String)"collection /TestMove005/tempMove005/folder005 was copied, despite of depth = '0'");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 404) {
                TestMove005.addGlobalMessage((String)"collection /TestMove005/tempMove005 must not exist", (char)'I', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                TestMove005.addGlobalMessage((String)"Check succeeded", (char)'I', (String)"Expected result: 404 Not Found");
            } else {
                TestMove005.addGlobalMessage((String)("CHECK: GET http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                exc.printStackTrace();
                TestMove005.addGlobalMessage((String)"Test failed due to some WebDAV feature", (char)'I', (String)"Expected result: 404 Not Found");
            }
        }
        catch (Exception exc) {
            TestMove005.addGlobalMessage((String)("CHECK: GET http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestMove005.addGlobalMessage((String)"Test failed due to some Java feature", (char)'I', (String)"Skipping test");
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestMove005");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove005.addGlobalMessage((String)"8. CleanUp and DELETE /tempMove005 and /TestMove005 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMove005.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempMove005");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove005.addGlobalMessage((String)"8. CleanUp and DELETE /tempMove005 and /TestMove005 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMove005.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

