/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.movetests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;

public class TestMove002
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static String dest_Url;

    public static void prepare() throws TestCaseException {
        TestMove002.createWebDAVSchema();
        TestMove002.addGlobalMessage((String)("prepare test " + TestMove002.getTestClassId()), (char)'I', (String)"************************************************************************************************\n* Copy resources to an existing collection and move the resource to the same folder afterwards *\n************************************************************************************************");
        host = new String(TestMove002.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestMove002.getPort();
        baseUrl = TestMove002.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestMove002.getParameterString((String)"var_overwrite", (String)"T");
        start_server = TestMove002.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestMove002.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestMove002.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestMove002.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestMove002.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = "/TestMove002";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove002.addGlobalMessage((String)"1. DELETE folder /TestMove002 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        TestMove002.doDelete(resource, locktoken, host + WDV_PORT + baseUrl + urlStr);
        if (!TestMove002.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = "/TestMove002/TestMove002.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove002.addGlobalMessage((String)"3. creating a resource", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        locktoken = null;
        TestMove002.doPut(resource, content, contentType, locktoken, host + WDV_PORT + baseUrl + urlStr);
        urlStr = "/TestMove002/sub_folder";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove002.addGlobalMessage((String)"4. create a sub-folder where the resource shall be copied to", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        TestMove002.doMkCol(resource, locktoken, host + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        urlStr = "/TestMove002/TestMove002.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove002.addGlobalMessage((String)"5. copy the resource to the previously created sub_folder", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        try {
            dest_Url = new URL("http", host, WDV_PORT, baseUrl + "/TestMove002/sub_folder/TestMove002.txt").toString();
            String overwrite = var_overwrite;
            String body = null;
            locktoken = null;
            TestMove002.doCopy(resource, dest_Url, overwrite, body, locktoken, null);
        }
        catch (Exception exc) {
            // empty catch block
        }
        String new_content = new String("Die Sch\u00e4fchen sind nun schlafen gegangen");
        String new_contentType = new String(contentType);
        long new_contentLength = new_content.length();
        TestMove002.doPut(resource, new_content, new_contentType, locktoken, host + WDV_PORT + baseUrl + urlStr);
        try {
            dest_Url = new URL("http", host, WDV_PORT, baseUrl + "/TestMove002/sub_folder/TestMove002.txt").toString();
        }
        catch (MalformedURLException exc) {
            exc.printStackTrace();
            TestMove002.addGlobalMessage((String)"Creating the destination URL", (char)'E', (String)"An Exception occured during the creation of the destination URL");
        }
        try {
            String overwrite = var_overwrite;
            String body = null;
            locktoken = null;
            TestMove002.addGlobalMessage((String)"Moving file", (char)'I', (String)("overwrite = '" + overwrite + "'"));
            resource.MOVE(dest_Url, overwrite, body, locktoken);
        }
        catch (WDVTestJ_WdvException exc) {
            if (var_overwrite == "T") {
                TestMove002.addGlobalMessage((String)("MOVE TO http://" + host + ":" + WDV_PORT + baseUrl + "/TestMove002/sub_folder/TestMove002.txt"), (char)'E', (String)("  WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "\n" + "Expected result: '201 Created'\n" + "Test failed due to some WebDAV feature."));
            } else if (exc.getStatusCode() == 412) {
                TestMove002.addGlobalMessage((String)"MOVE", (char)'I', (String)"Resource could not be moved with overwrite header 'F' and destination not null.......OK");
            } else {
                TestMove002.addGlobalMessage((String)("MOVE TO http://" + host + ":" + WDV_PORT + baseUrl + "/TestMove002/sub_folder/TestMove002.txt"), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "\n" + "Expected result: '412 Precondition Failed'\n" + "Test failed due to some WebDAV feature."));
            }
        }
        catch (Exception exc) {
            TestMove002.addGlobalMessage((String)("MOVE TO http://" + host + ":" + WDV_PORT + baseUrl + "/TestMove002/sub_folder/TestMove002.txt"), (char)'E', (String)("Java exception: " + exc));
        }
        if (var_overwrite == "T") {
            try {
                String contentR = new String(resource.GET());
                if (contentR != null) {
                    TestMove002.addGlobalMessage((String)"Check (source deleted)", (char)'E', (String)"...failed. There is still data in the source directory.");
                }
            }
            catch (WDVTestJ_WdvException exc) {
                if (exc.getStatusCode() == 404) {
                    TestMove002.addGlobalMessage((String)"Test (source deleted)", (char)'I', (String)"...OK");
                }
            }
            catch (IOException exc) {
                this.handleExceptions(exc);
            }
            urlStr = "/TestMove002/sub_folder/TestMove002.txt";
            resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
            if (resource == null) {
                TestMove002.addGlobalMessage((String)"check if the destination resource has the correct content data", (char)'E', (String)"Test failed due to some Java feature");
            }
            TestMove002.compareContent(resource, new_content, new_contentType, new_contentLength, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if (var_overwrite == "F") {
            urlStr = "/TestMove002/TestMove002.txt";
            resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
            if (resource == null) {
                TestMove002.addGlobalMessage((String)"compare the new content and the new source resource", (char)'E', (String)"Preparations failed due to some Java feature");
            }
            TestMove002.compareContent(resource, new_content, new_contentType, new_contentLength, host + ":" + WDV_PORT + baseUrl + urlStr);
            urlStr = "/TestMove002/sub_folder/TestMove002.txt";
            resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
            if (resource == null) {
                TestMove002.addGlobalMessage((String)"check if the destination resource still exists", (char)'E', (String)"Test failed due to some Java feature");
            }
            TestMove002.compareContent(resource, content, contentType, contentLength, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }

    public static void cleanUp() throws TestCaseException {
        TestMove002.addGlobalMessage((String)("cleaning up test " + TestMove002.getTestClassId()), (char)'I', (String)"move to an existing resource");
        urlStr = "/TestMove002";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove002.addGlobalMessage((String)"7. DELETE folder /TestMove002 at baseUrl", (char)'E', (String)"Cleaning up failed due to some Java feature");
        }
        TestMove002.doDelete(resource, locktoken, host + ":" + WDV_PORT + "/" + baseUrl + urlStr);
    }
}

