/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.movetests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;

public class TestMove001
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestMove001.createWebDAVSchema();
        TestMove001.addGlobalMessage((String)("prepare test " + TestMove001.getTestClassId()), (char)'I', (String)"*********************************************\n* Move resources to an existing collection. *\n*********************************************");
        host = new String(TestMove001.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestMove001.getPort();
        baseUrl = TestMove001.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestMove001.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestMove001.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestMove001.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestMove001.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestMove001.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestMove001.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        TestMove001.addGlobalMessage((String)("prepare test " + TestMove001.getTestClassId()), (char)'I', (String)"move to an existing resource");
        urlStr = "/TestMove001";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove001.addGlobalMessage((String)"1. DELETE folder /TestMove001 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        TestMove001.doDelete(resource, locktoken, host + ":" + WDV_PORT + "/" + baseUrl + urlStr);
        if (!TestMove001.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = "/TestMove001/TestMove001.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove001.addGlobalMessage((String)"3. create a resource - this is still preparation", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        TestMove001.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + "/" + baseUrl + urlStr);
        urlStr = "/TestMove001/sub_folder";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove001.addGlobalMessage((String)"4. create a sub-folder where the resource shall be moved to", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        TestMove001.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        urlStr = "/TestMove001/TestMove001.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove001.addGlobalMessage((String)"5. move the resource to the sub-folder", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        try {
            String dest_Url = new URL("http", host, WDV_PORT, baseUrl + "/TestMove001/sub_folder/TestMove001.txt").toString();
            String overwrite = var_overwrite;
            String body = null;
            locktoken = null;
            TestMove001.addGlobalMessage((String)"Moving file", (char)'I', (String)("overwrite = '" + overwrite + "'"));
            TestMove001.doMove(resource, dest_Url, overwrite, body, locktoken, null);
        }
        catch (Exception exc) {
            TestMove001.addGlobalMessage((String)("MOVE TO http://" + host + ":" + WDV_PORT + baseUrl + "/TestMove001/sub_folder/TestMove001.txt"), (char)'E', (String)("Java exception: " + exc + "\n" + "Test failed due to some Java feature"));
        }
        urlStr = "/TestMove001/TestMove001.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove001.addGlobalMessage((String)"6. check the results of the test", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        if (var_overwrite == "T") {
            try {
                if (resource.GET() != null) {
                    TestMove001.addGlobalMessage((String)"7. was the resource deleted in the source directory as it was moved?", (char)'E', (String)"The source file still exists.");
                }
            }
            catch (WDVTestJ_WdvException exc) {
                if (exc.getStatusCode() == 404) {
                    TestMove001.addGlobalMessage((String)"7. was the resource deleted in the source directory as it was moved?", (char)'I', (String)"The source file was deleted.OK.");
                }
            }
            catch (IOException exc) {
                this.handleExceptions(exc);
            }
        }
        if ((resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr = "/TestMove001/sub_folder/TestMove001.txt")) == null) {
            TestMove001.addGlobalMessage((String)"8. ccompare contents", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        TestMove001.compareContent(resource, content, contentType, contentLength, host + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = "/TestMove001";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove001.addGlobalMessage((String)"1. DELETE folder /TestMove001 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature");
        }
        TestMove001.doDelete(resource, locktoken, host + ":" + WDV_PORT + "/" + baseUrl + urlStr);
    }
}

