/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.locktests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestLock001
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestLock001.createWebDAVSchema();
        TestLock001.addGlobalMessage((String)("prepare test " + TestLock001.getTestClassId()), (char)'I', (String)"lock a file and try to do a put on it without a locktoken");
        host = new String(TestLock001.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestLock001.getPort();
        baseUrl = TestLock001.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestLock001.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestLock001.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestLock001.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestLock001.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestLock001.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestLock001.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestLock001.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock001.addGlobalMessage((String)"1. DELETE resource /TestLock001.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (resource.exists()) {
            locktoken = TestLock001.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock001.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }

    public void run() {
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        try {
            resource.PUT(content, contentType, locktoken);
            TestLock001.addGlobalMessage((String)"2. PUT resource /TestLock001.txt to baseUrl", (char)'I', (String)("WebDAV code: " + resource.getStatus().getStatusCode()));
        }
        catch (WDVTestJ_WdvException exc) {
            TestLock001.addGlobalMessage((String)"2. PUT resource /TestLock001.txt to baseUrl", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestLock001.addGlobalMessage((String)"2. PUT resource /TestLock001.txt to baseUrl", (char)'I', (String)"Test failed due to some WebDAV feature");
        }
        catch (Exception exc) {
            TestLock001.addGlobalMessage((String)"2. PUT resource /TestLock001.txt to baseUrl", (char)'E', (String)("Java exception: " + exc.getMessage()));
            TestLock001.addGlobalMessage((String)"2. PUT resource /TestLock001.txt to baseUrl", (char)'I', (String)"Test failed due to some Java feature");
        }
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";
        body = body + "<D:lockinfo xmlns:D=\"DAV:\">\n";
        body = body + "<D:locktype>\n";
        body = body + "<D:write/>\n";
        body = body + "</D:locktype>\n";
        body = body + "<D:lockscope>\n";
        body = body + "<D:exclusive/>\n";
        body = body + "</D:lockscope>\n";
        body = body + "<D:owner>D041249</D:owner>\n";
        body = body + "</D:lockinfo>\n";
        try {
            resource.LOCK(body, null);
            TestLock001.addGlobalMessage((String)"3. LOCK the resource /TestLock001.txt", (char)'I', (String)("resource status is '" + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "'"));
        }
        catch (WDVTestJ_WdvException exc) {
            TestLock001.addGlobalMessage((String)"3. LOCK the resource /TestLock001.txt", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestLock001.addGlobalMessage((String)"3. LOCK the resource /TestLock001.txt", (char)'I', (String)"Test failed due to some WebDAV feature.");
        }
        catch (Exception exc) {
            TestLock001.addGlobalMessage((String)"3. LOCK the resource /TestLock001.txt", (char)'E', (String)("Java exception: " + exc.getMessage()));
            TestLock001.addGlobalMessage((String)"3. LOCK the resource /TestLock001.txt", (char)'I', (String)"Test failed due to some Java feature.");
        }
        try {
            resource.PUT(content, contentType, null);
            if (resource.getStatus().getStatusCode() < 423) {
                TestLock001.addGlobalMessage((String)"4. PUT the file TestLock001.txt again without a locktoken", (char)'E', (String)("WebDAV code: " + resource.getStatus().getStatusCode() + "expected: 423 Locked"));
                TestLock001.addGlobalMessage((String)"4. PUT the file TestLock001.txt again without a locktoken", (char)'I', (String)"Test failed due to some WebDAV feature");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 423) {
                TestLock001.addGlobalMessage((String)"4. PUT the file TestLock001.txt again without a locktoken", (char)'I', (String)("Test was successful! WebDAV said: " + exc.getStatusCode() + " " + exc.getMessage()));
            } else {
                TestLock001.addGlobalMessage((String)"4. PUT the file TestLock001.txt again without a locktoken", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                TestLock001.addGlobalMessage((String)"4. PUT the file TestLock001.txt again without a locktoken", (char)'I', (String)"Test failed due to some WebDAV feature");
            }
        }
        catch (Exception exc) {
            TestLock001.addGlobalMessage((String)"4. PUT the file TestLock001.txt again without a locktoken", (char)'E', (String)("Java exception: " + exc.getMessage()));
            TestLock001.addGlobalMessage((String)"4. PUT the file TestLock001.txt again without a locktoken", (char)'I', (String)"Test failed due to some Java feature");
        }
    }

    public static void cleanUp() throws TestCaseException {
        if (resource.exists()) {
            locktoken = TestLock001.getLockToken(resource, host + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock001.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }
}

