/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.gettests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestGet013
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = "";
    static String contentType = null;
    static int contentLength = 0;
    static String expectedContent = "";
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestGet013.createWebDAVSchema();
        TestGet013.addGlobalMessage((String)("prepare test " + TestGet013.getTestClassId()), (char)'I', (String)"*************************************************************\n* GET on an existing file and receiving of the chunked data *\n*************************************************************");
        host = new String(TestGet013.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestGet013.getPort();
        baseUrl = TestGet013.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestGet013.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestGet013.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestGet013.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestGet013.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestGet013.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestGet013.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "' (before DELETE)");
        }
        urlStr = "/TestGet013.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestGet013.addGlobalMessage((String)"1. DELETE /TestGet013.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestGet013.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "' (at DELETE)");
        }
        expectedContent = content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt! ";
        contentLength = content.length();
        contentType = "text/plain";
        try {
            resource.PUT(content, contentType, locktoken);
            if (resource.getStatus().getStatusCode() == 201 || resource.getStatus().getStatusCode() == 204) {
                TestGet013.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Successful!");
            } else {
                TestGet013.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)("NOT Successful!\nStatus Code: " + resource.getStatus().getStatusCode()));
            }
        }
        catch (WDVTestJ_WdvException exc) {
            TestGet013.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + "\n" + "Expected result: 201 Created"));
        }
        catch (Exception exc) {
            TestGet013.handleGlobalExceptions((Exception)exc);
        }
    }

    public void run() {
        try {
            if (!TestGet013.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("T")) {
                String receivedContent = new String(resource.GET_Chunked());
                if (!resource.getResponseHeaders().transferEncoding().equalsIgnoreCase("chunked")) {
                    TestGet013.addGlobalMessage((String)"3. Call the GET method for the resource to receive the chunked body.", (char)'W', (String)"The expected transfer encoding header 'chunked' could not be found.\nThe test will be aborted...\nPlease refer to the PTS-message: http:///webpts?wptsdetail=yes&ErrorType=1&ErrorID=1129854");
                    return;
                }
                if (!content.equalsIgnoreCase(receivedContent)) {
                    TestGet013.addGlobalMessage((String)"3.2 Compare the posted and the received content", (char)'E', (String)("The received content: \n'" + receivedContent + "'" + "\n doesn't equal the expected content: " + "\n'" + content + "'"));
                } else {
                    TestGet013.addGlobalMessage((String)"Comparing the received and the expected data", (char)'I', (String)"Test was successful!");
                }
            }
        }
        catch (WDVTestJ_WdvException exc) {
            TestGet013.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestGet013.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'I', (String)"Test failed due to some WebDAV feature.");
        }
        catch (Exception exc) {
            TestGet013.addGlobalMessage((String)"Get the chunked content from the server", (char)'I', (String)"An error occured!");
            this.handleExceptions(exc);
        }
    }

    public static void cleanUp() throws TestCaseException {
        TestGet013.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

