/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.gettests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestGet006
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = "";
    static String contentType = null;
    static String expectedContent = "";
    static String locktoken = null;
    static String contentRange = null;

    public static void prepare() throws TestCaseException {
        TestGet006.createWebDAVSchema();
        TestGet006.addGlobalMessage((String)("prepare test " + TestGet006.getTestClassId()), (char)'I', (String)"***********************************************************************************************\n* get on an existing file to get the first 500 Bytes of its content (HTTP/1.1 Statuscode 206) *\n***********************************************************************************************");
        host = new String(TestGet006.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestGet006.getPort();
        baseUrl = TestGet006.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestGet006.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestGet006.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestGet006.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestGet006.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestGet006.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestGet006.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = "/TestGet006.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestGet006.addGlobalMessage((String)"1. DELETE /TestGet006.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestGet006.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        while (content.length() < 1000) {
            content = content + "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt! ";
        }
        contentType = "text/plain";
        expectedContent = content.substring(0, 500);
        if (!TestGet006.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        contentRange = "bytes=0-499";
        try {
            String receivedContent = new String(resource.GET(contentRange));
            if (resource.getStatus().getStatusCode() == 206) {
                if (receivedContent.equals(expectedContent)) {
                    TestGet006.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'I', (String)("Status Code is '" + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "' and the received content equals the expected content."));
                } else {
                    TestGet006.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'E', (String)("The received content DOES NOT equal the expected content.\nexpected: " + expectedContent + " (content length: " + expectedContent.length() + ")\n" + "received: " + receivedContent + " (content length: " + receivedContent.length() + ")"));
                }
            } else {
                TestGet006.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'E', (String)("The HTTP status in the response DOES NOT equal the expected one\nexpected: HTTP/1.1 206 Partial content\nreceived: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            }
        }
        catch (WDVTestJ_WdvException exc) {
            TestGet006.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestGet006.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'I', (String)"Test failed due to some WebDAV feature.");
        }
        catch (Exception exc) {
            TestGet006.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'E', (String)("Java exception: " + exc.getMessage()));
            TestGet006.addGlobalMessage((String)"3. Call the GET method for the resource", (char)'I', (String)"Test failed due to some Java feature.");
        }
    }

    public static void cleanUp() throws TestCaseException {
        TestGet006.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

