/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.copytests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;

public class TestCopy010
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestCopy010.createWebDAVSchema();
        TestCopy010.addGlobalMessage((String)("prepare test " + TestCopy010.getTestClassId()), (char)'I', (String)"*******************************************************************************************************************************\n* copy an existing resource to a sub-folder where the same resource already exists (overwrite header is not given) (Status 204*\n*******************************************************************************************************************************");
        host = new String(TestCopy010.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestCopy010.getPort();
        baseUrl = TestCopy010.getParameterString((String)"baseUrl", (String)"/webdav");
        start_server = TestCopy010.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestCopy010.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestCopy010.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestCopy010.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestCopy010.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestCopy010.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy010.addGlobalMessage((String)"1. DELETE resource /TestCopy010.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestCopy010.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestCopy010");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy010.addGlobalMessage((String)"1. DELETE folder /TestCopy010 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy010.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestCopy010.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy010.addGlobalMessage((String)"2. create the resource /TestCopy010.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestCopy010.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestCopy010");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy010.addGlobalMessage((String)"2. create the collection /TestCopy010 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy010.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestCopy010/TestCopy010.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy010.addGlobalMessage((String)"3. create /TestCopy010/TestCopy010.txt", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        String contentNew = "empty";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestCopy010.doPut(resource, contentNew, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        urlStr = new String("/TestCopy010.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy010.addGlobalMessage((String)"4. copy the resource TestCopy010.txt to /TestCopy010", (char)'E', (String)"Test failed due to some Java feature.");
        }
        String dest_Url = null;
        try {
            dest_Url = new URL("http", host, WDV_PORT, baseUrl + "/TestCopy010/TestCopy010.txt").toString();
        }
        catch (MalformedURLException exc) {
            TestCopy010.addGlobalMessage((String)"4. copy the resource /TestCopy010.txt to /TestCopy010", (char)'E', (String)"Test failed due to some Java-URL feature");
        }
        try {
            resource.COPY(dest_Url, null, null, null);
        }
        catch (WDVTestJ_WdvException e) {
            this.handleExceptions(e);
        }
        catch (Exception exc) {
            this.handleExceptions(exc);
        }
        urlStr = new String("/TestCopy010/TestCopy010.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy010.addGlobalMessage((String)"5. compare the source and the destination after COPY with overwrite = 'T'", (char)'E', (String)"Test failed due to some Java feature.");
        }
        TestCopy010.compareContent(resource, content, contentType, contentLength, host + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestCopy010.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy010.addGlobalMessage((String)"6. clean up and DELETE the resource TestCopy010.txt and the collection /TestCopy010", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy010.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestCopy010");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy010.addGlobalMessage((String)"6. clean up and DELETE the resource TestCopy010.txt and the collection /TestCopy010", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy010.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

