/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.copytests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;

public class TestCopy005
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static String depth = null;
    static long sleep_time = 5000L;

    public static void prepare() throws TestCaseException {
        TestCopy005.createWebDAVSchema();
        TestCopy005.addGlobalMessage((String)("prepare test " + TestCopy005.getTestClassId()), (char)'I', (String)"*********************************************************\n* copy a collection with subfolders and resources using *\n* explicitly the depth header = 1                       *\n*********************************************************");
        host = new String(TestCopy005.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestCopy005.getPort();
        baseUrl = TestCopy005.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestCopy005.getParameterString((String)"var_overwrite", (String)"F");
        depth = "1";
        start_server = TestCopy005.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestCopy005.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestCopy005.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestCopy005.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestCopy005.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestCopy005");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy005.addGlobalMessage((String)"1. DELETE /tempCopy005 and /TestCopy005 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestCopy005.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/tempCopy005");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy005.addGlobalMessage((String)"1. DELETE /tempCopy005 and /TestCopy005 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy005.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestCopy005");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy005.addGlobalMessage((String)"2. create the folder /TestCopy005 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy005.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempCopy005");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy005.addGlobalMessage((String)"2. create the folder /tempCopy005 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy005.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempCopy005/folder005_a");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy005.addGlobalMessage((String)"3. create sub-folder /folder005_a at /tempCopy005", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy005.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempCopy005/folder005_a/folder005_b");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy005.addGlobalMessage((String)"3. create sub-folder /folder005_b at /tempCopy005/folder005_a", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy005.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempCopy005/res005_a.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy005.addGlobalMessage((String)"4. create resource /res005_a.txt at /tempCopy005", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestCopy005.doPut(resource, content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt", contentType = "text/plain", locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/tempCopy005/folder005_a/res005_b.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy005.addGlobalMessage((String)"4. create resource /res005_b.txt at /tempCopy005/folder005_a", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy005.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        urlStr = new String("/tempCopy005");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy005.addGlobalMessage((String)"5. COPY the collection /tempCopy005 to /TestCopy005 with depth = 1", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        String dest_Url = null;
        Object body = null;
        try {
            dest_Url = new URL("http", host, WDV_PORT, baseUrl + "/TestCopy005/tempCopy005").toString();
            body = null;
            locktoken = null;
        }
        catch (MalformedURLException exc) {
            TestCopy005.addGlobalMessage((String)"5. COPY the collection /temp005 to /TestCopy005 with depth = 1", (char)'E', (String)"Test failed due to some Java-URL feature");
        }
        try {
            resource.COPY(dest_Url, var_overwrite, body, locktoken, depth);
            TestCopy005.addGlobalMessage((String)("COPY TO http://" + dest_Url + " with depth header set to '1'"), (char)'I', (String)("WebDAV returned: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            if (TestCopy005.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("T")) {
                if (resource.getStatus().getStatusCode() != 201) {
                    TestCopy005.addGlobalMessage((String)("COPY TO http://" + dest_Url + " with depth header set to '1'"), (char)'E', (String)("WebDAV returned: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                    TestCopy005.addGlobalMessage((String)"COPY failed due to some WebDAV feature", (char)'I', (String)"Expected result: '201 Created'");
                }
            } else if (resource.getStatus().getStatusCode() != 400) {
                TestCopy005.addGlobalMessage((String)("COPY TO http://" + dest_Url + " with depth header set to '1'"), (char)'E', (String)("WebDAV returned: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestCopy005.addGlobalMessage((String)"COPY failed due to some WebDAV feature", (char)'I', (String)"Expected result: '400 Bad Request'");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 400) {
                TestCopy005.addGlobalMessage((String)("COPY TO http://" + dest_Url + " with depth header set to '1'"), (char)'I', (String)"Nothing was copied (as expected) and server returned status code '400 Bad Request'");
            } else {
                TestCopy005.addGlobalMessage((String)("COPY TO http://" + dest_Url + " with depth header set to '1'"), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                TestCopy005.addGlobalMessage((String)"COPY failed due to some WebDAV feature", (char)'I', (String)"Expected result: 400 Bad Request");
            }
        }
        catch (Exception exc) {
            TestCopy005.addGlobalMessage((String)("COPY TO http://" + dest_Url + " with depth header set to '1'"), (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestCopy005.addGlobalMessage((String)"COPY failed due to some Java feature", (char)'I', (String)("Skipping test " + TestCopy005.getTestClassId()));
        }
        urlStr = new String("/TestCopy005/tempCopy005");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy005.addGlobalMessage((String)"6. check, if the collection /TestCopy005 does not include /tempCopy005", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        try {
            resource.HEAD(null);
            if (TestCopy005.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("T")) {
                if (resource.getStatus().getStatusCode() != 200) {
                    TestCopy005.addGlobalMessage((String)"6. check, if the collection /TestCopy005 does not include /tempCopy005", (char)'E', (String)("WebDAV returned: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                    TestCopy005.addGlobalMessage((String)"COPY failed due to some WebDAV feature", (char)'I', (String)"Expected result: '200 OK'");
                }
            } else if (resource.getStatus().getStatusCode() != 404) {
                TestCopy005.addGlobalMessage((String)"6. check, if the collection /TestCopy005 does not include /tempCopy005", (char)'E', (String)("WebDAV returned: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestCopy005.addGlobalMessage((String)"COPY failed due to some WebDAV feature", (char)'I', (String)"Expected result: '404 File Not Found'");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 404) {
                TestCopy005.addGlobalMessage((String)"6. check, if the collection /TestCopy005 does not include /tempCopy005", (char)'I', (String)"Nothing was copied (as expected) and server returned status code '404 File Not Found'");
            }
        }
        catch (Exception exc) {
            this.handleExceptions(exc);
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestCopy005");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy005.addGlobalMessage((String)"8. clean up and DELETE /tempCopy005 as well as /TestCopy005", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestCopy005.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempCopy005");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy005.addGlobalMessage((String)"8. clean up and DELETE /tempCopy005 as well as /TestCopy005", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestCopy005.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

