/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.copytests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;

public class TestCopy004
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static String depth = null;

    public static void prepare() throws TestCaseException {
        TestCopy004.createWebDAVSchema();
        TestCopy004.addGlobalMessage((String)("prepare test " + TestCopy004.getTestClassId()), (char)'I', (String)"copy a collection with subfolders and resources using explicitly the depth header = 0");
        host = new String(TestCopy004.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestCopy004.getPort();
        baseUrl = TestCopy004.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestCopy004.getParameterString((String)"var_overwrite", (String)"F");
        depth = "0";
        start_server = TestCopy004.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestCopy004.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestCopy004.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestCopy004.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestCopy004.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestCopy004");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy004.addGlobalMessage((String)"1. DELETE /tempCopy004 and /TestCopy004 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestCopy004.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/tempCopy004");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy004.addGlobalMessage((String)"1. DELETE /tempCopy004 and /TestCopy004 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy004.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestCopy004");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy004.addGlobalMessage((String)"2. create the folder /TestCopy004 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy004.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempCopy004");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy004.addGlobalMessage((String)"2. create the folder /tempCopy004 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy004.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempCopy004/folder004");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy004.addGlobalMessage((String)"3. create sub-folder /folder004 at /tempCopy004", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy004.doMkCol(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempCopy004/res004.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy004.addGlobalMessage((String)"4. create resource /res004.txt at /tempCopy004", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestCopy004.doPut(resource, content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt", contentType = "text/plain", locktoken, host + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/tempCopy004/folder004/res004.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy004.addGlobalMessage((String)"5. create resource /res004.txt at /tempCopy004/folder004", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        TestCopy004.doPut(resource, content, contentType, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        urlStr = new String("/tempCopy004");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy004.addGlobalMessage((String)"6. COPY the collection /tempCopy004 to /TestCopy004 with depth = 0", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        try {
            String dest_Url = new URL("http", host, WDV_PORT, baseUrl + "/TestCopy004/tempCopy004").toString();
            String body = null;
            locktoken = null;
            TestCopy004.doCopy(resource, dest_Url, var_overwrite, body, locktoken, depth);
        }
        catch (MalformedURLException exc) {
            TestCopy004.addGlobalMessage((String)"6. COPY the collection /tempCopy004 to /TestCopy004 with depth = 0", (char)'E', (String)"Test failed due to some Java-URL feature");
        }
        urlStr = new String("/TestCopy004/tempCopy004/folder004");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy004.addGlobalMessage((String)"7. test, if the collection /TestCopy004/tempCopy004 is empty", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        try {
            resource.HEAD(null);
            if (resource.getStatus().getStatusCode() != 404) {
                TestCopy004.addGlobalMessage((String)"collection /TestCopy004/tempCopy004/folder004 must not exist", (char)'E', (String)"collection /TestCopy004/tempCopy004/folder004 was copied, despite of depth = '0'");
            }
            TestCopy004.addGlobalMessage((String)"collection /TestCopy004/tempCopy004/folder004 must not exist", (char)'I', (String)("received status: " + resource.getStatus().getStatusCode()));
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 404) {
                TestCopy004.addGlobalMessage((String)"collection /TestCopy004/tempCopy004/folder004 must not exist", (char)'I', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                TestCopy004.addGlobalMessage((String)"Check succeeded", (char)'I', (String)"Expected result: 404 Not Found");
            } else {
                TestCopy004.addGlobalMessage((String)("CHECK: GET http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                exc.printStackTrace();
                TestCopy004.addGlobalMessage((String)"Test failed due to some WebDAV feature", (char)'I', (String)"Expected result: 404 Not Found");
            }
        }
        catch (Exception exc) {
            TestCopy004.addGlobalMessage((String)("CHECK: GET http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestCopy004.addGlobalMessage((String)"Test failed due to some Java feature", (char)'I', (String)"Skipping test");
        }
        urlStr = new String("/TestCopy004/tempCopy004/res004.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy004.addGlobalMessage((String)"7. test, if the collection /TestCopy004/tempCopy004 is empty", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        try {
            resource.HEAD(null);
            if (resource.getStatus().getStatusCode() != 404) {
                TestCopy004.addGlobalMessage((String)"resource /TestCopy004/tempCopy004/res004.txt must not exist", (char)'E', (String)"resource /TestCopy004/tempCopy004/res004.txt was copied, despite of depth = '0'");
            }
            TestCopy004.addGlobalMessage((String)"resource /TestCopy004/tempCopy004/res004.txt must not exist", (char)'I', (String)("received status: " + resource.getStatus().getStatusCode()));
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 404) {
                TestCopy004.addGlobalMessage((String)"resource /TestCopy004/tempCopy004/res004.txt must not exist", (char)'I', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                TestCopy004.addGlobalMessage((String)"Check succeeded", (char)'I', (String)"Expected result: 404 Not Found");
            } else {
                TestCopy004.addGlobalMessage((String)("CHECK: GET http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                exc.printStackTrace();
                TestCopy004.addGlobalMessage((String)"Test failed due to some WebDAV feature", (char)'I', (String)"Expected result: 404 Not Found");
            }
        }
        catch (Exception exc) {
            TestCopy004.addGlobalMessage((String)("CHECK: GET http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestCopy004.addGlobalMessage((String)"Test failed due to some Java feature", (char)'E', (String)"Skipping test");
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestCopy004");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy004.addGlobalMessage((String)"8. clean up and DELETE /tempCopy004 as well as /TestCopy004", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestCopy004.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/tempCopy004");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy004.addGlobalMessage((String)"8. clean up and DELETE /tempCopy004 as well as /TestCopy004", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestCopy004.doDelete(resource, locktoken, host + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

