/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLParseException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ErrorHandlerWrapper
implements XMLErrorHandler {
    protected ErrorHandler fErrorHandler;

    public ErrorHandlerWrapper() {
    }

    public ErrorHandlerWrapper(ErrorHandler errorHandler) {
        this.setErrorHandler(errorHandler);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.fErrorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    public void warning(String domain, String key, XMLParseException exception) throws XNIException {
        SAXParseException saxException = ErrorHandlerWrapper.createSAXParseException(exception);
        try {
            this.fErrorHandler.warning(saxException);
        }
        catch (SAXException e) {
            throw ErrorHandlerWrapper.createXMLParseException(saxException);
        }
    }

    public void error(String domain, String key, XMLParseException exception) throws XNIException {
        SAXParseException saxException = ErrorHandlerWrapper.createSAXParseException(exception);
        try {
            this.fErrorHandler.error(saxException);
        }
        catch (SAXException e) {
            throw ErrorHandlerWrapper.createXMLParseException(saxException);
        }
    }

    public void fatalError(String domain, String key, XMLParseException exception) throws XNIException {
        SAXParseException saxException = ErrorHandlerWrapper.createSAXParseException(exception);
        try {
            this.fErrorHandler.fatalError(saxException);
        }
        catch (SAXException e) {
            throw ErrorHandlerWrapper.createXMLParseException(saxException);
        }
    }

    protected static SAXParseException createSAXParseException(XMLParseException exception) {
        return new SAXParseException(exception.getMessage(), exception.getPublicId(), exception.getSystemId(), exception.getLineNumber(), exception.getColumnNumber(), exception.getException());
    }

    protected static XMLParseException createXMLParseException(SAXParseException exception) {
        final String fPublicId = exception.getPublicId();
        final String fSystemId = exception.getSystemId();
        final int fLineNumber = exception.getLineNumber();
        final int fColumnNumber = exception.getColumnNumber();
        XMLLocator location = new XMLLocator(){

            public String getPublicId() {
                return fPublicId;
            }

            public String getSystemId() {
                return fSystemId;
            }

            public String getBaseSystemId() {
                return null;
            }

            public int getColumnNumber() {
                return fColumnNumber;
            }

            public int getLineNumber() {
                return fLineNumber;
            }
        };
        return new XMLParseException(location, exception.getMessage(), exception.getException());
    }
}

