/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.util.Hashtable;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.StringDatatypeValidator;
import org.apache.xerces.impl.validation.ValidationContext;

public class EntityDatatypeValidator
extends StringDatatypeValidator {
    public EntityDatatypeValidator() {
        this(null, null, false, null);
    }

    public EntityDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList, XMLErrorReporter reporter) {
        super(base, facets, derivedByList, reporter);
        this.fErrorReporter = reporter;
        this.fBaseValidator = base;
    }

    public short getWSFacet() {
        return 2;
    }

    public Object validate(String content, ValidationContext state) throws InvalidDatatypeValueException {
        super.validate(content, state);
        if (state == null) {
            throw new InvalidDatatypeValueException("EntityState is not intialized");
        }
        if (state == null) {
            return content;
        }
        if (state.isEntityDeclared(content)) {
            if (!state.isEntityUnparsed(content)) {
                throw new InvalidDatatypeValueException("Entity is not unparsed: " + content);
            }
        } else {
            throw new InvalidDatatypeValueException("Entity is not declared: " + content);
        }
        return content;
    }

    public int compare(String content1, String content2) {
        return content1.equals(content2) ? 0 : -1;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }
}

