/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import com.sap.sdb.msgServer.util.ConfigurationParam;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ServerConfig
extends ConfigurationParam {
    public static final String VERBOSE_ADMIN = "VerboseAdmin";
    public static final String VERBOSE_CONSUMER = "VerboseConsumer";
    public static final String VERBOSE_EXCEPTION = "VerboseException";
    public static final String VERBOSE_MSG_BUILDER = "VerboseMessageBuilder";
    public static final String VERBOSE_SENDING_QUEUES = "VerboseSendingQueues";
    public static final String VERBOSE_SENDORDER_STAT = "VerboseSendOrderStat";
    public static final String VERBOSE_SEND_RECEIVE = "VerboseSendReceive";
    public static final String VERBOSE_SQL_CONNECTION = "VerboseSQLConnection";
    public static final String VERBOSE_TRACE_BACK = "VerboseTraceBack";
    public static final String VERBOSE_WAIT = "VerboseWait";
    public static final String DISPLAY_SERVER_STATE = "DisplayServerStateInSec";
    public static final String CREATE_MSGSVR_TABLES = "CreateMsgSvrTables";
    private int myTopicCount = -1;
    private NodeList myTopicsNames = this.myConfigFile.getElementsByTagName("TopicName");
    private int myQueueCount = -1;
    private NodeList myQueuesNames = this.myConfigFile.getElementsByTagName("QueueName");
    private static final int GARBAGE_TIME = 600;
    private static final int CLIENT_TIMEOUT = 3600;

    public ServerConfig(String configFileName, Hashtable globalCommandlineOptions) throws IOException, ParserConfigurationException, SAXException {
        super(configFileName, globalCommandlineOptions);
    }

    public int getAgents() {
        return this.getIntByTagName("Agents");
    }

    public String getDatabaseURL() {
        return this.getStringByTagName("DatabaseURL");
    }

    public long getDisplayServerTime() {
        long interval = this.getIntByTagName(DISPLAY_SERVER_STATE);
        return interval < 1L ? 0L : 1000L * interval;
    }

    public boolean getVerboseAdmin() {
        return this.getIntByTagName(VERBOSE_ADMIN) == 1;
    }

    public boolean getVerboseConsumer() {
        return this.getIntByTagName(VERBOSE_CONSUMER) == 1;
    }

    public boolean getVerboseException() {
        return this.getIntByTagName(VERBOSE_EXCEPTION) == 1;
    }

    public boolean getVerboseMessageBuilder() {
        return this.getIntByTagName(VERBOSE_MSG_BUILDER) == 1;
    }

    public boolean getVerboseSendingQueues() {
        return this.getIntByTagName(VERBOSE_SENDING_QUEUES) == 1;
    }

    public boolean getVerboseSendOrderStat() {
        return this.getIntByTagName(VERBOSE_SENDORDER_STAT) == 1;
    }

    public boolean getVerboseSendReceive() {
        return this.getIntByTagName(VERBOSE_SEND_RECEIVE) == 1;
    }

    public boolean getVerboseSQLConnection() {
        return this.getIntByTagName(VERBOSE_SQL_CONNECTION) == 1;
    }

    public boolean getVerboseTraceBack() {
        return this.getIntByTagName(VERBOSE_TRACE_BACK) == 1;
    }

    public boolean getVerboseWait() {
        return this.getIntByTagName(VERBOSE_WAIT) == 1;
    }

    public String getFirstQueueName() {
        this.myQueueCount = -1;
        return this.getNextQueueName();
    }

    public String getFirstTopicName() {
        this.myTopicCount = -1;
        return this.getNextTopicName();
    }

    public int getGarbageCollectingTimeInSec() {
        int value = this.getIntByTagName("GarbageCollectingTimeInSec");
        return value < 1 ? 600 : value;
    }

    public long getClientTimeOutInSec() {
        long value = this.getLongByTagName("ClientTimeOutInSec");
        return value < 1L ? 3600L : value;
    }

    public int getInitialDBConnections() {
        return this.getIntByTagName("InitialDBConnections");
    }

    public String getJDBCDriver() {
        return this.getStringByTagName("JDBCDriver");
    }

    public int getLengthSendOrderQueue() {
        return this.getIntByTagName("LengthSendOrderQueue");
    }

    public long getMessageCacheSize() {
        return this.getLongByTagName("MessageCacheSizeInKB");
    }

    public String getNextQueueName() {
        ++this.myQueueCount;
        return this.getNodeListValue(this.myQueuesNames, this.myQueueCount);
    }

    public String getNextTopicName() {
        ++this.myTopicCount;
        return this.getNodeListValue(this.myTopicsNames, this.myTopicCount);
    }

    public String getPassword() {
        String password = this.getStringByTagName("Password");
        if (password != null) {
            password = password.startsWith("\"") && password.endsWith("\"") ? password.substring(1, password.length() - 1) : password.toUpperCase();
        }
        return password;
    }

    public int getSendOrderPollingInMilliSec() {
        return this.getIntByTagName("SendOrderPollingInMilliSec");
    }

    public int getPushSizeForSendOrderQueue() {
        return this.getIntByTagName("PushSizeForSendOrderQueue");
    }

    public String getTransientDatabaseURL() {
        return this.getStringByTagName("TransientDatabaseURL");
    }

    public String getTransientJDBCDriver() {
        return this.getStringByTagName("TransientJDBCDriver");
    }

    public int getTransientMaxSendOrders() {
        return this.getIntByTagName("TransientMaxSendOrders");
    }

    public long getTransientMaxMessageSpace() {
        return this.getLongByTagName("TransientMaxMessageSpaceInKB");
    }

    public String getTransientPassword() {
        String password = this.getStringByTagName("TransientPassword");
        if (password != null) {
            password = password.startsWith("\"") && password.endsWith("\"") ? password.substring(1, password.length() - 1) : password.toUpperCase();
        }
        return password;
    }

    public int getTransientPushSizeForSendOrderQueue() {
        return this.getIntByTagName("TransientPushSizeForSendOrderQueue");
    }

    public String getTransientUser() {
        String user = this.getStringByTagName("TransientUser");
        if (user != null) {
            user = user.startsWith("\"") && user.endsWith("\"") ? user.substring(1, user.length() - 1) : user.toUpperCase();
        }
        return user;
    }

    public String getUser() {
        String user = this.getStringByTagName("User");
        if (user != null) {
            user = user.startsWith("\"") && user.endsWith("\"") ? user.substring(1, user.length() - 1) : user.toUpperCase();
        }
        return user;
    }

    public String getSchema() {
        String schema = this.getStringByTagName("Schema");
        if (schema != null) {
            schema = schema.startsWith("\"") && schema.endsWith("\"") ? schema.substring(1, schema.length() - 1) : schema.toUpperCase();
        }
        return schema;
    }

    public boolean getCreateMsgSvrTables() {
        return this.getIntByTagName(CREATE_MSGSVR_TABLES) == 1;
    }

    public int getMaxConnections() {
        return this.getIntByTagName("MaxConnections");
    }

    public String getAdminPassword() {
        String password = this.getStringByTagName("AdminPassword");
        if (password != null) {
            password = password.startsWith("\"") && password.endsWith("\"") ? password.substring(1, password.length() - 1) : password.toUpperCase();
        }
        return password;
    }

    public int getAdminPort() {
        return this.getIntByTagName("AdminPort");
    }

    public int getMsgPort() {
        return this.getIntByTagName("MsgPort");
    }

    public int getJndiPort() {
        return this.getIntByTagName("JndiPort");
    }

    public String getLogFile() {
        return this.getStringByTagName("LogFilename");
    }

    public int getSSLSocket() {
        return this.getIntByTagName("SSLConnection");
    }
}

