/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import com.sap.sdb.msgServer.util.SendReceiveStreamConstants;
import com.sap.sdb.msgServer.util.StreamString;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.jms.MessageFormatException;

public class SendStream
extends DataOutputStream
implements SendReceiveStreamConstants {
    private boolean m_isNativeStream;

    public SendStream(OutputStream out) throws IOException {
        super(out);
        this.m_isNativeStream = false;
    }

    public SendStream(OutputStream out, int bufSize) throws IOException {
        super(new BufferedOutputStream(out, bufSize));
        this.m_isNativeStream = false;
    }

    public SendStream(OutputStream out, int bufSize, boolean isNativeStream) throws IOException {
        super(new BufferedOutputStream(out, bufSize));
        this.m_isNativeStream = isNativeStream;
    }

    public static int getIntegerLength(Integer intObject) {
        return intObject == null ? 1 : 5;
    }

    public static int getStreamStringLength(StreamString str) {
        return str == null ? 1 : 1 + str.getUTFLength();
    }

    public boolean isNativeStream() {
        return this.m_isNativeStream;
    }

    public boolean isWriteObject(Object obj) throws IOException {
        if (obj == null) {
            this.writeByte(0);
            return false;
        }
        this.writeByte(100);
        return true;
    }

    public void writeByteArray(byte[] byteArray) throws IOException {
        if (byteArray == null) {
            this.writeInt(-1);
            return;
        }
        this.writeByteArray(byteArray, 0, byteArray.length);
    }

    public void writeByteArray(byte[] byteArray, int off, int len) throws IOException {
        if (byteArray == null) {
            this.writeInt(-1);
            return;
        }
        if (off < 0 || len < 0 || off + len > byteArray.length) {
            throw new IndexOutOfBoundsException();
        }
        this.writeInt(len);
        this.write(byteArray, off, len);
    }

    public void writeByteArray(ByteArrayOutputStream byteArrayStream) throws IOException {
        if (byteArrayStream == null) {
            this.writeInt(-1);
            return;
        }
        this.writeInt(byteArrayStream.size());
        byteArrayStream.writeTo(this);
    }

    public void writeVector(Vector vectab) throws IOException {
        int i;
        int elementsWritten = 0;
        int elementCount = vectab == null ? -1 : vectab.size();
        this.writeInt(elementCount);
        if (elementCount <= 0) {
            return;
        }
        for (i = 0; i < elementCount && elementsWritten <= elementCount; ++i) {
            try {
                Object data = vectab.get(i);
                if (!this.writeSpecialObject(data)) {
                    throw new IOException("Vector object not serializable: " + data.toString());
                }
                ++elementsWritten;
                continue;
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
        }
        if (elementsWritten < elementCount) {
            for (i = elementsWritten; i < elementCount; ++i) {
                this.writeSpecialObject(null);
                this.writeSpecialObject(null);
            }
        }
    }

    public void writeHashtable(Hashtable hashtab) throws IOException {
        int elementsWritten = 0;
        int elementCount = hashtab == null ? -1 : hashtab.size();
        this.writeInt(elementCount);
        if (elementCount <= 0) {
            return;
        }
        Enumeration keyIter = hashtab.keys();
        while (keyIter.hasMoreElements() && elementsWritten <= elementCount) {
            try {
                Object key = keyIter.nextElement();
                if (key == null) continue;
                Object data = hashtab.get(key);
                if (!this.writeSpecialObject(key)) {
                    throw new IOException("Hashtable key not serializable: " + key.toString());
                }
                if (!this.writeSpecialObject(data)) {
                    throw new IOException("Hashtable object not serializable: " + data.toString());
                }
                ++elementsWritten;
            }
            catch (NoSuchElementException e) {}
        }
        if (elementsWritten < elementCount) {
            for (int i = elementsWritten; i < elementCount; ++i) {
                this.writeSpecialObject(null);
                this.writeSpecialObject(null);
            }
        }
    }

    public void writeInteger(Integer intObj) throws IOException {
        if (intObj == null) {
            this.writeByte(0);
            return;
        }
        this.writeTypeInt(intObj);
    }

    public void writeSerializableObject(Object obj) throws IOException {
        if (this.m_isNativeStream) {
            throw new IOException("write serializable object not supported for native stream");
        }
        if (obj == null) {
            this.writeByte(0);
            return;
        }
        this.writeByte(1);
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(1024);
        ObjectOutputStream objStream = new ObjectOutputStream(byteStream);
        objStream.writeObject(obj);
        objStream.flush();
        this.writeByteArray(byteStream);
        objStream.close();
    }

    public boolean writeSpecialObject(Object obj) throws IOException {
        if (obj == null) {
            this.writeByte(0);
            return true;
        }
        if (obj instanceof String) {
            this.writeString((String)obj);
            return true;
        }
        if (obj instanceof Boolean) {
            this.writeTypeBoolean((Boolean)obj);
            return true;
        }
        if (obj instanceof Byte) {
            this.writeTypeByte((Byte)obj);
            return true;
        }
        if (obj instanceof byte[]) {
            this.writeTypeByteArray((byte[])obj);
            return true;
        }
        if (obj instanceof Character) {
            this.writeTypeChar(((Character)obj).charValue());
            return true;
        }
        if (obj instanceof Double) {
            this.writeTypeDouble((Double)obj);
            return true;
        }
        if (obj instanceof Float) {
            this.writeTypeFloat(((Float)obj).floatValue());
            return true;
        }
        if (obj instanceof Integer) {
            this.writeTypeInt((Integer)obj);
            return true;
        }
        if (obj instanceof Long) {
            this.writeTypeLong((Long)obj);
            return true;
        }
        if (obj instanceof Short) {
            this.writeTypeShort((Short)obj);
            return true;
        }
        return false;
    }

    public void writeStreamString(StreamString str) throws IOException {
        if (str == null) {
            this.writeByte(0);
            return;
        }
        this.writeByte(12);
        this.write(str.getUTF());
    }

    public void writeString(String text) throws IOException {
        if (text == null) {
            this.writeByte(0);
            return;
        }
        this.writeByte(10);
        this.writeUTF(text);
    }

    public void writeTypeBoolean(boolean value) throws IOException {
        this.writeByte(2);
        this.writeBoolean(value);
    }

    public void writeTypeByte(byte value) throws IOException {
        this.writeByte(3);
        this.writeByte(value);
    }

    public void writeTypeByteArray(byte[] byteArray) throws IOException {
        this.writeByte(11);
        this.writeByteArray(byteArray);
    }

    public void writeTypeByteArray(byte[] byteArray, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > byteArray.length) {
            throw new IndexOutOfBoundsException();
        }
        this.writeByte(11);
        this.writeByteArray(byteArray, off, len);
    }

    public void writeTypeChar(char value) throws IOException {
        this.writeByte(4);
        this.writeChar(value);
    }

    public void writeTypeDouble(double value) throws IOException {
        this.writeByte(5);
        this.writeDouble(value);
    }

    public void writeTypeFloat(float value) throws IOException {
        this.writeByte(6);
        this.writeFloat(value);
    }

    public void writeTypeInt(int value) throws IOException {
        this.writeByte(7);
        this.writeInt(value);
    }

    public void writeTypeLong(long value) throws IOException {
        this.writeByte(8);
        this.writeLong(value);
    }

    public void writeTypeObject(Object obj) throws IOException, MessageFormatException {
        if (!this.writeSpecialObject(obj)) {
            throw new MessageFormatException("invalid object");
        }
    }

    public void writeTypeShort(short value) throws IOException {
        this.writeByte(9);
        this.writeShort(value);
    }
}

