/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import com.sap.sdb.msgServer.agents.JmsThread;
import com.sap.sdb.msgServer.util.Notification;
import com.sap.sdb.msgServer.util.TimeOutNotification;

public abstract class NotificationQueue {
    private String myID;
    private boolean mDeactivated;

    public NotificationQueue() {
        this.myID = Integer.toString(this.hashCode());
    }

    public NotificationQueue(String id) {
        this.myID = id;
    }

    public String getID() {
        return this.myID;
    }

    public void setID(String ID) {
        this.myID = ID;
    }

    public synchronized Notification pop() throws InterruptedException {
        while (this.getQueueSize() == 0) {
            JmsThread.performWait(this, 0L, "Notification");
        }
        return this.removeFirstNotification();
    }

    public synchronized Notification pop(long timeout) throws InterruptedException {
        long start;
        if (timeout == 0L) {
            return this.pop();
        }
        long current = start = System.currentTimeMillis();
        while (this.getQueueSize() == 0 && current - start < timeout) {
            JmsThread.performWait(this, timeout - (current - start), "Notification (" + timeout + ")");
            current = System.currentTimeMillis();
        }
        if (this.getQueueSize() == 0) {
            return new TimeOutNotification("Timeout expired in Queue <" + this.myID + ">");
        }
        return this.removeFirstNotification();
    }

    public synchronized void push(Notification notification) {
        this.appendNotification(notification);
        this.notify();
    }

    public synchronized void pushBack(Notification notification) {
        this.appendNotificationBack(notification);
        this.notify();
    }

    public synchronized boolean isEmpty() {
        return this.getQueueSize() == 0;
    }

    public boolean isDeactivated() {
        return this.mDeactivated;
    }

    public void setIsDeactivated(boolean deactivated) {
        this.mDeactivated = deactivated;
    }

    public abstract int getQueueSize();

    public abstract void clear();

    protected abstract void appendNotification(Notification var1);

    protected abstract void appendNotificationBack(Notification var1);

    protected abstract Notification removeFirstNotification();
}

