/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import com.sap.sdb.msgServer.msgselector.MsgSelector;
import com.sap.sdb.msgServer.util.ClientSessionAddress;
import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendStream;
import com.sap.sdb.msgServer.util.StreamString;
import java.io.IOException;
import java.io.Serializable;
import javax.jms.InvalidSelectorException;

public class MessageConsumerInfo
implements Serializable {
    public static final int ASYNC_TOPIC_SUBSCRIBER = 0;
    public static final int ASYNC_QUEUE_RECEIVER = 1;
    public static final int DURABLE_TOPIC_SUBSCRIBER = 2;
    private long myConsumerID = -1L;
    private long myDestinationID = -1L;
    private int myType = -1;
    private boolean myNoLocal = false;
    private String mySubscription = "";
    private Integer myMessageListener = null;
    private ClientSessionAddress myClientSessionAddress = null;
    private transient MsgSelector myMsgSelector = null;
    private transient ClientSessionAddress mySynchronousClientSessionAddress = null;
    private transient long myIgnoreBySendOrderPolling = -1L;

    public long getConsumerID() {
        return this.myConsumerID;
    }

    public void setConsumerID(long id) {
        this.myConsumerID = id;
    }

    public long getDestinationID() {
        return this.myDestinationID;
    }

    public void setDestinationID(long id) {
        this.myDestinationID = id;
    }

    public long getIgnoreBySendOrderPolling() {
        return this.myIgnoreBySendOrderPolling;
    }

    public void setIgnoreBySendOrderPolling(long ignoreBySendOrderPolling) {
        this.myIgnoreBySendOrderPolling = ignoreBySendOrderPolling;
    }

    public int getType() {
        return this.myType;
    }

    public void setType(int type) {
        this.myType = type;
    }

    public Integer getMessageListener() {
        return this.myMessageListener;
    }

    public void setMessageListener(Integer listener) {
        this.myMessageListener = listener;
    }

    public ClientSessionAddress getClientSessionAddress() {
        return this.myClientSessionAddress;
    }

    public void setClientSessionAddress(ClientSessionAddress clientSessionAddress) {
        this.myClientSessionAddress = clientSessionAddress;
    }

    public ClientSessionAddress getSynchronousClientSessionAddress() {
        return this.mySynchronousClientSessionAddress;
    }

    public void setSynchronousClientSessionAddress(ClientSessionAddress SynchronousClientSessionAddress) {
        this.mySynchronousClientSessionAddress = SynchronousClientSessionAddress;
    }

    public String getSubscription() {
        return this.mySubscription;
    }

    public void setSubscription(String subscription) {
        this.mySubscription = subscription;
    }

    public MsgSelector getMsgSelector() {
        return this.myMsgSelector;
    }

    public void setMsgSelector(String msgSelector) throws InvalidSelectorException {
        this.myMsgSelector = msgSelector != null ? new MsgSelector(msgSelector) : null;
    }

    public String getClientAsString() {
        if (this.myClientSessionAddress != null) {
            return this.myClientSessionAddress.toString() + "/" + this.myMessageListener;
        }
        return "";
    }

    public boolean isQueueReceiver() {
        return this.myType == 1;
    }

    public void setNoLocal(boolean noLocal) {
        this.myNoLocal = noLocal;
    }

    public boolean getNoLocal() {
        return this.myNoLocal;
    }

    void deserialize(ReceiveStream in) throws IOException {
        this.myConsumerID = in.readLong();
        this.myDestinationID = in.readLong();
        this.myType = in.readInt();
        this.myMessageListener = in.readInteger();
        this.myNoLocal = in.readBoolean();
        this.mySubscription = StreamString.getString(in.readStreamString());
        if (in.isNullObject()) {
            this.myClientSessionAddress = null;
        } else {
            this.myClientSessionAddress = new ClientSessionAddress();
            this.myClientSessionAddress.deserialize(in);
        }
        this.mySynchronousClientSessionAddress = null;
    }

    int getSerializationLength() {
        StreamString subscription = StreamString.create(this.mySubscription);
        int length = 20 + SendStream.getIntegerLength(this.myMessageListener) + 1 + SendStream.getStreamStringLength(subscription) + 1;
        return this.myClientSessionAddress == null ? length : length + this.myClientSessionAddress.getSerializationLength();
    }

    void serialize(SendStream out) throws IOException {
        out.writeLong(this.myConsumerID);
        out.writeLong(this.myDestinationID);
        out.writeInt(this.myType);
        out.writeInteger(this.myMessageListener);
        out.writeBoolean(this.myNoLocal);
        out.writeString(this.mySubscription);
        if (out.isWriteObject(this.myClientSessionAddress)) {
            this.myClientSessionAddress.serialize(out);
        }
    }
}

