/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import com.sap.sdb.msgServer.util.AdminNotification;
import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendStream;
import com.sap.sdb.msgServer.util.StreamString;
import java.io.IOException;

public class ListDestAdminNotification
extends AdminNotification {
    public static final transient int LIST_DESTINATION = 0;
    public static final transient int LIST_SUBSCRIPTION = 1;
    private StreamString myDestinationName;
    private boolean myIsQueue;

    ListDestAdminNotification() {
        this.myDestinationName = null;
        this.myIsQueue = false;
    }

    public ListDestAdminNotification(int type, boolean isQueue, String destinationName) {
        super(type);
        this.myDestinationName = StreamString.create(destinationName);
        this.myIsQueue = isQueue;
    }

    public boolean getIsQueue() {
        return this.myIsQueue;
    }

    public String getDestinationName() {
        return StreamString.getString(this.myDestinationName);
    }

    public String toString() {
        return "ListDestAdminNotification: " + super.toString();
    }

    void readFromStream(ReceiveStream in) throws IOException {
        super.deserialize(in);
        this.myDestinationName = in.readStreamString();
        this.myIsQueue = in.readBoolean();
    }

    void writeToStream(SendStream out) throws IOException {
        super.serialize(out, 6, SendStream.getStreamStringLength(this.myDestinationName) + 1);
        out.writeStreamString(this.myDestinationName);
        out.writeBoolean(this.myIsQueue);
    }
}

