/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import com.sap.sdb.msgServer.util.AdminNotification;
import com.sap.sdb.msgServer.util.DestinationAuth;
import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendStream;
import com.sap.sdb.msgServer.util.StreamString;
import java.io.IOException;
import java.util.Vector;

public class DestinationAdminNotification
extends AdminNotification {
    private StreamString m_DestinationName;
    private boolean m_IsQueue;
    private boolean m_IsTempDest;
    private int m_Type;
    private transient Vector m_authentication;
    public static final transient int CREATE_DESTINATION = 0;
    public static final transient int DROP_DESTINATION = 1;
    public static final transient int GET_SENDORDER_COUNT = 2;

    DestinationAdminNotification() {
        this.m_DestinationName = null;
        this.m_IsQueue = false;
        this.m_IsTempDest = false;
        this.m_Type = 0;
        this.m_authentication = new Vector();
    }

    public DestinationAdminNotification(int type, boolean isQueue, boolean isTempDest, String destinationName) {
        super(type);
        this.m_Type = type;
        this.m_DestinationName = StreamString.create(destinationName);
        this.m_IsQueue = isQueue;
        this.m_IsTempDest = isTempDest;
        this.m_authentication = new Vector();
    }

    public Vector getAuthentication() {
        return this.m_authentication;
    }

    public boolean getIsQueue() {
        return this.m_IsQueue;
    }

    public boolean getIsTempDest() {
        return this.m_IsTempDest;
    }

    public String getDestinationName() {
        return StreamString.getString(this.m_DestinationName);
    }

    public String toString() {
        return "DestinationAdminNotification: " + super.toString();
    }

    void readFromStream(ReceiveStream in) throws IOException {
        super.deserialize(in);
        this.m_DestinationName = in.readStreamString();
        this.m_IsQueue = in.readBoolean();
        this.m_IsTempDest = in.readBoolean();
        this.m_Type = in.readInt();
    }

    void writeToStream(SendStream out) throws IOException {
        super.serialize(out, 6, SendStream.getStreamStringLength(this.m_DestinationName) + 2 + 4);
        out.writeStreamString(this.m_DestinationName);
        out.writeBoolean(this.m_IsQueue);
        out.writeBoolean(this.m_IsTempDest);
        out.writeInt(this.m_Type);
    }

    public void setDestinationAuth(DestinationAuth auth) {
        this.m_authentication.add(auth);
    }
}

