/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.msgselector.parsing;

import com.sap.sdb.msgServer.msgselector.parsing.LanguageDefinition;
import com.sap.sdb.msgServer.msgselector.parsing.Set;

public class Datatype
implements LanguageDefinition {
    private String m_name = "";
    private String[] m_attributeNames = null;
    private int[] m_attributeTypes = null;

    public Datatype(String name, String[] attributeNames, int[] attributeTypes) {
        this.m_name = name;
        if (attributeNames.length != attributeTypes.length) {
            throw new IllegalArgumentException("Number of attributes does not match number of types");
        }
        this.m_attributeNames = attributeNames;
        this.m_attributeTypes = attributeTypes;
    }

    public String getName() {
        return this.m_name;
    }

    public int getAttributeCount() {
        return this.m_attributeNames.length;
    }

    private int getAttributeTypeAt(int index) {
        return this.m_attributeTypes[index];
    }

    private String getAttributeNameAt(int index) {
        return this.m_attributeNames[index];
    }

    public boolean hasAttribute(String name) {
        return this.getAttributeIndex(name) != -1;
    }

    public boolean hasAttribute(String name, int type) {
        int index = this.getAttributeIndex(name);
        if (index != -1) {
            return type == this.m_attributeTypes[index];
        }
        return false;
    }

    protected int getAttributeIndex(String name) {
        for (int i = 0; i < this.m_attributeNames.length; ++i) {
            if (!this.m_attributeNames[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    public int getAttributeType(String name) {
        int index = this.getAttributeIndex(name);
        return index != -1 ? this.m_attributeTypes[index] : -1;
    }

    public boolean equals(Object o) {
        if (o instanceof Datatype) {
            Datatype t = (Datatype)o;
            if (t.getAttributeCount() == this.getAttributeCount()) {
                int len = this.getAttributeCount();
                for (int i = 0; i < len; ++i) {
                    if (t.hasAttribute(this.getAttributeNameAt(i), this.getAttributeTypeAt(i))) continue;
                    return false;
                }
                return true;
            }
        } else if (o instanceof Set) {
            return this.equals(((Set)o).getDatatype());
        }
        return false;
    }
}

