/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.jndi;

import com.sap.sdb.msgServer.client.DestinationImpl;
import com.sap.sdb.msgServer.client.QueueConnectionFactoryImpl;
import com.sap.sdb.msgServer.client.TopicConnectionFactoryImpl;
import com.sap.sdb.msgServer.util.Command;
import com.sap.sdb.msgServer.util.ParserException;
import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.StringTokenizer;
import javax.naming.NamingException;

public class JndiMessage
extends Command {
    private byte[] mySerializedObject = null;
    private static final byte ANY_OBJECT = 0;
    private static final byte DESTINATION = 1;
    private static final byte QUEUE_CONNECTION_FACTORY = 2;
    private static final byte TOPIC_CONNECTION_FACTORY = 3;

    public JndiMessage(String command) {
        super(command);
    }

    public void setObject(Object obj) throws NamingException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            SendStream obout = new SendStream(bout);
            if (obj instanceof DestinationImpl) {
                obout.writeByte(1);
                ((DestinationImpl)obj).writeToStream(obout);
            } else if (obj instanceof QueueConnectionFactoryImpl) {
                obout.writeByte(2);
            } else if (obj instanceof TopicConnectionFactoryImpl) {
                obout.writeByte(3);
            } else {
                obout.writeByte(0);
                obout.writeSerializableObject(obj);
            }
            obout.flush();
            this.mySerializedObject = bout.toByteArray();
        }
        catch (Exception ex) {
            throw new NamingException(ex.toString());
        }
    }

    public Object getObject() throws NamingException {
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(this.mySerializedObject);
            ReceiveStream obin = new ReceiveStream(bin);
            byte objectType = obin.readByte();
            switch (objectType) {
                case 0: {
                    return obin.readSerializableObject();
                }
                case 1: {
                    return DestinationImpl.getDestinationFromStream(obin);
                }
                case 2: {
                    return new QueueConnectionFactoryImpl();
                }
                case 3: {
                    return new TopicConnectionFactoryImpl();
                }
            }
            throw new NamingException("unknown object type: " + objectType);
        }
        catch (NamingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new NamingException(ex.toString());
        }
    }

    public byte[] getSerializedObject() {
        return this.mySerializedObject;
    }

    public void putSerializedObject(byte[] object) {
        this.mySerializedObject = object;
    }

    public String[] parseCommand() throws ParserException {
        String command;
        String[] tokens = new String[2];
        StringTokenizer st = new StringTokenizer(this.getCommand());
        tokens[0] = command = this.nextToken(st, "Empty command!");
        if (command.equals("lookup")) {
            String name = "";
            tokens[1] = "";
            while (this.hasMoreTokens(st)) {
                name = this.nextToken(st, "Missing argument for <lookup>");
                tokens[1] = tokens[1] + name;
                if (!this.hasMoreTokens(st)) continue;
                tokens[1] = tokens[1] + " ";
            }
        } else if (command.equals("bind")) {
            String name = "";
            tokens[1] = "";
            while (this.hasMoreTokens(st)) {
                name = this.nextToken(st, "Missing argument for <bind>");
                tokens[1] = tokens[1] + name;
                if (!this.hasMoreTokens(st)) continue;
                tokens[1] = tokens[1] + " ";
            }
        } else if (command.equals("rebind")) {
            String name = "";
            tokens[1] = "";
            while (this.hasMoreTokens(st)) {
                name = this.nextToken(st, "Missing argument for <rebind>");
                tokens[1] = tokens[1] + name;
                if (!this.hasMoreTokens(st)) continue;
                tokens[1] = tokens[1] + " ";
            }
        } else {
            throw new ParserException("Unknown command <" + command + ">");
        }
        return tokens;
    }

    public String toString() {
        return "JndiNotification: " + super.toString();
    }
}

