/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.database;

import com.sap.sdb.msgServer.Server;
import com.sap.sdb.msgServer.client.MessageImpl;
import java.util.HashMap;

public class MessageCache {
    private int m_countCallStatistics = 0;
    private int m_maxMessages = 0;
    private long m_maxMessageSpace = 0L;
    private long m_maxSpacePerMessage = 0L;
    private long m_usedMessageSpace = 0L;
    private long m_countSearch = 0L;
    private long m_countReceived = 0L;
    private HashMap m_hashMap = null;
    private Entry m_first = null;
    private Entry m_last = null;
    private static MessageCache m_cache = new MessageCache();
    private static final int MIN_MESSAGES = 10;
    private static final int MAX_MESSAGES = 100000;
    private static final int MIN_SPACE_PER_MSG = 256;

    private MessageCache() {
    }

    private void addToList(Entry entry) {
        if (this.m_first == null) {
            this.m_last = entry;
        } else {
            this.m_first.m_prev = entry;
        }
        entry.m_next = this.m_first;
        entry.m_prev = null;
        this.m_first = entry;
    }

    public static void createInstance(long maxMessageSpaceKB) {
        if (maxMessageSpaceKB <= 0L) {
            return;
        }
        long wantedSpace = maxMessageSpaceKB * 1024L;
        if (wantedSpace < 2560L) {
            wantedSpace = 2560L;
        }
        m_cache.init(wantedSpace);
    }

    private void decreaseUsedMessageSpace(long releasedBytes) {
        if (releasedBytes <= 0L) {
            return;
        }
        this.m_usedMessageSpace = this.m_usedMessageSpace > releasedBytes ? this.m_usedMessageSpace - releasedBytes : 0L;
    }

    public static MessageImpl get(long msgID) {
        if (MessageCache.m_cache.m_maxMessageSpace <= 0L) {
            return null;
        }
        return m_cache.getMessage(msgID);
    }

    private synchronized MessageImpl getMessage(long msgID) {
        if (this.m_countSearch < Long.MAX_VALUE) {
            ++this.m_countSearch;
        } else {
            this.m_countSearch = 1L;
            this.m_countReceived = 0L;
        }
        Long key = new Long(msgID);
        Entry entry = (Entry)this.m_hashMap.get(key);
        if (entry == null) {
            return null;
        }
        if (entry.m_key.compareTo(key) != 0) {
            this.removeEntry(entry, key);
            return null;
        }
        MessageImpl msg = entry.m_msg;
        if (msg.isQueueMessage()) {
            this.removeEntry(entry);
        } else {
            this.reorder(entry);
        }
        ++this.m_countReceived;
        return msg;
    }

    private synchronized void init(long maxMessageSpace) {
        if (2560L > maxMessageSpace) {
            return;
        }
        this.m_maxMessageSpace = maxMessageSpace;
        this.m_maxSpacePerMessage = maxMessageSpace / 10L;
        this.m_maxMessages = maxMessageSpace / 256L > 100000L ? 100000 : (int)(maxMessageSpace / 256L);
        this.m_hashMap = new HashMap(this.m_maxMessages);
        Server.log("Message cache: " + maxMessageSpace / 1024L + " KB");
    }

    public static void insert(MessageImpl msg) {
        if (MessageCache.m_cache.m_maxMessageSpace <= 0L) {
            return;
        }
        long usedBytes = msg.getBytesUsed();
        if (usedBytes > MessageCache.m_cache.m_maxSpacePerMessage) {
            return;
        }
        m_cache.insertMessage(msg, usedBytes);
    }

    private synchronized void insertMessage(MessageImpl msg, long usedBytes) {
        if (this.m_usedMessageSpace + usedBytes > this.m_maxMessageSpace) {
            int maxEntriesToRemove = this.m_hashMap.size() >= 10 ? this.m_hashMap.size() / 10 : (this.m_hashMap.size() > 0 ? 1 : 0);
            for (int i = 0; i < maxEntriesToRemove; ++i) {
                this.removeLast();
                if (this.m_usedMessageSpace + usedBytes <= this.m_maxMessageSpace) break;
            }
        }
        if (this.m_usedMessageSpace + usedBytes > this.m_maxMessageSpace) {
            return;
        }
        if (this.m_hashMap.size() >= this.m_maxMessages) {
            this.removeLast();
        }
        Entry entry = new Entry(msg, usedBytes);
        Entry oldEntry = (Entry)this.m_hashMap.get(entry.m_key);
        if (oldEntry != null) {
            this.removeEntry(oldEntry, entry.m_key);
        }
        this.m_hashMap.put(entry.m_key, entry);
        this.addToList(entry);
        this.m_usedMessageSpace += usedBytes;
    }

    private synchronized String printCacheStatistics() {
        ++this.m_countCallStatistics;
        String prefix = "    Message cache:      ";
        String ret = "    Message cache:      space       = " + this.m_usedMessageSpace / 1024L + "/" + this.m_maxMessageSpace / 1024L + " KB" + Server.lineSep;
        ret = ret + "    Message cache:      used space  = " + this.m_usedMessageSpace / (this.m_maxMessageSpace / 100L) + "%" + Server.lineSep;
        ret = ret + "    Message cache:      messages    = " + this.m_hashMap.size() + Server.lineSep;
        if (this.m_usedMessageSpace <= 0L) {
            this.m_countSearch = 0L;
            this.m_countReceived = 0L;
        }
        if (this.m_countSearch > 0L) {
            long hitRate = 92233720368547758L < this.m_countReceived ? this.m_countReceived / (this.m_countSearch / 100L) : this.m_countReceived * 100L / this.m_countSearch;
            ret = ret + "    Message cache:      hit rate    = " + hitRate + "%" + Server.lineSep;
        }
        if (this.m_countCallStatistics >= 100) {
            this.m_countCallStatistics = 0;
            this.m_countSearch = 0L;
            this.m_countReceived = 0L;
        }
        return ret;
    }

    public static String printStatistics() {
        if (MessageCache.m_cache.m_maxMessageSpace <= 0L) {
            return "";
        }
        return m_cache.printCacheStatistics();
    }

    private void removeEntry(Entry entry) {
        this.removeEntry(entry, entry.m_key);
    }

    private void removeEntry(Entry entry, Long key) {
        if (key != null) {
            this.m_hashMap.remove(key);
        }
        if (entry != null) {
            this.decreaseUsedMessageSpace(entry.m_usedBytes);
            this.removeFromList(entry);
            entry.clear();
        }
    }

    private void removeFromList(Entry removeEntry) {
        if (removeEntry == this.m_first) {
            this.m_first = removeEntry.m_next;
        } else {
            removeEntry.m_prev.m_next = removeEntry.m_next;
        }
        if (removeEntry == this.m_last) {
            this.m_last = removeEntry.m_prev;
        } else {
            removeEntry.m_next.m_prev = removeEntry.m_prev;
        }
    }

    private void removeLast() {
        if (this.m_last == null) {
            return;
        }
        Entry entry = this.m_last;
        this.decreaseUsedMessageSpace(entry.m_usedBytes);
        this.m_hashMap.remove(entry.m_key);
        this.removeFromList(entry);
        entry.clear();
    }

    private void reorder(Entry entry) {
        this.removeFromList(entry);
        this.addToList(entry);
    }

    private static class Entry {
        MessageImpl m_msg;
        Long m_key;
        long m_usedBytes;
        Entry m_next;
        Entry m_prev;

        Entry(MessageImpl msg, long usedBytes) {
            this.m_msg = msg;
            this.m_key = new Long(msg.getMessageID());
            this.m_usedBytes = usedBytes;
            this.m_next = null;
            this.m_prev = null;
        }

        void clear() {
            this.m_msg = null;
            this.m_key = null;
            this.m_next = null;
            this.m_prev = null;
        }
    }
}

