/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.database;

import com.sap.sdb.msgServer.Server;
import com.sap.sdb.msgServer.database.DBConnectionPool;
import com.sap.sdb.msgServer.database.DeliveryPreparedStmt;
import com.sap.sdb.msgServer.database.DeliveryResultSet;
import com.sap.sdb.msgServer.database.UserConnection;
import com.sap.sdb.msgServer.service.JmsService;
import com.sap.sdb.msgServer.util.DestinationAuth;
import com.sap.sdb.msgServer.util.DestinationEntity;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.JMSException;

public class DestinationList {
    private static final int MAX_LOW_SEQ = 1000000;
    private static final int SEQ_HI = 0;
    private static final int SEQ_LO = 1;
    public static final String WILD_CARD = "%";
    private static DestinationList sDestination = null;
    private Hashtable myDestinations = new Hashtable(10);
    private Hashtable mySequenceNumberForDest = new Hashtable(100);
    private long myHiSequenceNumberForTans;
    private long myLoSequenceNumberForTans;

    private DestinationList() {
    }

    public static synchronized void createInstance(UserConnection dbConnection) throws SQLException {
        if (sDestination != null) {
            throw new IllegalStateException("Destination singleton already created.");
        }
        sDestination = new DestinationList();
        DestinationList.init(dbConnection);
        DestinationList.reinitTransSeq(dbConnection);
    }

    public static synchronized void destroyInstance() {
        if (sDestination == null) {
            throw new IllegalStateException("Destination singleton not created.");
        }
        sDestination = null;
    }

    private static DestinationList getInstance() {
        if (sDestination == null) {
            throw new IllegalStateException("Destination singleton not created.");
        }
        return sDestination;
    }

    private static synchronized void addDestination(UserConnection dbConnection, DestinationEntity dest) {
        Long aDestID = new Long(dest.getID());
        Long[] seq = new Long[2];
        seq[1] = new Long(0L);
        seq[0] = new Long(DestinationList.getNewSequence(dbConnection, 0L));
        DestinationList.getInstance().myDestinations.put(dest.getName() + ",IsQueue:" + new Boolean(dest.isQueue()).toString(), dest);
        DestinationList.getInstance().mySequenceNumberForDest.put(aDestID, seq);
    }

    private static synchronized Long removeDestination(String destName, boolean isQueue) {
        Long retval = null;
        DestinationEntity dest = (DestinationEntity)DestinationList.getInstance().myDestinations.remove(destName + ",IsQueue:" + new Boolean(isQueue).toString());
        if (dest != null) {
            retval = new Long(dest.getID());
        }
        return retval;
    }

    public static long getDestinationID(String destName, boolean isQueue) {
        DestinationEntity dest = (DestinationEntity)DestinationList.getInstance().myDestinations.get(destName + ",IsQueue:" + new Boolean(isQueue).toString());
        if (dest == null) {
            return -1L;
        }
        return dest.getID();
    }

    public static DestinationEntity getDestination(String destName, boolean isQueue) {
        DestinationEntity dest = (DestinationEntity)DestinationList.getInstance().myDestinations.get(destName + ",IsQueue:" + new Boolean(isQueue).toString());
        return dest;
    }

    public static Vector listDestinations(boolean isQueue, String destName) {
        boolean bWildCard = false;
        int nameLength = destName.length();
        if (destName.endsWith(WILD_CARD)) {
            destName = destName.substring(0, --nameLength);
            bWildCard = true;
        }
        String isQueueString = ",IsQueue:" + new Boolean(isQueue).toString();
        String destKey = null;
        String destKeyName = null;
        Vector<String> destinations = new Vector<String>();
        Enumeration e = DestinationList.getInstance().myDestinations.keys();
        while (e.hasMoreElements()) {
            destKey = (String)e.nextElement();
            int lastIndex = destKey.lastIndexOf(isQueueString);
            if (lastIndex <= -1) continue;
            destKeyName = destKey.substring(0, lastIndex);
            if (nameLength == 0) {
                destinations.add(destKeyName);
                continue;
            }
            if (bWildCard) {
                if (nameLength > destKeyName.length() || !destKeyName.substring(0, nameLength).equals(destName)) continue;
                destinations.add(destKeyName);
                continue;
            }
            if (!destKeyName.equals(destName)) continue;
            destinations.add(destKeyName);
        }
        return destinations;
    }

    private static void init(UserConnection dbConnection) throws SQLException {
        DeliveryPreparedStmt stmt = dbConnection.getAvailablePreparedStmt(22);
        DeliveryResultSet row = stmt.executeQuery();
        Server.log("init destination list ...");
        while (row.next()) {
            DestinationEntity dest = new DestinationEntity();
            dest.setID(row.getLong(1));
            dest.setName(row.getString(2));
            dest.setQueue(row.getBoolean(3));
            DestinationList.setDestinationAuthentication(dbConnection, dest);
            if (DestinationList.getDestinationID(dest.getName(), dest.isQueue()) >= 0L) continue;
            DestinationList.addDestination(dbConnection, dest);
        }
        row.close();
    }

    public static DestinationEntity reinit(UserConnection dbConnection, String name, boolean isQueue) throws SQLException {
        DestinationEntity retval = null;
        DeliveryPreparedStmt stmt = dbConnection.getAvailablePreparedStmt(21);
        stmt.setString(1, name);
        stmt.setBoolean(2, isQueue);
        DeliveryResultSet row = stmt.executeQuery();
        if (row.next()) {
            DestinationEntity dest = new DestinationEntity();
            dest.setID(row.getLong(1));
            dest.setQueue(isQueue);
            dest.setName(name);
            DestinationList.setDestinationAuthentication(dbConnection, dest);
            retval = dest;
            if (DestinationList.getDestinationID(name, isQueue) < 0L) {
                DestinationList.addDestination(dbConnection, dest);
            }
        }
        row.close();
        return retval;
    }

    private static void setDestinationAuthentication(UserConnection dbConnection, DestinationEntity dest) throws SQLException {
        DeliveryPreparedStmt stmt = dbConnection.getAvailablePreparedStmt(23);
        stmt.setLong(1, dest.getID());
        DeliveryResultSet row = stmt.executeQuery();
        while (row.next()) {
            dest.setDestinationAuth(new DestinationAuth(row.getString(1), row.getString(2), row.getBoolean(3)));
        }
        row.close();
    }

    public static synchronized void deleteByName(UserConnection dbConnection, String name, boolean isQueue) throws SQLException, JMSException {
        int rowCount;
        DeliveryPreparedStmt stmt;
        Long destID = DestinationList.removeDestination(name, isQueue);
        if (destID != null) {
            stmt = dbConnection.getAvailablePreparedStmt(18);
            stmt.setLong(1, destID);
            rowCount = stmt.executeUpdate();
            if (rowCount == 0) {
                throw new JMSException("Could not delete destination or sequence for <" + name + ">,IsQueue:" + new Boolean(isQueue).toString());
            }
        } else {
            throw new JMSException("Could not delete destination or sequence for <" + name + ">,IsQueue:" + new Boolean(isQueue).toString());
        }
        stmt = dbConnection.getAvailablePreparedStmt(25);
        stmt.setLong(1, destID);
        rowCount = stmt.executeUpdate();
    }

    public static void persist(UserConnection dbConnection, DestinationEntity dest) throws JMSException {
        if (dest.isValid()) {
            try {
                DeliveryPreparedStmt stmt = dbConnection.getAvailablePreparedStmt(17);
                stmt.setLong(1, dest.getID());
                stmt.setString(2, dest.getName());
                stmt.setBoolean(3, dest.isQueue());
                stmt.executeUpdate();
                Vector auth = dest.getAuthentication();
                for (int i = 0; i < auth.size(); ++i) {
                    DestinationAuth oneAuth = (DestinationAuth)auth.get(i);
                    stmt = dbConnection.getAvailablePreparedStmt(24);
                    stmt.setLong(1, dest.getID());
                    stmt.setString(2, oneAuth.getUser());
                    stmt.setString(3, oneAuth.getPassword());
                    stmt.setBoolean(4, oneAuth.getIsReadPass());
                    stmt.executeUpdate();
                }
            }
            catch (SQLException ex) {
                throw new JMSException(ex.toString());
            }
        } else {
            throw new JMSException("attempt to create a destinationEntity record with uninitialized data");
        }
        DestinationList.addDestination(dbConnection, dest);
    }

    public static synchronized long getSequenceNumberForTrans(UserConnection dbConnection) {
        ++DestinationList.getInstance().myLoSequenceNumberForTans;
        if (DestinationList.getInstance().myLoSequenceNumberForTans > 999999L) {
            DestinationList.getInstance().myLoSequenceNumberForTans = 0L;
            DestinationList.getInstance().myHiSequenceNumberForTans = DestinationList.getNewSequence(dbConnection, DestinationList.getInstance().myHiSequenceNumberForTans);
        }
        long newSeq = DestinationList.getInstance().myHiSequenceNumberForTans * 1000000L + DestinationList.getInstance().myLoSequenceNumberForTans;
        return newSeq;
    }

    public static synchronized long getSequenceNumberForMsg(UserConnection dbConnection, long destID) {
        Long aDestID = new Long(destID);
        Long[] seq = (Long[])DestinationList.getInstance().mySequenceNumberForDest.get(aDestID);
        if (seq != null) {
            long lowSeq = seq[1];
            long hiSeq = seq[0];
            if (++lowSeq > 999999L) {
                lowSeq = 0L;
                hiSeq = DestinationList.getNewSequence(dbConnection, hiSeq);
                seq[0] = new Long(hiSeq);
            }
            long newSeq = hiSeq * 1000000L + lowSeq;
            seq[1] = new Long(lowSeq);
            DestinationList.getInstance().mySequenceNumberForDest.put(aDestID, seq);
            return newSeq;
        }
        return -1L;
    }

    private static synchronized void reinitTransSeq(UserConnection dbConnection) {
        DestinationList.getInstance().myLoSequenceNumberForTans = 0L;
        DestinationList.getInstance().myHiSequenceNumberForTans = DestinationList.getNewSequence(dbConnection, DestinationList.getInstance().myHiSequenceNumberForTans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static long getNewSequence(UserConnection dbConnection, long oldValue) {
        long newTransSeq;
        block13: {
            DeliveryResultSet result;
            block12: {
                newTransSeq = 1L;
                if (!DBConnectionPool.existsConnection(2)) {
                    return ++oldValue;
                }
                result = null;
                DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(74, 2);
                result = stmt.executeQuery();
                if (!result.next()) break block12;
                newTransSeq = result.getLong(1);
            }
            Object var8_6 = null;
            try {
                if (result != null) {
                    result.close();
                }
                break block13;
            }
            catch (SQLException ex2) {}
            break block13;
            {
                catch (SQLException ex) {
                    JmsService.logException(ex);
                    Object var8_7 = null;
                    try {
                        if (result != null) {
                            result.close();
                        }
                        break block13;
                    }
                    catch (SQLException ex2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return newTransSeq;
    }
}

