/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.client;

import com.sap.sdb.msgServer.client.ConnectionImpl;
import com.sap.sdb.msgServer.client.SessionImpl;
import com.sap.sdb.msgServer.client.TopicBrowserImpl;
import com.sap.sdb.msgServer.client.TopicSubscriberImpl;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class TopicSessionImpl
extends SessionImpl
implements TopicSession {
    public TopicSessionImpl(ConnectionImpl connection, boolean transacted, int acknowledgeMode) throws JMSException {
        super(connection, transacted, false, acknowledgeMode);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return super.createDurableSubscriber(topic, name, "", false);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String msgSelector, boolean noLocal) throws JMSException {
        return super.createDurableSubscriber(topic, name, msgSelector, noLocal);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return super.createPublisher(topic);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return this.createSubscriber(topic, "", false);
    }

    public TopicSubscriber createSubscriber(Topic topic, String msgSelector, boolean noLocal) throws JMSException {
        this.checkConnectionState();
        this.checkSessionState();
        if (topic instanceof TemporaryTopic) {
            this.checkTempTopicExists(topic);
        }
        TopicSubscriberImpl subscriber = new TopicSubscriberImpl(topic, this, false, "", msgSelector, noLocal);
        this.addMessageConsumer(subscriber);
        return subscriber;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return super.createTemporaryTopic();
    }

    public Topic createTopic(String name) throws JMSException {
        return super.createTopic(name);
    }

    public void unsubscribe(String name) throws JMSException {
        super.unsubscribe(name);
    }

    public TopicBrowserImpl createBrowser(Topic topic) throws JMSException {
        return this.createBrowser(topic, "");
    }

    public TopicBrowserImpl createBrowser(Topic topic, String msgSelector) throws JMSException {
        this.checkSessionState();
        if (this.getIsClosed()) {
            throw new IllegalStateException("Session is closed");
        }
        if (this.getConnection() == null) {
            throw new JMSException("No connection available");
        }
        if (!this.getConnection().isStarted()) {
            throw new JMSException("Connection is not started");
        }
        return new TopicBrowserImpl(topic, this, msgSelector);
    }
}

