/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.client;

import com.sap.sdb.msgServer.client.ClientOID;
import com.sap.sdb.msgServer.client.ConnectionImpl;
import com.sap.sdb.msgServer.client.DestinationImpl;
import com.sap.sdb.msgServer.client.QueueImpl;
import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendStream;
import java.io.IOException;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.TemporaryQueue;

public class TemporaryQueueImpl
extends QueueImpl
implements TemporaryQueue,
Serializable {
    private transient ConnectionImpl myConnection;

    private TemporaryQueueImpl() {
        this.myConnection = null;
    }

    public TemporaryQueueImpl(ConnectionImpl aConnection) {
        super(new Long(ClientOID.getNext()).toString());
        this.myConnection = aConnection;
    }

    public void delete() throws JMSException {
        if (this.myConnection == null) {
            throw new JMSException("TemporaryQueue " + this.getDestinationName() + " cannot be deleted after serialization");
        }
        this.myConnection.removeTemporaryQueue(this);
    }

    public static DestinationImpl readFromStream(ReceiveStream in) throws IOException {
        TemporaryQueueImpl tempQueueObj = new TemporaryQueueImpl();
        tempQueueObj.deserialize(in);
        return tempQueueObj;
    }

    public void writeToStream(SendStream out) throws IOException {
        this.serialize(out, 3);
    }
}

