/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.client;

import com.sap.sdb.msgServer.client.ConnectionImpl;
import com.sap.sdb.msgServer.client.QueueReceiverImpl;
import com.sap.sdb.msgServer.client.SessionImpl;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;

public class QueueSessionImpl
extends SessionImpl
implements QueueSession {
    public QueueSessionImpl(ConnectionImpl connection, boolean transacted, int acknowledgeMode) throws JMSException {
        super(connection, transacted, true, acknowledgeMode);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return super.createBrowser(queue, "");
    }

    public QueueBrowser createBrowser(Queue queue, String msgSelector) throws JMSException {
        return super.createBrowser(queue, msgSelector);
    }

    public Queue createQueue(String name) throws JMSException {
        return super.createQueue(name);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return this.createReceiver(queue, "");
    }

    public QueueReceiver createReceiver(Queue queue, String msgSelector) throws JMSException {
        this.checkSessionState();
        if (queue instanceof TemporaryQueue && this.getConnection().getTemporaryQueue(queue) == null) {
            throw new JMSException("Temporary Queue" + queue.getQueueName() + " does not exits.");
        }
        QueueReceiverImpl receiver = new QueueReceiverImpl(queue, this, msgSelector);
        this.addMessageConsumer(receiver);
        return receiver;
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        return super.createSender(queue);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return super.createTemporaryQueue();
    }
}

