/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.client;

import com.sap.sdb.msgServer.client.ClientNetworkHandler;
import com.sap.sdb.msgServer.client.ClientOID;
import com.sap.sdb.msgServer.client.ConnectionMetaDataImpl;
import com.sap.sdb.msgServer.client.QueueSessionImpl;
import com.sap.sdb.msgServer.client.SessionImpl;
import com.sap.sdb.msgServer.client.TopicSessionImpl;
import com.sap.sdb.msgServer.util.DestinationAdminNotification;
import com.sap.sdb.msgServer.util.NotificationException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;

public class ConnectionImpl
implements Connection {
    private boolean m_QueueConnection;
    private boolean myIsStarted;
    private LinkedList mySessions;
    private ExceptionListener myExceptionListener;
    private Hashtable myTemporaryDestinations;
    private ClientNetworkHandler network_handler = null;
    private String m_user = null;
    private String m_password = null;

    private void init(Hashtable env) throws IOException, NotificationException {
        this.myIsStarted = false;
        this.mySessions = new LinkedList();
        this.myTemporaryDestinations = new Hashtable(100);
        Integer port = new Integer((String)env.get("jms.port"));
        String host = (String)env.get("jms.host");
        Integer timeOut = new Integer((String)env.get("jms.timeout"));
        String logfile = (String)env.get("jms.logfile");
        int maxClientQueueSize = Integer.MAX_VALUE;
        String temp = (String)env.get("jms.maxqueuesize");
        if (temp != null && (temp = temp.trim()).length() > 0) {
            maxClientQueueSize = Integer.parseInt(temp);
        }
        boolean verbose = false;
        temp = (String)env.get("jms.verbose");
        if (temp != null && (temp = temp.trim()).length() > 0) {
            verbose = Integer.parseInt(temp) == 1;
        }
        boolean useSSL = false;
        temp = (String)env.get("jms.ssl");
        if (temp != null && (temp = temp.trim()).length() > 0) {
            useSSL = Integer.parseInt(temp) == 1;
        }
        this.network_handler = new ClientNetworkHandler(host, port, timeOut, logfile, maxClientQueueSize, useSSL, verbose, this.m_user, this.m_password);
        this.network_handler.registerConnection(this);
        if (!ClientOID.getInit()) {
            ClientOID.init(this.network_handler.requestServerTime());
        }
    }

    protected ConnectionImpl(Hashtable env, boolean queueConnection) throws IOException, NotificationException {
        this(env, "", "", queueConnection);
    }

    protected ConnectionImpl(Hashtable env, String user, String password, boolean queueConnection) throws IOException, NotificationException {
        this.m_QueueConnection = queueConnection;
        this.m_user = user;
        this.m_password = password;
        this.init(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        this.network_handler.unregisterConnection(this);
        try {
            ListIterator iter = this.mySessions.listIterator();
            while (iter.hasNext()) {
                ((SessionImpl)iter.next()).close();
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.removeAllTemporaryDestinations();
            if (this.network_handler.getConnectionCount() == 0) {
                this.network_handler.stop();
            }
            throw throwable;
        }
        this.removeAllTemporaryDestinations();
        if (this.network_handler.getConnectionCount() == 0) {
            this.network_handler.stop();
        }
    }

    public String getClientID() throws JMSException {
        return this.network_handler.getClientIDString();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.myExceptionListener;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return new ConnectionMetaDataImpl();
    }

    public void setClientID(String value) throws JMSException {
        throw new JMSException("Method setClientID() not supported from this JMS provider.");
    }

    public void setExceptionListener(ExceptionListener value) throws JMSException {
        this.myExceptionListener = value;
    }

    public synchronized void start() throws JMSException {
        if (!this.myIsStarted) {
            ListIterator iter = this.mySessions.listIterator();
            while (iter.hasNext()) {
                ((SessionImpl)iter.next()).startAsyncConsumer();
            }
            this.myIsStarted = true;
        }
    }

    public synchronized void stop() throws JMSException {
        if (this.myIsStarted) {
            this.myIsStarted = false;
            ListIterator iter = this.mySessions.listIterator();
            while (iter.hasNext()) {
                ((SessionImpl)iter.next()).stopAsyncConsumer(false);
            }
        }
    }

    public ClientNetworkHandler getNetworkHandler() {
        return this.network_handler;
    }

    public boolean isStarted() {
        return this.myIsStarted;
    }

    public void addSession(SessionImpl session) throws JMSException {
        this.mySessions.addLast(session);
    }

    public void addTemporaryTopic(TemporaryTopic topic) throws JMSException {
        TemporaryTopic oldTopic = this.myTemporaryDestinations.put(topic.getTopicName() + "-ATOPIC", topic);
        if (oldTopic != null) {
            this.myTemporaryDestinations.put(oldTopic.getTopicName() + "-ATOPIC", oldTopic);
            throw new JMSException("TemporaryTopic already exits");
        }
        this.myTemporaryDestinations.put(topic.getTopicName() + "-ATOPIC", topic);
        this.createTemporaryTopic(topic);
    }

    public void addTemporaryQueue(TemporaryQueue queue) throws JMSException {
        TemporaryQueue oldQueue = this.myTemporaryDestinations.put(queue.getQueueName() + "-AQUEUE", queue);
        if (oldQueue != null) {
            this.myTemporaryDestinations.put(oldQueue.getQueueName() + "-AQUEUE", oldQueue);
            throw new JMSException("TemporaryQueue already exits");
        }
        this.myTemporaryDestinations.put(queue.getQueueName() + "-AQUEUE", queue);
        this.createTemporaryQueue(queue);
    }

    public void removeTemporaryTopic(TemporaryTopic topic) throws JMSException {
        this.checkIfTopicIsInUse((Topic)topic);
        this.dropTemporaryTopic(topic);
        this.myTemporaryDestinations.remove(topic.getTopicName() + "-ATOPIC");
    }

    public void removeTemporaryQueue(TemporaryQueue queue) throws JMSException {
        this.checkIfQueueIsInUse((Queue)queue);
        this.dropTemporaryQueue(queue);
        this.myTemporaryDestinations.remove(queue.getQueueName() + "-AQUEUE");
    }

    public TemporaryTopic getTemporaryTopic(Topic topic) throws JMSException {
        return (TemporaryTopic)this.myTemporaryDestinations.get(topic.getTopicName() + "-ATOPIC");
    }

    public TemporaryQueue getTemporaryQueue(Queue queue) throws JMSException {
        return (TemporaryQueue)this.myTemporaryDestinations.get(queue.getQueueName() + "-AQUEUE");
    }

    protected void finalize() {
        try {
            this.removeAllTemporaryDestinations();
        }
        catch (JMSException ex) {
            this.network_handler.log("Error removing temporary destinations: " + (Object)((Object)ex));
        }
    }

    private void removeAllTemporaryDestinations() throws JMSException {
        if (this.network_handler.isEstablished()) {
            Enumeration keys = this.myTemporaryDestinations.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Object dest = this.myTemporaryDestinations.get(key);
                if (dest instanceof TemporaryQueue) {
                    this.dropTemporaryQueue((TemporaryQueue)dest);
                }
                if (!(dest instanceof TemporaryTopic)) continue;
                this.dropTemporaryTopic((TemporaryTopic)dest);
            }
            this.myTemporaryDestinations.clear();
        }
    }

    private void createTemporaryTopic(TemporaryTopic topic) throws JMSException {
        DestinationAdminNotification aCommand = new DestinationAdminNotification(0, false, true, topic.getTopicName());
        try {
            this.network_handler.requestOK(aCommand);
        }
        catch (NotificationException ex) {
            throw new JMSException("Error creating temporary topic: " + ex);
        }
        catch (InterruptedException ex) {
            throw new JMSException("Error creating temporary topic: " + ex);
        }
    }

    private void dropTemporaryTopic(TemporaryTopic topic) throws JMSException {
        DestinationAdminNotification aCommand = new DestinationAdminNotification(1, false, true, topic.getTopicName());
        try {
            this.network_handler.requestOK(aCommand);
        }
        catch (NotificationException ex) {
            throw new JMSException("Error creating temporary topic: " + ex);
        }
        catch (InterruptedException ex) {
            throw new JMSException("Error creating temporary topic: " + ex);
        }
    }

    private void createTemporaryQueue(TemporaryQueue queue) throws JMSException {
        DestinationAdminNotification aCommand = new DestinationAdminNotification(0, true, true, queue.getQueueName());
        try {
            this.network_handler.requestOK(aCommand);
        }
        catch (NotificationException ex) {
            throw new JMSException("Error creating temporary queue: " + ex);
        }
        catch (InterruptedException ex) {
            throw new JMSException("Error creating temporary queue: " + ex);
        }
    }

    private void dropTemporaryQueue(TemporaryQueue queue) throws JMSException {
        DestinationAdminNotification aCommand = new DestinationAdminNotification(1, true, true, queue.getQueueName());
        try {
            this.network_handler.requestOK(aCommand);
        }
        catch (NotificationException ex) {
            throw new JMSException("Error creating temporary queue: " + ex);
        }
        catch (InterruptedException ex) {
            throw new JMSException("Error creating temporary queue: " + ex);
        }
    }

    private void checkIfQueueIsInUse(Queue queue) throws JMSException {
        ListIterator iter = this.mySessions.listIterator();
        while (iter.hasNext()) {
            ((SessionImpl)iter.next()).checkIfQueueIsInUse(queue);
        }
    }

    private void checkIfTopicIsInUse(Topic topic) throws JMSException {
        ListIterator iter = this.mySessions.listIterator();
        while (iter.hasNext()) {
            ((SessionImpl)iter.next()).checkIfTopicIsInUse(topic);
        }
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic parm1, String parm2, String parm3, ServerSessionPool parm4, int parm5) throws JMSException {
        throw new UnsupportedOperationException("Method createDurableConnectionConsumer() not yet implemented.");
    }

    public ConnectionConsumer createConnectionConsumer(Destination parm1, String parm2, ServerSessionPool parm3, int parm4) throws JMSException {
        throw new UnsupportedOperationException("Method createConnectionConsumer() not yet implemented.");
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (this.m_QueueConnection) {
            QueueSessionImpl session = new QueueSessionImpl(this, transacted, acknowledgeMode);
            this.addSession(session);
            return session;
        }
        TopicSessionImpl session = new TopicSessionImpl(this, transacted, acknowledgeMode);
        this.addSession(session);
        return session;
    }
}

