/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.agents;

import com.sap.sdb.msgServer.agents.FreeLists;
import com.sap.sdb.msgServer.agents.JmsOutputManager;
import com.sap.sdb.msgServer.agents.JmsThread;
import com.sap.sdb.msgServer.agents.SendingException;
import com.sap.sdb.msgServer.database.ConsumerList;
import com.sap.sdb.msgServer.database.DBConnectionPool;
import com.sap.sdb.msgServer.database.UserConnection;
import com.sap.sdb.msgServer.service.JmsService;
import com.sap.sdb.msgServer.service.ServiceException;
import com.sap.sdb.msgServer.util.InvalidSocketException;
import com.sap.sdb.msgServer.util.MessageNotification;
import com.sap.sdb.msgServer.util.SendNotification;
import com.sap.sdb.msgServer.util.SendingNotificationQueue;
import com.sap.sdb.msgServer.util.StreamString;
import java.io.IOException;
import java.sql.SQLException;
import javax.jms.JMSException;

public class SocketWriter
extends JmsThread {
    public SocketWriter(JmsService service) throws ServiceException {
        super(service, "SocketWriter");
    }

    public void doWork() throws InterruptedException {
        SendingNotificationQueue sendQueue = this.getJmsService().getSendingQueue();
        SendNotification sendNotification = sendQueue.getFirstMsgReadyToSend();
        if (sendNotification != null) {
            this.doCommand(sendNotification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doCommand(SendNotification sendNotification) {
        SendNotification nextSend = sendNotification;
        SendNotification currSend = null;
        MessageNotification messageNot = null;
        try {
            block21: {
                try {
                    while (nextSend != null) {
                        currSend = nextSend;
                        messageNot = currSend.getMessage();
                        this.increaseNotificationCount();
                        if (ConsumerList.getActiveConsumer(currSend.getReceiverClientAddress(), currSend.getConsumerID()) == null) {
                            throw new SendingException("ConsumerList: No valid consumer");
                        }
                        nextSend = JmsOutputManager.sendChronological(messageNot);
                        if (JmsService.getVerboseSendReceive()) {
                            this.log("Sent message <" + messageNot.getMessage().getMessageID() + ">, consumer <" + messageNot.getMessageConsumerInfo().getConsumerID() + ">");
                        }
                        FreeLists.freeSendNotification(currSend);
                        currSend = null;
                        FreeLists.freeMessageNot(messageNot);
                        messageNot = null;
                    }
                    Object var8_5 = null;
                    if (currSend == null) break block21;
                }
                catch (IOException ex) {
                    block22: {
                        if (currSend != null && messageNot != null) break block22;
                        this.logException(ex);
                        Object var8_6 = null;
                        if (currSend != null) {
                            FreeLists.freeSendNotification(currSend);
                        }
                        if (messageNot == null) return;
                        FreeLists.freeMessageNot(messageNot);
                        return;
                    }
                    try {
                        if (currSend.getReceiverClientAddress() != null) {
                            this.handleSendError(messageNot.getMessageConsumerInfo().getConsumerID(), messageNot.getMessageConsumerInfo().getClientSessionAddress().getClientID(), ex);
                        }
                    }
                    catch (JMSException ex2) {
                        this.log("doCommand:" + ex2.toString());
                    }
                    Object var8_7 = null;
                    if (currSend != null) {
                        FreeLists.freeSendNotification(currSend);
                    }
                    if (messageNot == null) return;
                    FreeLists.freeMessageNot(messageNot);
                    return;
                }
                catch (SendingException ex) {
                    block23: {
                        if (currSend != null && messageNot != null) break block23;
                        this.logException(ex);
                        Object var8_8 = null;
                        if (currSend != null) {
                            FreeLists.freeSendNotification(currSend);
                        }
                        if (messageNot == null) return;
                        FreeLists.freeMessageNot(messageNot);
                        return;
                    }
                    try {
                        if (currSend.getReceiverClientAddress() != null) {
                            this.handleSendError(messageNot.getMessageConsumerInfo().getConsumerID(), messageNot.getMessageConsumerInfo().getClientSessionAddress().getClientID(), ex);
                        }
                    }
                    catch (JMSException ex2) {
                        this.log("doCommand:" + ex2.toString());
                    }
                    Object var8_9 = null;
                    if (currSend != null) {
                        FreeLists.freeSendNotification(currSend);
                    }
                    if (messageNot == null) return;
                    FreeLists.freeMessageNot(messageNot);
                    return;
                }
                FreeLists.freeSendNotification(currSend);
            }
            if (messageNot == null) return;
            FreeLists.freeMessageNot(messageNot);
            return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (currSend != null) {
                FreeLists.freeSendNotification(currSend);
            }
            if (messageNot == null) throw throwable;
            FreeLists.freeMessageNot(messageNot);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSendError(long consumerID, StreamString receiverClientAddress, Exception ex) throws JMSException {
        UserConnection dbConnection = null;
        try {
            if (ex instanceof InvalidSocketException) {
                if (JmsService.getVerboseSendReceive()) {
                    this.log("Error while sending a message:" + ex.getMessage());
                }
            } else {
                this.log("Error while sending a message:" + ex.getMessage());
            }
            dbConnection = DBConnectionPool.useConnection();
            ConsumerList.unregisterAndCommit(dbConnection, this.getJmsService().getSendingQueue(), consumerID, receiverClientAddress, false);
        }
        catch (SQLException ex2) {
            try {
                this.logException(ex2);
            }
            catch (Throwable throwable) {
                DBConnectionPool.returnConnection(dbConnection);
                throw throwable;
            }
            DBConnectionPool.returnConnection(dbConnection);
        }
        DBConnectionPool.returnConnection(dbConnection);
    }
}

