/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.agents;

import com.sap.sdb.msgServer.agents.AdminException;
import com.sap.sdb.msgServer.agents.Agent;
import com.sap.sdb.msgServer.agents.FreeLists;
import com.sap.sdb.msgServer.agents.ReceivingException;
import com.sap.sdb.msgServer.agents.SendOrderPolling;
import com.sap.sdb.msgServer.agents.SyncReceiveHandler;
import com.sap.sdb.msgServer.client.DestinationImpl;
import com.sap.sdb.msgServer.client.MessageImpl;
import com.sap.sdb.msgServer.database.ConsumerList;
import com.sap.sdb.msgServer.database.DBConnectionPool;
import com.sap.sdb.msgServer.database.DestinationList;
import com.sap.sdb.msgServer.database.MessageTable;
import com.sap.sdb.msgServer.database.SendOrderTable;
import com.sap.sdb.msgServer.database.UserConnection;
import com.sap.sdb.msgServer.msgselector.MsgSelector;
import com.sap.sdb.msgServer.service.JmsService;
import com.sap.sdb.msgServer.service.ServiceException;
import com.sap.sdb.msgServer.util.BrowserNotification;
import com.sap.sdb.msgServer.util.ErrorNotification;
import com.sap.sdb.msgServer.util.MessageConsumerInfo;
import com.sap.sdb.msgServer.util.MessageNotification;
import com.sap.sdb.msgServer.util.Notification;
import com.sap.sdb.msgServer.util.NotificationQueue;
import com.sap.sdb.msgServer.util.SyncReceiveNotification;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;

public class ReceivingAgent
extends Agent {
    private UserConnection m_connection = null;
    Vector mySyncConsumers = new Vector(10);

    public ReceivingAgent(JmsService service, NotificationQueue notQueue) throws ServiceException {
        super(service, "ReceivingAgent", notQueue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Notification doCommand(Notification notification) {
        this.increaseNotificationCount();
        try {
            if (notification instanceof MessageNotification) {
                MessageNotification messageNot = (MessageNotification)notification;
                this.checkAuthorization(((DestinationImpl)messageNot.getMessage().getJMSDestination()).getDestinationName(), notification.getType() == 0 || notification.getType() == 1, messageNot.getClientSessionAddress().getClientID(), false);
                if (notification.getType() == 0) {
                    this.send((MessageNotification)notification, false);
                    return FreeLists.getOkNotification();
                } else if (notification.getType() == 1) {
                    this.send((MessageNotification)notification, true);
                    return FreeLists.getOkNotification();
                } else if (notification.getType() == 2) {
                    this.publish((MessageNotification)notification, false);
                    return FreeLists.getOkNotification();
                } else {
                    if (notification.getType() != 3) return new ErrorNotification("Invalid notification type: " + notification.getType());
                    this.publish((MessageNotification)notification, true);
                }
                return FreeLists.getOkNotification();
            } else {
                if (notification instanceof BrowserNotification) {
                    BrowserNotification browseNot = (BrowserNotification)notification;
                    this.checkAuthorization(browseNot.getDestName(), browseNot.getType() == 0, browseNot.getClientSessionAddress().getClientID(), false);
                    return this.browserPoll((BrowserNotification)notification);
                }
                if (!(notification instanceof SyncReceiveNotification)) return new ErrorNotification("Command not valid for ReceivingAgent");
                SyncReceiveNotification syncNot = (SyncReceiveNotification)notification;
                this.checkAuthorization(syncNot.getDestName(), syncNot.getDestType() == 0, notification.getClientSessionAddress().getClientID(), false);
                return SyncReceiveHandler.handleSyncRecReq((SyncReceiveNotification)notification);
            }
        }
        catch (ReceivingException ex) {
            this.logException(ex);
            return new ErrorNotification(ex);
        }
        catch (AdminException ex) {
            this.logException(ex);
            return new ErrorNotification(ex);
        }
        catch (JMSException ex) {
            this.logException((Exception)((Object)ex));
            return new ErrorNotification((Exception)((Object)ex));
        }
    }

    public void finishWork() throws Exception {
        if (this.m_connection != null) {
            this.m_connection.rollback();
            this.m_connection.close();
            this.m_connection = null;
        }
    }

    private void send(MessageNotification messageNot, boolean commit) throws ReceivingException {
        block18: {
            long messageID = 0L;
            long consumerID = 0L;
            MessageConsumerInfo syncConsumerInfo = null;
            try {
                MessageImpl aMessage = messageNot.getMessage();
                int modeDelivery = aMessage.getJMSDeliveryMode();
                aMessage.prepareForClient();
                long transactionID = -1L;
                if (!commit) {
                    transactionID = messageNot.getTransactionID();
                }
                if ((messageID = aMessage.getMessageID()) < 0L) {
                    throw new ReceivingException("messageID is not valid.");
                }
                long timeStamp = JmsService.getTimeStamp();
                aMessage.setJMSTimestamp(timeStamp);
                String queueName = ((Queue)aMessage.getJMSDestination()).getQueueName();
                long queueID = DestinationList.getDestinationID(queueName, true);
                if (queueID < 0L) {
                    throw new JMSException("Queue " + queueName + " not found");
                }
                long timeToLive = aMessage.getMessageTimeToLive();
                int messagePriority = aMessage.getJMSPriority();
                if (timeToLive > 0L) {
                    timeToLive += timeStamp;
                }
                this.initConnection();
                MessageTable.createMessage(this.m_connection, aMessage, queueID);
                if (commit) {
                    syncConsumerInfo = SyncReceiveHandler.getQueueConsumer(this.m_connection, modeDelivery, messageID, queueID);
                }
                boolean notifySendOrderPolling = false;
                boolean notifySyncConsumer = false;
                boolean hasActiveConsumer = ConsumerList.hasActiveConsumer(true, consumerID, queueID);
                if (syncConsumerInfo != null) {
                    SendOrderTable.insertOrderForQueue(this.m_connection, modeDelivery, messageID, syncConsumerInfo.getConsumerID(), queueID, transactionID, messagePriority, timeToLive, 2, hasActiveConsumer);
                    this.mySyncConsumers.add(syncConsumerInfo);
                    notifySyncConsumer = true;
                } else {
                    SendOrderTable.insertOrderForQueue(this.m_connection, modeDelivery, messageID, queueID, transactionID, messagePriority, timeToLive, hasActiveConsumer);
                    if (hasActiveConsumer && transactionID < 1L) {
                        notifySendOrderPolling = true;
                    }
                }
                this.m_connection.commit();
                if (notifySyncConsumer) {
                    this.sendMessageToSyncConsumers(this.mySyncConsumers, aMessage, modeDelivery);
                }
                if (notifySendOrderPolling) {
                    SendOrderPolling.notifyMessageArrived(modeDelivery);
                }
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 200) {
                    this.log("WARNING: Ignore message <" + messageID + ">; already retreived!");
                    break block18;
                }
                this.logException(ex);
                throw new ReceivingException(ex);
            }
            catch (JMSException ex) {
                this.logException((Exception)((Object)ex));
                throw new ReceivingException((Exception)((Object)ex));
            }
            finally {
                this.mySyncConsumers.clear();
            }
        }
    }

    private MessageNotification browserPoll(BrowserNotification notification) throws ReceivingException {
        MessageNotification messageNot = null;
        try {
            boolean isQueue = notification.getType() == 0;
            String destName = notification.getDestName();
            long destID = DestinationList.getDestinationID(destName, isQueue);
            if (destID < 0L) {
                throw new JMSException("Destination " + destName + " not found");
            }
            MessageImpl aMessage = null;
            long lastMessageID = notification.getLastMessageID();
            MsgSelector selector = this.getJmsService().getBrowserSelector(new Long(notification.getID()));
            this.initConnection();
            if (DBConnectionPool.existsTransientConnection()) {
                aMessage = this.getMsgForBrowserPolling(1, destID, lastMessageID, selector, isQueue);
            }
            if (aMessage == null && DBConnectionPool.existsPersistentConnection()) {
                aMessage = this.getMsgForBrowserPolling(2, destID, lastMessageID, selector, isQueue);
            }
            messageNot = FreeLists.getMessageNot(aMessage);
            if (aMessage == null) {
                messageNot.setNullMessage();
            }
            this.m_connection.commit();
        }
        catch (SQLException ex) {
            this.logException(ex);
            throw new ReceivingException(ex);
        }
        catch (JMSException ex) {
            this.logException((Exception)((Object)ex));
            throw new ReceivingException((Exception)((Object)ex));
        }
        return messageNot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageImpl getMsgForBrowserPolling(int modeDelivery, long destID, long lastMessageID, MsgSelector selector, boolean queueOrders) throws JMSException, ReceivingException, SQLException {
        MessageImpl aMessage = null;
        ResultSet result = null;
        long messageID = 0L;
        try {
            result = SendOrderTable.getResultForBrowser(this.m_connection, modeDelivery, destID, lastMessageID, queueOrders);
            while (result != null && result.next() && messageID < 1L) {
                messageID = result.getLong(4);
                if (messageID <= 0L || MessageTable.matches(this.m_connection, modeDelivery, messageID, selector)) continue;
                messageID = 0L;
                aMessage = null;
            }
            if (messageID > 0L && (aMessage = MessageTable.findByID(this.m_connection, modeDelivery, messageID)) == null) {
                throw new ReceivingException("Message for QueueBrowser not found (MessageID: " + messageID + ")");
            }
            Object var13_9 = null;
        }
        catch (Throwable throwable) {
            Object var13_10 = null;
            try {
                if (result != null) {
                    result.close();
                    result = null;
                }
            }
            catch (SQLException ex) {
                this.log("Could not close result set due to: " + ex);
            }
            throw throwable;
        }
        try {
            if (result != null) {
                result.close();
                result = null;
            }
        }
        catch (SQLException ex) {
            this.log("Could not close result set due to: " + ex);
        }
        return aMessage;
    }

    /*
     * Loose catch block
     */
    private void publish(MessageNotification messageNot, boolean commit) throws ReceivingException {
        block32: {
            ResultSet result;
            long messageID;
            block30: {
                messageID = 0L;
                result = null;
                MsgSelector selector = null;
                MessageConsumerInfo syncConsumerInfo = null;
                MessageConsumerInfo asyncConsumerInfo = null;
                MessageImpl aMessage = messageNot.getMessage();
                int modeDelivery = aMessage.getJMSDeliveryMode();
                aMessage.prepareForClient();
                long transactionID = -1L;
                long consumerID = 0L;
                if (!commit) {
                    transactionID = messageNot.getTransactionID();
                }
                if ((messageID = aMessage.getMessageID()) < 0L) {
                    throw new ReceivingException("messageID is not valid.");
                }
                String topicName = ((Topic)aMessage.getJMSDestination()).getTopicName();
                long topicID = DestinationList.getDestinationID(topicName, false);
                if (topicID < 0L) {
                    throw new JMSException("Topic " + topicName + " not found");
                }
                long timeStamp = JmsService.getTimeStamp();
                aMessage.setJMSTimestamp(timeStamp);
                long timeToLive = aMessage.getMessageTimeToLive();
                if (timeToLive > 0L) {
                    timeToLive += timeStamp;
                }
                int messagePriority = aMessage.getJMSPriority();
                this.initConnection();
                result = SendOrderTable.getPossibleConsumersForTopic(this.m_connection, modeDelivery, topicID);
                long msgSeq = 0L;
                long transSeq = 0L;
                boolean bMessageCreated = false;
                int iInProc = 0;
                boolean bInsertSendOrder = true;
                int iPort = 0;
                boolean notifySendOrderPolling = false;
                boolean notifySyncConsumers = false;
                if (result != null) {
                    while (result.next()) {
                        consumerID = result.getLong(1);
                        selector = null;
                        syncConsumerInfo = null;
                        asyncConsumerInfo = ConsumerList.getActiveConsumer(consumerID);
                        if (asyncConsumerInfo != null) {
                            selector = asyncConsumerInfo.getMsgSelector();
                        } else {
                            if (commit && (syncConsumerInfo = SyncReceiveHandler.getTopicConsumer(consumerID, topicID)) != null) {
                                selector = syncConsumerInfo.getMsgSelector();
                            }
                            if (syncConsumerInfo == null && (asyncConsumerInfo = ConsumerList.getInactiveConsumer(consumerID)) != null) {
                                selector = asyncConsumerInfo.getMsgSelector();
                            }
                        }
                        if (asyncConsumerInfo != null && asyncConsumerInfo.getNoLocal()) {
                            iPort = asyncConsumerInfo.getClientSessionAddress().getClientPort();
                            bInsertSendOrder = iPort != messageNot.getPort();
                        }
                        if (syncConsumerInfo != null && syncConsumerInfo.getNoLocal()) {
                            iPort = syncConsumerInfo.getClientSessionAddress().getClientPort();
                            bInsertSendOrder = iPort != messageNot.getPort();
                        }
                        if (!bInsertSendOrder || selector != null && !selector.matches(aMessage.getHeaderFields(), aMessage.getPropertyList())) continue;
                        if (!bMessageCreated) {
                            MessageTable.createMessage(this.m_connection, aMessage, topicID);
                            bMessageCreated = true;
                            msgSeq = DestinationList.getSequenceNumberForMsg(this.m_connection, topicID);
                            transSeq = DestinationList.getSequenceNumberForTrans(this.m_connection);
                        }
                        boolean hasActiveConsumer = ConsumerList.hasActiveConsumer(false, consumerID, topicID);
                        if (syncConsumerInfo != null) {
                            this.mySyncConsumers.add(syncConsumerInfo);
                            iInProc = 2;
                            notifySyncConsumers = true;
                        } else {
                            iInProc = 0;
                            if (hasActiveConsumer && transactionID < 1L) {
                                notifySendOrderPolling = true;
                            }
                        }
                        SendOrderTable.insertOrderForTopic(this.m_connection, modeDelivery, messageID, consumerID, topicID, transSeq, msgSeq, transactionID, messagePriority, timeToLive, iInProc, hasActiveConsumer);
                    }
                    result.close();
                    result = null;
                }
                this.m_connection.commit();
                if (notifySyncConsumers) {
                    this.sendMessageToSyncConsumers(this.mySyncConsumers, aMessage, modeDelivery);
                }
                if (!notifySendOrderPolling) break block30;
                SendOrderPolling.notifyMessageArrived(modeDelivery);
            }
            Object var35_28 = null;
            try {
                if (result != null) {
                    result.close();
                    result = null;
                }
            }
            catch (SQLException ex2) {
                this.log("Could not close result set due to: " + ex2);
            }
            this.mySyncConsumers.clear();
            {
                break block32;
                catch (SQLException ex) {
                    if (ex.getErrorCode() != 200) {
                        this.logException(ex);
                        throw new ReceivingException(ex);
                    }
                    this.log("WARNING: Ignore message <" + messageID + ">; already retreived!");
                    Object var35_29 = null;
                    try {
                        if (result != null) {
                            result.close();
                            result = null;
                        }
                    }
                    catch (SQLException ex2) {
                        this.log("Could not close result set due to: " + ex2);
                    }
                    this.mySyncConsumers.clear();
                    break block32;
                }
                catch (JMSException ex) {
                    this.logException((Exception)((Object)ex));
                    throw new ReceivingException((Exception)((Object)ex));
                }
            }
            catch (Throwable throwable) {
                Object var35_30 = null;
                try {
                    if (result != null) {
                        result.close();
                        result = null;
                    }
                }
                catch (SQLException ex2) {
                    this.log("Could not close result set due to: " + ex2);
                }
                this.mySyncConsumers.clear();
                throw throwable;
            }
        }
    }

    private void sendMessageToSyncConsumers(Vector syncTopicConsumers, MessageImpl aMessage, int modeDelivery) throws ReceivingException, SQLException {
        MessageConsumerInfo syncConsumerInfo = null;
        Enumeration syncEnum = syncTopicConsumers.elements();
        while (syncEnum.hasMoreElements()) {
            syncConsumerInfo = (MessageConsumerInfo)syncEnum.nextElement();
            SyncReceiveHandler.sendMessage(aMessage, modeDelivery, syncConsumerInfo);
        }
    }

    private void initConnection() throws SQLException {
        if (this.m_connection == null) {
            this.m_connection = DBConnectionPool.getNewConnection();
        } else {
            this.m_connection.rollback();
        }
    }
}

