/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;

public class Console {
    private static final int MIN_FILE_SIZE = 50;
    private static final int DEFAULT_FILE_SIZE = 1000;
    private static final String OLD_FILE_PREFIX = "~";
    private static final String EMPTY_STRING = "";
    private boolean m_display = true;
    private int m_rowCount = 0;
    private int m_maxRows = 1000;
    private String m_currFilename = null;
    private String m_oldFilename = null;
    private PrintWriter m_fileWriter = null;
    private static Console s_instance = null;

    public static boolean createFile(String filename) {
        if (filename == null) {
            return false;
        }
        if (s_instance == null) {
            s_instance = new Console();
        }
        if (Console.s_instance.m_fileWriter != null) {
            return false;
        }
        return s_instance.initFile(filename);
    }

    public static void println() {
        if (s_instance == null) {
            System.out.println();
            return;
        }
        s_instance.writeln();
    }

    public static void println(String line) {
        if (s_instance == null) {
            System.out.println(line);
            return;
        }
        s_instance.writeln(line);
    }

    public static void printStackTrace(Exception ex) {
        if (s_instance == null) {
            s_instance = new Console();
        }
        s_instance.writeStackTrace(ex);
    }

    public static void printUsedMemory(String name) {
        if (s_instance == null) {
            s_instance = new Console();
        }
        s_instance.writeUsedMemory(name);
    }

    public static void setDisplay(boolean display) {
        if (s_instance == null) {
            if (display) {
                return;
            }
            s_instance = new Console();
        }
        Console.s_instance.m_display = display;
    }

    public static void setFileSize(int maxRows) {
        if (s_instance == null) {
            s_instance = new Console();
        }
        Console.s_instance.m_maxRows = maxRows == 0 ? Integer.MAX_VALUE : (maxRows < 50 ? 1000 : maxRows);
    }

    public Console() {
    }

    public Console(boolean display, String filename) {
        this.m_display = display;
        this.m_maxRows = Integer.MAX_VALUE;
        if (filename != null) {
            this.initFile(filename);
        }
    }

    public Console(boolean display, String filename, int maxRows) {
        this.m_display = display;
        this.m_maxRows = maxRows;
        if (filename != null) {
            this.initFile(filename);
        }
    }

    public synchronized void close() {
        if (this.m_fileWriter != null) {
            this.m_fileWriter.close();
            this.m_fileWriter = null;
        }
        if (this.m_display) {
            System.out.flush();
        }
    }

    public synchronized void flush() {
        if (this.m_fileWriter != null) {
            this.m_fileWriter.flush();
        }
        if (this.m_display) {
            System.out.flush();
        }
    }

    public void write(String line) {
        if (this.m_display) {
            System.out.print(line);
        }
        if (this.m_fileWriter != null) {
            this.writeFile(false, line);
        }
    }

    public void writeln() {
        if (this.m_display) {
            System.out.println();
        }
        if (this.m_fileWriter != null) {
            this.writeFile(true, EMPTY_STRING);
        }
    }

    public void writeln(String line) {
        if (this.m_display) {
            System.out.println(line);
        }
        if (this.m_fileWriter != null) {
            this.writeFile(true, line);
        }
    }

    public void writelnFileOnly(String line) {
        if (this.m_fileWriter != null) {
            this.writeFile(true, line);
        }
    }

    public synchronized void writeStackTrace(Exception ex) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteStream, true);
        ex.printStackTrace(printWriter);
        printWriter.flush();
        String stackTrace = byteStream.toString();
        printWriter.close();
        this.writeln(stackTrace);
        if (this.m_fileWriter != null) {
            this.m_fileWriter.flush();
        }
        if (this.m_display) {
            System.out.flush();
        }
    }

    public void writeUsedMemory(String name) {
        System.gc();
        Runtime runTimeRef = Runtime.getRuntime();
        long usedBytes = runTimeRef.totalMemory() - runTimeRef.freeMemory();
        long usedKB = usedBytes / 1024L;
        long usedMB = usedKB / 1024L;
        String line = usedMB + " MB  (" + usedKB + " KB, " + usedBytes + " bytes)";
        if (name == null) {
            this.writeln(line);
        } else {
            this.writeln(name + " " + line);
        }
    }

    private boolean initFile(String traceFilename) {
        try {
            File currFile = new File(traceFilename);
            this.m_fileWriter = new PrintWriter(new FileWriter(currFile));
            String path = currFile.getParent();
            if (path == null) {
                path = EMPTY_STRING;
            } else if (path.length() > 0) {
                path = path + File.separator;
            }
            this.m_oldFilename = path + OLD_FILE_PREFIX + currFile.getName();
            this.m_currFilename = traceFilename;
            return true;
        }
        catch (Exception ex) {
            System.out.println("*** create file: " + ex.toString());
            this.m_fileWriter = null;
            this.m_display = true;
            return false;
        }
    }

    private void writeFile(boolean withLineFeed, String line) {
        try {
            if (this.m_rowCount >= this.m_maxRows) {
                File oldFile = new File(this.m_oldFilename);
                oldFile.delete();
                this.m_fileWriter.close();
                File currFile = new File(this.m_currFilename);
                currFile.renameTo(oldFile);
                this.m_fileWriter = new PrintWriter(new FileWriter(this.m_currFilename));
                this.m_rowCount = 0;
            }
            if (withLineFeed) {
                ++this.m_rowCount;
                this.m_fileWriter.println(line);
            } else {
                this.m_fileWriter.print(line);
            }
        }
        catch (Exception ex) {
            System.out.println("*** write trace file: " + ex.toString());
            this.m_fileWriter = null;
            this.m_display = true;
        }
    }
}

