/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.dataAccess;

import com.sap.sdb.minDB.common.DatabaseInputStream;
import com.sap.sdb.minDB.common.DatabaseOutputStream;
import com.sap.sdb.minDB.dataAccess.AnyKey;
import com.sap.sdb.minDB.dataAccessInterface.DatabaseKey;
import java.io.IOException;

public class MultiNumKey
extends AnyKey {
    private int m_initializedCols = 0;
    private long[] m_keyCols;

    MultiNumKey() {
        this.m_keyCols = null;
    }

    public MultiNumKey(int maxKeyCol) {
        this.m_keyCols = new long[maxKeyCol + 1];
        this.m_keyCols[0] = 0L;
    }

    public void addCol(int colNo, long keyValue) {
        if (colNo < this.m_keyCols.length) {
            this.m_keyCols[colNo] = keyValue;
        } else {
            super.addCol(colNo, keyValue);
        }
        if (this.m_initializedCols < colNo) {
            this.m_initializedCols = colNo;
        }
    }

    public int compareTo(Object o) {
        MultiNumKey other = (MultiNumKey)o;
        for (int colNo = 1; colNo < this.m_keyCols.length; ++colNo) {
            if (colNo > this.m_initializedCols) {
                return this.m_initializedCols == other.m_initializedCols ? 0 : -1;
            }
            if (colNo > other.m_initializedCols) {
                return 1;
            }
            if (this.m_keyCols[colNo] < other.m_keyCols[colNo]) {
                return -1;
            }
            if (this.m_keyCols[colNo] <= other.m_keyCols[colNo]) continue;
            return 1;
        }
        return 0;
    }

    public boolean isGreaterStopKey(DatabaseKey stopKey) {
        MultiNumKey other = (MultiNumKey)stopKey;
        for (int colNo = 1; colNo < this.m_keyCols.length; ++colNo) {
            if (colNo > this.m_initializedCols || colNo > other.m_initializedCols) {
                return false;
            }
            if (this.m_keyCols[colNo] < other.m_keyCols[colNo]) {
                return false;
            }
            if (this.m_keyCols[colNo] <= other.m_keyCols[colNo]) continue;
            return true;
        }
        return false;
    }

    void readFromStream(DatabaseInputStream inStream) throws IOException {
        this.m_initializedCols = inStream.readInt();
        this.m_keyCols = inStream.readLongArray();
    }

    public String toString() {
        if (this.m_initializedCols == 0) {
            return "<empty>";
        }
        StringBuffer str = new StringBuffer(128);
        for (int colNo = 1; colNo <= this.m_initializedCols; ++colNo) {
            str.append(this.m_keyCols[colNo]);
            if (colNo >= this.m_initializedCols) continue;
            str.append(" ");
        }
        return str.toString();
    }

    void writeToStream(DatabaseOutputStream outStream) throws IOException {
        outStream.writeByte(6);
        outStream.writeInt(this.m_initializedCols);
        outStream.writeLongArray(this.m_keyCols);
    }
}

