/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.common;

import com.sap.sdb.minDB.common.ColumnType;
import com.sap.sdb.minDB.common.ResultSetRowHandling;
import com.sap.sdb.minDB.util.ErrorMsg;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class ResultSetMetaDataImpl
implements ResultSetMetaData {
    private ResultSetRowHandling m_result;

    public String getCatalogName(int column) throws SQLException {
        throw ErrorMsg.notSupported("ResultSetMetaData.getCatalogName");
    }

    public String getColumnClassName(int column) throws SQLException {
        throw ErrorMsg.notSupported("ResultSetMetaData.getColumnClassName");
    }

    public int getColumnCount() throws SQLException {
        return this.m_result.getColumnCount();
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        throw ErrorMsg.notSupported("ResultSetMetaData.getColumnDisplaySize");
    }

    public String getColumnLabel(int column) throws SQLException {
        throw ErrorMsg.notSupported("ResultSetMetaData.getColumnLabel");
    }

    public String getColumnName(int column) throws SQLException {
        return this.getName(this.m_result.getColumnNameList(), column);
    }

    public int getColumnType(int column) throws SQLException {
        return ColumnType.getSQLType(this.getInternalColType(column));
    }

    public String getColumnTypeName(int column) throws SQLException {
        return ColumnType.getTypeName(this.getInternalColType(column));
    }

    public int getPrecision(int column) throws SQLException {
        byte internalColType = this.getInternalColType(column);
        return ColumnType.getPrecision(internalColType);
    }

    public int getScale(int column) throws SQLException {
        return 0;
    }

    public String getSchemaName(int column) throws SQLException {
        return this.getName(this.m_result.getSchemaList(), column);
    }

    public String getTableName(int column) throws SQLException {
        return this.getName(this.m_result.getTabIdentifierList(), column);
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        throw ErrorMsg.notSupported("ResultSetMetaData.isAutoIncrement");
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        throw ErrorMsg.notSupported("ResultSetMetaData.isCaseSensitive");
    }

    public boolean isCurrency(int column) throws SQLException {
        throw ErrorMsg.notSupported("ResultSetMetaData.isCurrency");
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    public int isNullable(int column) throws SQLException {
        throw ErrorMsg.notSupported("ResultSetMetaData.isNullable");
    }

    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    public boolean isSearchable(int column) throws SQLException {
        throw ErrorMsg.notSupported("ResultSetMetaData.isSearchable");
    }

    public boolean isSigned(int column) throws SQLException {
        throw ErrorMsg.notSupported("ResultSetMetaData.isSigned");
    }

    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    ResultSetMetaDataImpl(ResultSetRowHandling result) {
        this.m_result = result;
    }

    private byte getInternalColType(int colNo) {
        byte[] colTypeList = this.m_result.getColumnTypeList();
        return colNo > 0 && colNo < colTypeList.length ? colTypeList[colNo] : (byte)0;
    }

    private String getName(String[] nameList, int colNo) throws SQLException {
        return nameList.length == 1 ? nameList[0] : (colNo > 0 && colNo < nameList.length ? nameList[colNo] : null);
    }
}

