/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.packettest;

import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.sapdb.packettest.PacketTest;
import com.sap.sapdb.packettest.core.PacketTestException;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Random;

public class PacketTestMessageHeader
extends PacketTest {
    private String testcase;
    public static final int testsPerField = 50;
    public static int testoffset = 0;

    public static void prepare() {
        Random ran = new Random();
        testoffset = ran.nextInt(50);
    }

    public void run() {
        this.addMessage("Initialized", 'I', "Test startet with 50 tests per loop and an testoffset of " + testoffset);
        try {
            System.out.println("Start testcase Message Code");
            this.testMessageCode();
            System.out.println("Start testcase Swap Kind");
            this.testSwapKind();
            System.out.println("Start testcase ApllVers");
            this.testApplicationVersion();
            System.out.println("Start testcase ApplID");
            this.testApplicationID();
            System.out.println("Start testcase Varpart Size");
            this.testVarpartSize();
            System.out.println("Start testcase Varpart length");
            this.testVarpartLen();
            System.out.println("Start testcase NO of segements");
            this.testNoOfSegment();
            System.out.println("Start testcase fill 1");
            this.testFillBytes1();
            System.out.println("Start testcase fill2");
            this.testFillBytes2();
            this.testFillBytes3();
        }
        catch (TestDatabaseException ex) {
            ex.printStackTrace();
        }
    }

    public void testMessageCode() throws TestDatabaseException {
        this.testcase = "Message Code";
        int pos = 24;
        boolean len = true;
        long size = (long)Math.pow(256.0, 1.0);
        int[] packets = new int[]{4};
        long i = testoffset;
        while (i < size) {
            this.turn(packets, 24, 1, i);
            i += size / 50L;
        }
        int[] packets1 = new int[]{4, 5, 6};
        long i2 = testoffset;
        while (i2 < size) {
            this.turn(packets1, 24, 1, i2);
            i2 += size / 50L;
        }
    }

    public void testSwapKind() throws TestDatabaseException {
        this.testcase = "Swap Kind";
        int pos = 25;
        boolean len = true;
        long size = (long)Math.pow(256.0, 1.0);
        int[] packets = new int[]{4};
        this.turn(packets, 25, 1, 1L);
        this.turn(packets, 25, 1, 2L);
        this.turn(packets, 25, 1, 0L);
        this.turn(packets, 25, 1, 3L);
        long i = testoffset;
        while (i < size) {
            this.turn(packets, 25, 1, i);
            i += size / 50L;
        }
        int[] packets1 = new int[]{5, 6};
        this.turn(packets, 25, 1, 1L);
        this.turn(packets, 25, 1, 2L);
        this.turn(packets, 25, 1, 0L);
        this.turn(packets, 25, 1, 3L);
        long i2 = testoffset;
        while (i2 < size) {
            this.turn(packets1, 25, 1, i2);
            i2 += size / 50L;
        }
    }

    public void testApplicationVersion() throws TestDatabaseException {
        this.testcase = "Application Version";
        int pos = 28;
        int len = 5;
        long size = (long)Math.pow(256.0, 5.0);
        int[] packets = new int[]{4};
        long i = testoffset;
        while (i < size) {
            this.turn(packets, 28, 5, i);
            i += size / 50L;
        }
        int[] packets1 = new int[]{5, 6};
        char[] c0 = new char[]{'0', '0', '0', '0', '0'};
        char[] c1 = new char[]{'7', '0', '3', '0', '1'};
        char[] c2 = new char[]{'7', '0', '4', '0', '0'};
        char[] c3 = new char[]{'8', '1', '0', '0', '0'};
        this.turn(packets1, 28, 5, this.chartoint(c0));
        this.turn(packets1, 28, 5, this.chartoint(c1));
        this.turn(packets1, 28, 5, this.chartoint(c2));
        this.turn(packets1, 28, 5, this.chartoint(c3));
        long i2 = testoffset;
        while (i2 < size) {
            this.turn(packets1, 28, 5, i2);
            i2 += size / 50L;
        }
    }

    public void testApplicationID() throws TestDatabaseException {
        this.testcase = "Application ID";
        int pos = 33;
        int len = 3;
        long size = (long)Math.pow(256.0, 3.0);
        int[] packets = new int[]{4};
        char[] c0 = new char[]{'O', 'D', 'B'};
        char[] c1 = new char[]{'o', 'd', 'b'};
        char[] c2 = new char[]{'Z', 'Z', 'Z'};
        char[] c3 = new char[]{'J', 'D', 'B'};
        this.turn(packets, 33, 3, this.chartoint(c0));
        this.turn(packets, 33, 3, this.chartoint(c1));
        this.turn(packets, 33, 3, this.chartoint(c2));
        this.turn(packets, 33, 3, this.chartoint(c3));
        long i = testoffset;
        while (i < size) {
            this.turn(packets, 33, 3, i);
            i += size / 50L;
        }
        int[] packets1 = new int[]{5, 6};
        this.turn(packets1, 33, 3, this.chartoint(c0));
        this.turn(packets1, 33, 3, this.chartoint(c1));
        this.turn(packets1, 33, 3, this.chartoint(c2));
        this.turn(packets1, 33, 3, this.chartoint(c3));
        long i2 = testoffset;
        while (i2 < size) {
            this.turn(packets, 33, 3, i2);
            i2 += size / 50L;
        }
    }

    public void testVarpartSize() throws TestDatabaseException {
        this.testcase = "Varpart Size";
        int pos = 36;
        int len = 4;
        long size = (long)Math.pow(256.0, 4.0);
        int[] packets = new int[]{4};
        long i = testoffset;
        while (i < size) {
            this.turn(packets, 36, 4, i);
            i += size / 50L;
        }
        int[] packets1 = new int[]{5, 6};
        long i2 = testoffset;
        while (i2 < size) {
            this.turn(packets1, 36, 4, i2);
            i2 += size / 50L;
        }
    }

    public void testVarpartLen() throws TestDatabaseException {
        this.testcase = "Varpart Length";
        int pos = 40;
        int len = 4;
        long size = (long)Math.pow(256.0, 4.0);
        int[] packets1 = new int[]{5, 6};
        long i = testoffset;
        while (i < size) {
            this.turn(packets1, 40, 4, i);
            i += size / 50L;
        }
    }

    public void testNoOfSegment() throws TestDatabaseException {
        this.testcase = "NO OF SEGMENTS";
        int pos = 46;
        int len = 2;
        long size = (long)Math.pow(256.0, 2.0);
        int[] packets = new int[]{4};
        long i = testoffset;
        while (i < size) {
            this.turn(packets, 46, 2, i);
            i += size / 50L;
        }
        int[] packets1 = new int[]{5, 6};
        long i2 = testoffset;
        while (i2 < size) {
            this.turn(packets1, 46, 2, i2);
            i2 += size / 50L;
        }
    }

    public void testFillBytes1() throws TestDatabaseException {
        this.testcase = "Fill Bytes 1";
        int pos = 26;
        int len = 2;
        long size = (long)Math.pow(256.0, 2.0);
        int[] packets1 = new int[]{5, 6};
        long i = testoffset;
        while (i < size) {
            this.turn(packets1, 26, 2, i);
            i += size / 50L;
        }
    }

    public void testFillBytes2() throws TestDatabaseException {
        this.testcase = "Fill Bytes 2";
        int pos = 44;
        int len = 2;
        long size = (long)Math.pow(256.0, 2.0);
        int[] packets1 = new int[]{5, 6};
        long i = testoffset;
        while (i < size) {
            this.turn(packets1, 44, 2, i);
            i += size / 50L;
        }
    }

    public void testFillBytes3() throws TestDatabaseException {
        this.testcase = "Fill Bytes 3";
        int pos = 48;
        int len = 8;
        long size = (long)Math.pow(256.0, 8.0);
        int[] packets1 = new int[]{5, 6};
        long i = testoffset;
        while (i < size && i > 0L) {
            this.turn(packets1, 48, 8, i);
            i += size / 50L;
        }
    }

    protected void turn(int[] packets, int pos, int len, long value) throws TestDatabaseException {
        int packetnumber = 1;
        StructuredBytes requestPacket = null;
        if (!this.DATABASE.isWarm()) {
            if (PacketTest.DEBUG) {
                System.out.println("Starting Database");
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.DATABASE.start();
        }
        try {
            this.connect();
            requestPacket = this.createInfoRequestPacket();
            if (this.contains(packets, packetnumber)) {
                this.alterPacket(requestPacket, pos, len, value);
            }
            this.out.write(requestPacket.bytes());
            this.printDebug(true, packetnumber, requestPacket);
            StructuredBytes replyPacket = this.receiveConnect();
            this.printDebug(false, packetnumber, replyPacket);
            this.packetLayout = PacketTest.getPacketLayoutFromReply(replyPacket, true);
            if (PacketTest.DEBUG) {
                this.packetLayout.dumpOn(System.out, "");
            }
            requestPacket = this.createReleasePacket();
            if (this.contains(packets, ++packetnumber)) {
                this.alterPacket(requestPacket, pos, len, value);
            }
            this.printDebug(true, packetnumber, requestPacket);
            this.out.write(requestPacket.bytes());
            this.sock.close();
            this.connect();
            requestPacket = this.createDbConnectPacket(this.DBNAME);
            if (this.contains(packets, ++packetnumber)) {
                this.alterPacket(requestPacket, pos, len, value);
            }
            this.printDebug(true, packetnumber, requestPacket);
            this.out.write(requestPacket.bytes());
            replyPacket = this.receiveConnect();
            this.printDebug(false, packetnumber, replyPacket);
            requestPacket = this.createSqlConnectPacket(TestCase.getUser(), TestCase.getPassword());
            if (this.contains(packets, ++packetnumber)) {
                this.alterPacket(requestPacket, pos, len, value);
            }
            this.printDebug(true, packetnumber, requestPacket);
            this.out.write(requestPacket.bytes());
            replyPacket = this.receiveData();
            this.printDebug(false, packetnumber, replyPacket);
            requestPacket = this.createSqlStatementPacket("select * from users");
            if (this.contains(packets, ++packetnumber)) {
                this.alterPacket(requestPacket, pos, len, value);
            }
            this.printDebug(true, packetnumber, requestPacket);
            this.out.write(requestPacket.bytes());
            replyPacket = this.receiveData();
            this.printDebug(false, packetnumber, replyPacket);
            requestPacket = this.createSqlReleasePacket();
            if (this.contains(packets, ++packetnumber)) {
                this.alterPacket(requestPacket, pos, len, value);
            }
            this.printDebug(true, packetnumber, requestPacket);
            this.out.write(requestPacket.bytes());
            replyPacket = this.receiveData();
            this.printDebug(false, packetnumber, replyPacket);
            requestPacket = this.createReleasePacket();
            if (this.contains(packets, ++packetnumber)) {
                this.alterPacket(requestPacket, pos, len, value);
            }
            this.printDebug(true, packetnumber, requestPacket);
            this.out.write(requestPacket.bytes());
            this.sock.close();
        }
        catch (PacketTestException ptex) {
            this.handleError(ptex, packetnumber, pos, len, value, requestPacket);
        }
        catch (RTEException rteex) {
            this.handleError((Exception)((Object)rteex), packetnumber, pos, len, value, requestPacket);
        }
        catch (IOException ioex) {
            this.handleError(ioex, packetnumber, pos, len, value, requestPacket);
        }
        catch (SQLException sqlex) {
            this.handleError(sqlex, packetnumber, pos, len, value, requestPacket);
        }
    }

    public boolean contains(int[] array, int value) {
        if (array == null) {
            return false;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void alterPacket(StructuredBytes packet, int pos, int len, long value) {
        switch (len) {
            case 1: {
                packet.putInt1((int)value, pos);
                break;
            }
            case 2: {
                packet.putInt2((int)value, pos);
                break;
            }
            case 4: {
                packet.putInt4((int)value, pos);
                break;
            }
            case 8: {
                packet.putInt8(value, pos);
                break;
            }
            default: {
                packet.putBytes(this.makeBytes(value, len), pos);
            }
        }
    }

    private void handleError(Exception ex, int packetnumber, int pos, int len, long value, StructuredBytes packet) throws TestDatabaseException {
        boolean dbIsWarm = this.DATABASE.isWarm();
        if (PacketTest.DEBUG) {
            String state = dbIsWarm ? "warm" : "not warm";
            byte[] b = this.makeBytes(value, len);
            String bytes = "";
            int i = 0;
            while (i < b.length) {
                bytes = String.valueOf(bytes) + "[" + b[i] + "]";
                ++i;
            }
            String message = "Exception in test case '" + this.testcase + "', db is " + state + "\n" + ex.getMessage() + "\n" + "Packet " + packetnumber + ":\n" + "Change " + len + " bytes at position " + pos + " to " + bytes + "\n" + new String(packet.bytes());
            System.err.println(message);
        }
        if (!dbIsWarm) {
            byte[] b = this.makeBytes(value, len);
            String bytes = "";
            int i = 0;
            while (i < b.length) {
                bytes = String.valueOf(bytes) + "[" + b[i] + "]";
                ++i;
            }
            String message = "Exception in test case '" + this.testcase + "', database IS DOWN\n" + ex.getMessage() + "\n" + "Packet " + packetnumber + ":\n" + "Change " + len + " bytes at position " + pos + " to " + bytes + "\n" + new String(packet.bytes());
            this.addMessage("DB shot down", 'E', message);
        }
    }

    private byte[] makeBytes(long value, int len) {
        byte[] b = new byte[len];
        int i = 0;
        while (i < len) {
            b[len - i - 1] = (byte)(value % 256L);
            value = (long)Math.floor(value / 256L);
            ++i;
        }
        return b;
    }

    private long chartoint(char[] array) {
        long result = 0L;
        int i = 0;
        while (i < array.length) {
            result = (long)((double)result + (double)array[array.length - i - 1] * Math.pow(256.0, i));
            ++i;
        }
        return result;
    }

    private void printDebug(boolean request, int packetnumber, StructuredBytes packet) {
        if (PacketTest.DEBUG) {
            String kind = request ? "Request" : "Reply";
            System.out.println(String.valueOf(kind) + " " + packetnumber + ": " + new String(packet.bytes()));
        }
    }
}

