/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.programmargs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;

public abstract class ToolParams {
    private String m_propFilename;
    private String m_propDesc;
    protected Properties m_properties = null;
    private String m_folder = null;
    private String m_filesep = null;

    protected ToolParams(String propertiesFilename, String propertiesDescription) {
        String appPath;
        this.m_propFilename = propertiesFilename;
        this.m_propDesc = propertiesDescription;
        this.m_filesep = System.getProperty("file.separator");
        this.m_folder = System.getProperty("user.home");
        String os = System.getProperty("os.name").toLowerCase();
        this.m_folder = os.indexOf("windows") > -1 ? ((appPath = ToolParams.getAppPath()) != null ? appPath + this.m_filesep + "sdb" + this.m_filesep + "syncman" : this.m_folder + this.m_filesep + ".sdb" + this.m_filesep + "syncman") : this.m_folder + this.m_filesep + ".sdb" + this.m_filesep + "syncman";
    }

    protected abstract void setDefaults(Properties var1);

    protected abstract void updatePropertiesFromSettings();

    protected abstract void updateSettingsFromProperties();

    /*
     * Loose catch block
     */
    public void loadParameters() throws IOException, FileNotFoundException {
        block9: {
            Properties defaults = new Properties();
            FileInputStream in = null;
            this.setDefaults(defaults);
            this.m_properties = new Properties(defaults);
            in = new FileInputStream(this.m_folder + this.m_filesep + this.m_propFilename);
            this.m_properties.load(in);
            Object var5_3 = null;
            if (in == null) break block9;
            try {
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            in = null;
            {
                break block9;
                catch (FileNotFoundException ex) {
                    in = null;
                    throw new FileNotFoundException(ex.toString());
                }
                catch (IOException ex) {
                    throw new IOException(ex.toString());
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    in = null;
                }
                throw throwable;
            }
        }
        this.updateSettingsFromProperties();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveParameters(boolean updateProperties) throws IOException {
        if (updateProperties) {
            this.updatePropertiesFromSettings();
        }
        FileOutputStream out = null;
        File file = new File(this.m_folder);
        if (file != null) {
            file.mkdirs();
        }
        out = new FileOutputStream(this.m_folder + this.m_filesep + this.m_propFilename);
        this.m_properties.store(out, this.m_propDesc);
        Object var5_5 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (IOException e) {
            return;
        }
        {
            catch (IOException ex) {
                throw new IOException(ex.toString());
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e) {
                out = null;
            }
            throw throwable;
        }
    }

    private static String getAppPath() {
        String appPath = null;
        try {
            Process p = Runtime.getRuntime().exec("cmd /C set appdata");
            BufferedReader cmdRes = new BufferedReader(new InputStreamReader(p.getInputStream()));
            appPath = cmdRes.readLine();
            cmdRes.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (appPath != null && appPath.toUpperCase().startsWith("APPDATA")) {
            return appPath.substring(8, appPath.length());
        }
        return appPath;
    }
}

