/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.performancetest;

import com.sap.dbtech.jdbc.exceptions.DatabaseException;
import com.sap.dbtech.powertoys.DBM;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.SQLException;

public class GetMaxCacheSize
extends TestCase {
    private static int mLowerLimit;
    private static int mUpperLimit;
    private static int mStartSize;
    private static int mCacheSize;
    private static final int DBERR_DUPLICATE_NAME = -6006;
    private static final String sUser = "GETMAX";
    private static final String sPassword = "GETMAX";
    private static boolean mConsoleMsg;
    private DBM mDBMan = null;
    private static Connection mConnection;
    private static TestStatement mTstmt;
    private static final String sVersion = "1.0";

    static {
        mCacheSize = -1;
        mConnection = null;
        mTstmt = null;
    }

    public static String getTestClassId() {
        return "GetMaxCacheSize";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void prepare() throws TestCaseException {
        Connection lDefConnection = null;
        TestStatement lDefTstmt = null;
        try {
            try {
                block10: {
                    lDefConnection = TestCase.getDatabase().connect(TestCase.getUser(), TestCase.getPassword());
                    lDefTstmt = new TestStatement(null, lDefConnection);
                    lDefTstmt.enableExceptions(false);
                    lDefTstmt.executeUpdate("drop user GETMAX");
                    lDefTstmt.enableExceptions(true);
                    try {
                        lDefTstmt.executeUpdate("Create user GETMAX password GETMAX dba not exclusive");
                    }
                    catch (DatabaseException e) {
                        if (e.getErrorCode() == -6006) break block10;
                        TestCase.addGlobalMessage((String)"Init failure", (char)'E', (String)"Creation of user : GETMAX not possible");
                        throw e;
                    }
                }
                mConnection = TestCase.getDatabase().connect("GETMAX", "GETMAX");
                mTstmt = new TestStatement(null, mConnection);
                mConnection.commit();
                GetMaxCacheSize.readParameters();
                GetMaxCacheSize.printParameters();
            }
            catch (Exception e) {
                TestCase.handleGlobalExceptions((Exception)e);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            try {
                lDefTstmt.close();
                lDefConnection.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var3_6 = null;
        }
        try {}
        catch (Exception e) {
            return;
        }
        lDefTstmt.close();
        lDefConnection.close();
    }

    private static void readParameters() throws TestCaseException {
        mLowerLimit = TestCase.getParameterInt((String)"LowerLimit", (int)10000);
        mUpperLimit = TestCase.getParameterInt((String)"UpperLimit", (int)600000);
        mStartSize = TestCase.getParameterInt((String)"StartSize", (int)200000);
        mConsoleMsg = TestCase.getParameterBoolean((String)"ConsoleMsg", (boolean)true);
    }

    private static void printParameters() throws TestCaseException {
        String parameterString = "";
        GetMaxCacheSize.Trace(mConsoleMsg, 'I', "Starting MultiUserRecovery 1.0");
        mConsoleMsg = TestCase.getParameterBoolean((String)"ConsoleMsg", (boolean)true);
        parameterString = String.valueOf(parameterString) + "\n     Cache Size" + "\n     ----------" + "\n     Lower Limit    = " + mLowerLimit + "\n     Upper Limit    = " + mUpperLimit + "\n\n     Start Size     = " + mStartSize + "\n     Console Output = " + mConsoleMsg;
        GetMaxCacheSize.Trace(mConsoleMsg, 'I', "\nParameter Setting for this test: \n------------------------------------------------------ \n" + parameterString + "\n");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Connection lConnection = null;
        TestStatement lTstmt = null;
        Object lTPstmt = null;
        String CallString = "";
        try {
            try {
                lConnection = TestCase.getDatabase().connect("GETMAX", "GETMAX");
                lTstmt = new TestStatement(null, lConnection);
                GetMaxCacheSize.Trace(mConsoleMsg, 'I', "Put database in OFFLINE mode!");
                this.executeDBMCmd("db_offline");
                mCacheSize = mStartSize;
                while (true) {
                    if (mCacheSize == mLowerLimit) {
                        GetMaxCacheSize.Trace(mConsoleMsg, 'I', "Final CacheSize: " + mCacheSize + "    Range [" + mLowerLimit + "," + mUpperLimit + "\n");
                    }
                    GetMaxCacheSize.Trace(mConsoleMsg, 'I', "Testrange [" + mLowerLimit + ", " + mUpperLimit + "]   CacheSize " + mCacheSize + "\n");
                    if (this.testCacheSize()) {
                        GetMaxCacheSize.Trace(mConsoleMsg, 'I', " Current cache size was OK!");
                        mLowerLimit = mCacheSize;
                        if (mUpperLimit > 0) {
                            mCacheSize = (mLowerLimit + mUpperLimit) / 2;
                            continue;
                        }
                        mCacheSize *= 2;
                        continue;
                    }
                    GetMaxCacheSize.Trace(mConsoleMsg, 'I', " Current cache size was TOO BIG!");
                    mUpperLimit = mCacheSize;
                    if (mLowerLimit > 0) {
                        mCacheSize = (mLowerLimit + mUpperLimit) / 2;
                        continue;
                    }
                    mCacheSize /= 2;
                }
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                lTstmt.close();
                lTPstmt.close();
                lConnection.close();
                GetMaxCacheSize.Trace(true, 'I', "restart DB kernel");
                this.executeDBMCmd("db_restart");
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (Exception e) {
            return;
        }
        lTstmt.close();
        lTPstmt.close();
        lConnection.close();
        GetMaxCacheSize.Trace(true, 'I', "restart DB kernel");
        this.executeDBMCmd("db_restart");
    }

    public static void cleanUp() throws TestCaseException {
    }

    public boolean testCacheSize() {
        boolean result = false;
        try {
            GetMaxCacheSize.Trace(mConsoleMsg, 'I', "Performing param_directput CACHE_SIZE " + mCacheSize);
            this.executeDBMCmd("param_directput CACHE_SIZE " + mCacheSize);
            try {
                GetMaxCacheSize.Trace(mConsoleMsg, 'I', "Performing db_online");
                this.executeDBMCmd("db_online");
                this.executeDBMCmd("db_offline");
            }
            catch (Exception se) {
                return false;
            }
            return true;
        }
        catch (Exception e) {
            GetMaxCacheSize.Trace(mConsoleMsg, 'E', "Error during param_directput CACHE_SIZE: " + e.getMessage());
            return false;
        }
    }

    public static long getTimeout() {
        return 0L;
    }

    public static boolean isSAPOnly() {
        return true;
    }

    public String executeDBMCmd(String pCmd) throws TestDatabaseException {
        String logon = "";
        String mHost = "";
        String mName = "";
        try {
            GetMaxCacheSize.Trace(mConsoleMsg, 'I', "DBMCLI command: \n   " + pCmd);
            mHost = TestCase.getDatabase().getHost();
            mName = TestCase.getDatabase().getName();
            int mPort = TestCase.getDatabase().getPort();
            if (this.mDBMan == null) {
                this.mDBMan = DBM.dbDBM((String)(String.valueOf(mHost) + ":" + mPort), (String)mName);
                logon = "USER_LOGON " + TestCase.getDatabase().getDBMUser() + "," + TestCase.getDatabase().getDBMPassword();
                this.mDBMan.cmd(logon);
            }
            return this.mDBMan.cmd(pCmd);
        }
        catch (Exception e) {
            System.out.println("Could not execute: " + pCmd);
            if (pCmd.equals("db_online") && e.getMessage().equals("cannot determine current db state")) {
                GetMaxCacheSize.Trace(mConsoleMsg, 'I', "Current cache size is TOO BIG!");
                return "ok";
            }
            GetMaxCacheSize.Trace(mConsoleMsg, 'E', "Exception: " + e.getMessage() + "\n" + e.getClass());
            throw new TestDatabaseException(e, " DBM command: " + pCmd + ", logon String: " + logon);
        }
    }

    private static void Trace(boolean consoleMsg, char iwe, String msg) {
        if (consoleMsg) {
            System.out.println(msg);
        }
        if (iwe == 'I') {
            TestCase.addGlobalMessage((String)GetMaxCacheSize.getTestClassId(), (char)'I', (String)msg);
        }
        if (iwe == 'W') {
            TestCase.addGlobalMessage((String)GetMaxCacheSize.getTestClassId(), (char)'W', (String)msg);
        }
        if (iwe == 'E') {
            TestCase.addGlobalMessage((String)GetMaxCacheSize.getTestClassId(), (char)'E', (String)msg);
        }
    }
}

