/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.sqltest.parser;

import com.sap.sapdb.sqltest.parser.ErrorBean;
import com.sap.sapdb.sqltest.parser.StatementBean;
import com.sap.sapdb.sqltest.parser.TestCaseBean;
import com.sap.sapdb.testframe.testcase.VerificationData;
import com.sap.sapdb.testframe.testcase.VerificationDataComplete;
import com.sap.sapdb.testframe.testcase.VerificationDataSorted;
import com.sap.sapdb.testframe.testcase.VerificationDataSubset;
import com.sap.sapdb.testframe.utilities.Conversion;
import com.sap.sapdb.testframe.utilities.UniversalFileAccess;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class TestCasesSaxParser
extends DefaultHandler
implements ErrorHandler {
    private TreeMap res = new TreeMap();
    private XMLReader parser = null;
    private TestCaseBean currentTestCase = null;
    private String currentValue = "";
    private StringBuffer currentValueBuffer = new StringBuffer();
    private ErrorBean currentErrorBean = null;
    private ArrayList errorBns = new ArrayList();
    private ArrayList currentRow = new ArrayList();
    private VerificationData currentVerificationData;
    private String currentColumnDefinition = new String();
    private String columnDfs = new String();
    private StatementBean currentStatement;
    private ArrayList listOfSts;
    private String uri;
    private boolean valueCanBeIgnored = false;
    private boolean valueIsRegex = false;
    private boolean valueIsRange = false;

    public TreeMap parseTestCases(String uri) throws Exception {
        this.uri = uri;
        this.parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        this.parser.setFeature("http://xml.org/sax/features/validation", true);
        this.parser.setContentHandler(this);
        this.parser.setErrorHandler(this);
        String fileName = uri.substring(8);
        System.out.println("File: " + fileName);
        InputSource is = new InputSource(UniversalFileAccess.getInputStream((String)fileName));
        is.setSystemId(uri);
        this.parser.parse(is);
        is.getByteStream().close();
        return this.res;
    }

    public TreeMap parseTestCasesFromString(String str) throws Exception {
        this.parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        this.parser.setContentHandler(this);
        this.parser.setErrorHandler(this);
        StringReader r = new StringReader(str);
        InputSource in = new InputSource();
        in.setCharacterStream(r);
        this.parser.parse(in);
        return this.res;
    }

    public void error(SAXParseException exception) throws SAXParseException {
        System.err.println("ERROR: line " + exception.getLineNumber() + ": " + exception.getMessage());
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXParseException {
        System.err.println("FATAL: line " + exception.getLineNumber() + ": " + exception.getMessage());
        throw exception;
    }

    public void writeXML(PrintStream out, String indent) {
        out.println("<!DOCTYPE Tests SYSTEM \"TestCases.dtd\">");
        out.println("<Tests>");
        Iterator it = this.res.values().iterator();
        while (it.hasNext()) {
            TestCaseBean tcb = (TestCaseBean)it.next();
            tcb.writeXML(out, indent, indent);
        }
        out.println("</Tests>");
    }

    public static void main(String[] argv) {
        if (argv.length != 1) {
            System.out.println("Usage: java TestCasesSaxParser [URI]");
            System.exit(0);
        }
        String uri = argv[0];
        try {
            TestCasesSaxParser inst = new TestCasesSaxParser();
            inst.parseTestCases(uri);
            inst.writeXML(System.out, "\t");
            System.out.println(inst.parseTestCases(uri).values());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentValueBuffer.append(ch, start, length);
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.currentValue = this.currentValueBuffer.toString();
        if (localName.compareTo("Value") == 0) {
            if (this.valueCanBeIgnored) {
                this.valueCanBeIgnored = false;
                this.currentRow.add("IGNORE");
            } else if (this.valueIsRegex) {
                this.currentRow.add("REGEX:" + this.currentValue);
            } else if (this.valueIsRange) {
                this.currentRow.add("'RANGE:" + this.currentValue + "'");
            } else {
                this.currentRow.add(this.currentValue);
            }
            this.valueIsRegex = false;
            this.valueIsRange = false;
        } else if (localName.compareTo("Statement") == 0) {
            this.listOfSts.add(this.currentStatement);
        } else if (localName.compareTo("CallString") == 0) {
            this.currentStatement.setCallString(this.currentValue);
        } else if (localName.compareTo("ColumnDefinition") == 0) {
            this.columnDfs = String.valueOf(this.columnDfs) + this.currentColumnDefinition;
        } else if (localName.compareTo("ColumnName") == 0) {
            this.currentColumnDefinition = String.valueOf(this.currentColumnDefinition) + this.currentValue + ": ";
        } else if (localName.compareTo("ColumnType") == 0) {
            this.currentColumnDefinition = String.valueOf(this.currentColumnDefinition) + this.currentValue + ", ";
        } else if (localName.compareTo("Row") == 0) {
            if (this.columnDfs.compareTo("[") != 0) {
                this.columnDfs = this.columnDfs.substring(0, this.columnDfs.length() - 2);
                this.currentVerificationData.add(String.valueOf(this.columnDfs) + "]");
                this.columnDfs = "[";
            }
            String seq = this.currentRow.toString();
            seq = "(" + seq.substring(1, seq.length() - 1) + ")";
            this.currentVerificationData.add(seq);
        } else if (localName.compareTo("ResultSet") == 0) {
            if (this.columnDfs.compareTo("[") != 0) {
                this.columnDfs = this.columnDfs.substring(0, this.columnDfs.length() - 2);
                this.currentVerificationData.add(String.valueOf(this.columnDfs) + "]");
                this.columnDfs = "[";
            }
            this.currentStatement.setVerificationData(this.currentVerificationData);
        } else if (localName.compareTo("ErrorMessage") == 0) {
            if (this.currentErrorBean.getErrorCode() == -9999) {
                this.currentErrorBean.setMessage("UNKNOWN");
            } else {
                this.currentErrorBean.setMessage(this.currentValue);
            }
        } else if (localName.compareTo("Error") == 0) {
            this.errorBns.add(this.currentErrorBean);
            this.currentStatement.setErrorBeans(this.errorBns);
        } else if (localName.compareTo("ErrorCode") == 0) {
            int i = 0;
            try {
                i = Integer.parseInt(this.currentValue);
            }
            catch (NumberFormatException nfe) {
                i = -9999;
            }
            this.currentErrorBean.setErrorCode(i);
        } else if (localName.compareTo("Comment") == 0) {
            this.currentTestCase.setComment(this.currentValue);
        } else if (localName.compareTo("Test") == 0) {
            Integer number = new Integer(this.currentTestCase.getTestCaseNumber());
            if (this.res.containsKey(number)) {
                throw new SAXException("Duplicate test case number [" + number + "] in the file <" + ((TestCasesSaxParser)this.parser.getContentHandler()).uri + ">");
            }
            this.res.put(number, this.currentTestCase);
        } else if (localName.compareTo("Prepare") == 0) {
            this.currentTestCase.setPrepareStatemets(this.listOfSts);
        } else if (localName.compareTo("Run") == 0) {
            this.currentTestCase.setRunStatements(this.listOfSts);
        } else if (localName.compareTo("CleanUp") == 0) {
            this.currentTestCase.setCleanUpStatements(this.listOfSts);
        }
    }

    public void startDocument() throws SAXException {
        this.res = new TreeMap();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.currentValueBuffer = new StringBuffer();
        if (localName.compareTo("Value") == 0) {
            if (attributes.getIndex("Ignore") != -1 && attributes.getValue("Ignore").compareTo("true") == 0) {
                this.valueCanBeIgnored = true;
            }
            if (attributes.getIndex("range") != -1 && attributes.getValue("range").compareTo("true") == 0) {
                this.valueIsRange = true;
            }
            if (attributes.getIndex("regex") != -1 && attributes.getValue("regex").compareTo("true") == 0) {
                this.valueIsRegex = true;
            }
        } else if (localName.compareTo("Statement") == 0) {
            this.errorBns = new ArrayList();
            this.currentStatement = new StatementBean();
            if (attributes.getValue("ignore").compareTo("true") == 0) {
                this.currentStatement.setIgnoreErrors(true);
            }
            if (attributes.getValue("verify").compareTo("true") == 0) {
                this.currentStatement.setVerify(true);
            }
            if (attributes.getValue("callable").compareTo("true") == 0) {
                this.currentStatement.setCallable(true);
            }
            if (attributes.getValue("repeatable") != null) {
                this.currentStatement.setRepeatable(attributes.getValue("repeatable"));
            }
            if (attributes.getValue("user") != null) {
                this.currentStatement.setUser(attributes.getValue("user"));
            }
        } else if (localName.compareTo("CallString") == 0) {
            if (attributes.getValue("repeatable") != null) {
                this.currentStatement.setRepeatable(attributes.getValue("repeatable"));
            }
            if (attributes.getValue("drop") != null) {
                this.currentStatement.setRepeatable(attributes.getValue("drop"));
            }
        } else if (localName.compareTo("ColumnDefinition") == 0) {
            this.currentColumnDefinition = "";
        } else if (localName.compareTo("Row") == 0) {
            this.currentRow = new ArrayList();
        } else if (localName.compareTo("ResultSet") == 0) {
            this.columnDfs = "[";
            if (attributes.getIndex("Verification") != -1) {
                String attr = attributes.getValue("Verification");
                if (attr.compareTo("Sorted") == 0) {
                    this.currentVerificationData = new VerificationDataSorted();
                    this.currentStatement.setVerifyOperatorType("Sorted");
                } else if (attr.compareTo("Complete") == 0) {
                    this.currentVerificationData = new VerificationDataComplete();
                    this.currentStatement.setVerifyOperatorType("Complete");
                } else if (attr.compareTo("Subset") == 0) {
                    this.currentVerificationData = new VerificationDataSubset();
                    this.currentStatement.setVerifyOperatorType("Subset");
                }
            }
        } else if (localName.compareTo("Prepare") == 0 || localName.compareTo("CleanUp") == 0 || localName.compareTo("Run") == 0) {
            this.listOfSts = new ArrayList();
        } else if (localName.compareTo("Error") == 0) {
            this.currentErrorBean = new ErrorBean();
        } else if (localName.compareTo("Test") == 0) {
            this.currentTestCase = new TestCaseBean();
            if (attributes.getIndex("Number") != -1) {
                try {
                    this.currentTestCase.setTestCaseNumber(Integer.parseInt(attributes.getValue("Number")));
                }
                catch (NumberFormatException nfe) {
                    throw new SAXException("Number of the test case is not an integer value", nfe);
                }
            }
            if (attributes.getIndex("Responsible") != -1) {
                this.currentTestCase.setResponsible(attributes.getValue("Responsible"));
            }
            if (attributes.getIndex("Exclude") != -1) {
                this.currentTestCase.setExcludeProperty(attributes.getValue("Exclude"));
            }
        } else if (localName.compareTo("Parameter") == 0) {
            String paramType = attributes.getValue("ParamType").toUpperCase();
            String dataTypeS = attributes.getValue("DataType").toUpperCase();
            int dataType = Conversion.getSQLTypeFromString((String)dataTypeS);
            String inValue = null;
            String outValue = null;
            if (paramType.equals("IN") || paramType.equals("INOUT")) {
                inValue = attributes.getValue("InValue");
            }
            if (paramType.equals("OUT") || paramType.equals("INOUT")) {
                outValue = attributes.getValue("OutValue");
            }
            if (inValue != null) {
                if (inValue.equals("NULL")) {
                    inValue = null;
                } else if (inValue.length() >= 2 && inValue.startsWith("'") && inValue.endsWith("'")) {
                    inValue = inValue.substring(1, inValue.length() - 1);
                }
            }
            if (outValue != null) {
                if (outValue.equals("NULL")) {
                    outValue = null;
                } else if (outValue.length() >= 2 && outValue.startsWith("'") && outValue.endsWith("'")) {
                    outValue = outValue.substring(1, outValue.length() - 1);
                }
            }
            StatementBean.Param param = new StatementBean.Param(paramType, dataType, inValue, outValue);
            this.currentStatement.addParam(param);
        }
    }
}

