/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.sqltest.parser;

import com.sap.sapdb.sqltest.parser.StatementBean;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;

public class TestCaseBean {
    private String comment = "";
    private int testCaseNumber;
    private String responsible;
    private String excludeProperty = null;
    private ArrayList prepareStatemets = new ArrayList();
    private ArrayList cleanUpStatements = new ArrayList();
    private ArrayList runStatements;

    public String toString() {
        String str = "\nTest case #" + String.valueOf(this.testCaseNumber) + " =>\n";
        str = String.valueOf(str) + "Comments: " + this.comment + "\n";
        str = String.valueOf(str) + "Responsible: " + this.responsible + "\n";
        int currentPosition = 1;
        if (!this.prepareStatemets.isEmpty()) {
            str = String.valueOf(str) + "Prepare statements ( " + currentPosition + ".." + (currentPosition + this.prepareStatemets.size()) + " ):" + this.prepareStatemets + "\n";
            currentPosition += this.prepareStatemets.size();
        }
        if (!this.runStatements.isEmpty()) {
            str = String.valueOf(str) + "Run statements ( " + currentPosition + ".." + (currentPosition + this.runStatements.size()) + " ):" + this.runStatements + "\n";
            currentPosition += this.runStatements.size();
        }
        if (!this.cleanUpStatements.isEmpty()) {
            str = String.valueOf(str) + "Clean up statements( " + currentPosition + ".." + (currentPosition + this.cleanUpStatements.size()) + " ):" + this.cleanUpStatements + "\n";
        }
        return str;
    }

    public String statementsToString() {
        StatementBean sb;
        Iterator it;
        String str = "comment for this testcase #" + String.valueOf(this.testCaseNumber) + ": \n\"" + this.comment + "\"\n------\n";
        str = String.valueOf(str) + "\nTest case #" + String.valueOf(this.testCaseNumber) + " => \n";
        int currentPosition = 1;
        if (!this.prepareStatemets.isEmpty()) {
            it = this.prepareStatemets.iterator();
            str = String.valueOf(str) + "\nPrepare statements ( " + currentPosition + ".." + (currentPosition + this.prepareStatemets.size() - 1) + " ): \n\n";
            while (it.hasNext()) {
                sb = (StatementBean)it.next();
                if (currentPosition < 10) {
                    str = String.valueOf(str) + "   " + currentPosition + ".";
                }
                if (currentPosition > 9 && currentPosition < 100) {
                    str = String.valueOf(str) + "  " + currentPosition + ".";
                }
                if (currentPosition > 99) {
                    str = String.valueOf(str) + " " + currentPosition + ".";
                }
                if (sb.getUser() != null) {
                    str = String.valueOf(str) + " [" + sb.getUser() + "]";
                }
                str = String.valueOf(str) + " " + sb.getCallString() + "\n\n";
                ++currentPosition;
            }
        }
        if (!this.runStatements.isEmpty()) {
            it = this.runStatements.iterator();
            str = String.valueOf(str) + "\nRun statements ( " + currentPosition + ".." + (currentPosition + this.runStatements.size() - 1) + " ): \n\n";
            while (it.hasNext()) {
                sb = (StatementBean)it.next();
                if (currentPosition < 10) {
                    str = String.valueOf(str) + "   " + currentPosition + ".";
                }
                if (currentPosition > 9 && currentPosition < 100) {
                    str = String.valueOf(str) + "  " + currentPosition + ".";
                }
                if (currentPosition > 99) {
                    str = String.valueOf(str) + " " + currentPosition + ".";
                }
                if (sb.getUser() != null) {
                    str = String.valueOf(str) + " [" + sb.getUser() + "]";
                }
                str = String.valueOf(str) + " " + sb.getCallString() + "\n\n";
                ++currentPosition;
            }
        }
        if (!this.cleanUpStatements.isEmpty()) {
            it = this.cleanUpStatements.iterator();
            str = String.valueOf(str) + "\nCleanUp statements ( " + currentPosition + ".." + (currentPosition + this.cleanUpStatements.size() - 1) + " ): \n\n";
            while (it.hasNext()) {
                sb = (StatementBean)it.next();
                if (currentPosition < 10) {
                    str = String.valueOf(str) + "   " + currentPosition + ".";
                }
                if (currentPosition > 9 && currentPosition < 100) {
                    str = String.valueOf(str) + "  " + currentPosition + ".";
                }
                if (currentPosition > 99) {
                    str = String.valueOf(str) + " " + currentPosition + ".";
                }
                if (sb.getUser() != null) {
                    str = String.valueOf(str) + " [" + sb.getUser() + "]";
                }
                str = String.valueOf(str) + " " + sb.getCallString() + "\n\n";
                ++currentPosition;
            }
        }
        return str;
    }

    public void writeXML(PrintStream out, String indent, String startIndent) {
        StatementBean sb;
        Iterator it;
        out.println(String.valueOf(startIndent) + "<Test Number=\"" + String.valueOf(this.testCaseNumber) + "\" Responsible=\"" + this.responsible + "\">");
        out.println(String.valueOf(startIndent) + indent + "<Comment>");
        out.println(String.valueOf(startIndent) + indent + indent + this.comment.trim());
        out.println(String.valueOf(startIndent) + indent + "</Comment>");
        if (!this.prepareStatemets.isEmpty()) {
            out.println(String.valueOf(startIndent) + indent + "<Prepare>");
            it = this.prepareStatemets.iterator();
            while (it.hasNext()) {
                sb = (StatementBean)it.next();
                sb.writeXML(out, indent, String.valueOf(startIndent) + indent + indent);
            }
            out.println(String.valueOf(startIndent) + indent + "</Prepare>");
        }
        out.println(String.valueOf(startIndent) + indent + "<Run>");
        it = this.runStatements.iterator();
        while (it.hasNext()) {
            sb = (StatementBean)it.next();
            sb.writeXML(out, indent, String.valueOf(startIndent) + indent + indent);
        }
        out.println(String.valueOf(startIndent) + indent + "</Run>");
        if (!this.cleanUpStatements.isEmpty()) {
            out.println(String.valueOf(startIndent) + indent + "<CleanUp>");
            it = this.cleanUpStatements.iterator();
            while (it.hasNext()) {
                sb = (StatementBean)it.next();
                sb.writeXML(out, indent, String.valueOf(startIndent) + indent + indent);
            }
            out.println(String.valueOf(startIndent) + indent + "</CleanUp>");
        }
        out.println(String.valueOf(startIndent) + "</Test>");
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String newComment) {
        this.comment = newComment;
    }

    public void setPrepareStatemets(ArrayList prepareStatemets) {
        this.prepareStatemets = prepareStatemets;
    }

    public ArrayList getPrepareStatemets() {
        return this.prepareStatemets;
    }

    public void setCleanUpStatements(ArrayList newCleanUpStatements) {
        this.cleanUpStatements = newCleanUpStatements;
    }

    public ArrayList getCleanUpStatements() {
        return this.cleanUpStatements;
    }

    public void setTestCaseNumber(int testCaseNumber) {
        this.testCaseNumber = testCaseNumber;
    }

    public int getTestCaseNumber() {
        return this.testCaseNumber;
    }

    public void setRunStatements(ArrayList runStatements) {
        this.runStatements = runStatements;
    }

    public ArrayList getRunStatements() {
        return this.runStatements;
    }

    public void setResponsible(String responsible) {
        this.responsible = responsible;
    }

    public String getResponsible() {
        return this.responsible;
    }

    public void setExcludeProperty(String exclude) {
        this.excludeProperty = exclude;
    }

    public String getExcludeProperty() {
        return this.excludeProperty;
    }
}

