/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.sqlmanager;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.ColumnDescriptor;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.utilities.RandomGenerator;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;

public class SharedSQL_Test
extends TestCase {
    private static boolean mTestEndsWithoutError = true;
    static long mDDLCount = 0L;
    static final String lastUpdate = "2004/08/06 13:10";

    private static boolean testEndsWithoutAnError() {
        return mTestEndsWithoutError;
    }

    public static long getTimeout() {
        return 0x6DDD00L;
    }

    public static void cleanUp() throws TestCaseException {
        if (!SharedSQL_Test.testEndsWithoutAnError()) {
            return;
        }
        Connection mConnection = null;
        TestStatement mStmt = null;
        try {
            mConnection = TestCase.getDatabase().connect(TestCase.getUser(), TestCase.getPassword());
            mStmt = new TestStatement(null, mConnection);
            mStmt.executeUpdateIgnoreErrors("DROP TABLE TAB1");
            mStmt.executeUpdateIgnoreErrors("DROP TABLE TAB2");
            mConnection.commit();
        }
        catch (Exception e) {
            TestCase.addGlobalMessage((String)"Method cleanUp", (char)'E', (String)"cleanup failed");
            throw new TestCaseException("Error during cleanup: " + e.getClass() + e.getMessage());
        }
        System.out.println("End of " + SharedSQL_Test.getTestClassId());
    }

    public static String getTestClassId() {
        return "SharedSQL Test";
    }

    public static boolean isReferenceEnabled() {
        return true;
    }

    private void handleException(Exception e) {
        this.handleExceptions(e);
    }

    public static void prepare(String SQLMode) throws TestCaseException {
        Connection mConnection = null;
        TestStatement mStmt = null;
        try {
            Properties conProps = new Properties();
            conProps.put("user", TestCase.getUser());
            conProps.put("password", TestCase.getPassword());
            conProps.put("sqlmode", SQLMode);
            mConnection = TestCase.getDatabase().connect(conProps);
            mConnection.setAutoCommit(true);
            mStmt = new TestStatement(null, mConnection);
            mStmt.executeUpdate("DIAGNOSE SHARE PARSE DROP");
            mStmt.executeUpdateIgnoreErrors("DROP TABLE TABX");
            mStmt.executeUpdateIgnoreErrors("DROP TABLE TAB1");
            mStmt.executeUpdate("CREATE TABLE TAB1 (T INTEGER, K INTEGER, DATA VARCHAR(50), PRIMARY KEY (T,K))");
            mStmt.executeUpdateIgnoreErrors("DROP TABLE TAB2");
            mStmt.executeUpdate("CREATE TABLE TAB2 (T INTEGER, K INTEGER, DATA VARCHAR(50), PRIMARY KEY (T,K))");
            mConnection.close();
            mConnection = null;
        }
        catch (Exception e) {
            TestCase.addGlobalMessage((String)"Method prepare", (char)'E', (String)("preparation failed " + mStmt.getSqlString() + " " + ((SQLException)e).getErrorCode() + ((SQLException)e).getLocalizedMessage()));
            throw new TestCaseException("Error during preparation: " + e.getClass() + e.getMessage());
        }
    }

    public void basicFunctionality(String SQLMode, boolean SharedSQL) throws TestCaseException {
        Connection mConnection = null;
        Connection mConnectionA = null;
        Connection mConnectionB = null;
        TestStatement mStmt = null;
        TestPreparedStatement mStmtA = null;
        TestPreparedStatement mStmtB = null;
        TestPreparedStatement mStmtX = null;
        Object mStatistics = null;
        Object rs = null;
        try {
            Properties conProps = new Properties();
            conProps.put("user", TestCase.getUser());
            conProps.put("password", TestCase.getPassword());
            conProps.put("sqlmode", SQLMode);
            mConnection = TestCase.getDatabase().connect(conProps);
            mStmt = new TestStatement(null, mConnection);
            if (SharedSQL) {
                if (TestDriver.compareRelease((String)((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion(), (String)">=", (String)"7.6.0")) {
                    ((TestDatabaseSap)TestCase.getDatabase()).executeDBMcmd("util_execute SET PARAMETER SHAREDSQL='YES'");
                } else {
                    mStmt.executeUpdate("DIAGNOSE SHARE PARSE ON");
                }
            } else if (TestDriver.compareRelease((String)((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion(), (String)">=", (String)"7.6.0")) {
                ((TestDatabaseSap)TestCase.getDatabase()).executeDBMcmd("util_execute SET PARAMETER SHAREDSQL='NO'");
            } else {
                mStmt.executeUpdate("DIAGNOSE SHARE PARSE OFF");
            }
            mConnection.commit();
            mConnection.close();
            mConnectionA = TestCase.getDatabase().connect(conProps);
            mConnectionB = TestCase.getDatabase().connect(conProps);
            SQLBasicAlter mBasicAlter = new SQLBasicAlter(SQLMode);
            SQLBasicSelect mBasicSelect = new SQLBasicSelect(SQLMode);
            Thread.sleep(30000L);
            if (mTestEndsWithoutError) {
                mConnectionA.setAutoCommit(true);
                mConnectionB.setAutoCommit(true);
                mStmtA = new TestPreparedStatement((TestCase)this, mConnectionA, "INSERT INTO TAB1 VALUES (0, 001, 'Herbie Hancock (p)')");
                mStmtA.executeUpdate();
                mStmtB = new TestPreparedStatement((TestCase)this, mConnectionB, "INSERT INTO TAB1 VALUES (0, 002, 'Miles Davis (tp)')");
                mStmtB.executeUpdate();
                mStmtA = new TestPreparedStatement((TestCase)this, mConnectionA, "INSERT INTO TAB1 VALUES (0, 003, 'John Coltrane (ts)')");
                mStmtA.executeUpdate();
                mStmtA = new TestPreparedStatement(null, mConnectionA, "SELECT * FROM TAB1 WHERE K = 001");
                mStmtA.executeQuery();
                mStmtB = new TestPreparedStatement(null, mConnectionB, "SELECT * FROM TAB1 WHERE K = 001");
                mStmtB.executeQuery();
                mStmtA = new TestPreparedStatement(null, mConnectionA, "SELECT * FROM TAB1 WHERE K = 002");
                mStmtA.executeQuery();
                mStmtX = new TestPreparedStatement(null, mConnectionA, "ALTER TABLE TAB1 ADD DATAX CHAR(10)");
                mStmtX.executeUpdate();
                mStmtB = new TestPreparedStatement(null, mConnectionB, "SELECT * FROM TAB1 WHERE K = 002");
                mStmtB.executeQuery();
                mStmtA = new TestPreparedStatement(null, mConnectionA, "SELECT * FROM TAB1 WHERE K = 002");
                mStmtB = new TestPreparedStatement(null, mConnectionB, "SELECT * FROM TAB1 WHERE K = 002");
                mStmtX = new TestPreparedStatement(null, mConnectionA, "ALTER TABLE TAB1 DROP COLUMN DATAX");
                mStmtX.executeUpdate();
                mStmtA.executeQuery();
                mStmtB.executeQuery();
                mConnectionA.close();
                mConnectionA = null;
                mConnectionB.close();
                mConnectionB = null;
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            TestCase.addGlobalMessage((String)SharedSQL_Test.getTestClassId(), (char)'T', (String)("Trace: \n" + sw.toString()));
            throw new TestCaseException("Error testing basic functionality: " + e.getClass() + e.getMessage());
        }
    }

    public void lockingFunctionality(String SQLMode, boolean SharedSQL, int ThreadCount, boolean DDLThread, boolean AutoCom, int wDMLCom, int wDMLRoll, int TimePerThread, int RndInteger, int RndString, int dtDDL, int AddTime) throws TestCaseException {
        Connection mConnection = null;
        TestStatement mStmt = null;
        try {
            boolean areAlive;
            int j;
            Properties conProps = new Properties();
            conProps.put("user", TestCase.getUser());
            conProps.put("password", TestCase.getPassword());
            conProps.put("sqlmode", SQLMode);
            mConnection = TestCase.getDatabase().connect(conProps);
            mConnection.setAutoCommit(true);
            mStmt = new TestStatement(null, mConnection);
            if (SharedSQL) {
                if (TestDriver.compareRelease((String)((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion(), (String)">=", (String)"7.6.0")) {
                    ((TestDatabaseSap)TestCase.getDatabase()).executeDBMcmd("util_execute SET PARAMETER SHAREDSQL='YES'");
                } else {
                    mStmt.executeUpdate("DIAGNOSE SHARE PARSE ON");
                }
            } else if (TestDriver.compareRelease((String)((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion(), (String)">=", (String)"7.6.0")) {
                ((TestDatabaseSap)TestCase.getDatabase()).executeDBMcmd("util_execute SET PARAMETER SHAREDSQL='NO'");
            } else {
                mStmt.executeUpdate("DIAGNOSE SHARE PARSE OFF");
            }
            mConnection.close();
            long SleepTime = 60000L * (long)TimePerThread;
            SQLActor[] ActorSet = new SQLActor[ThreadCount + 1];
            this.addMessage("", 'I', "Start SQLActor" + Integer.toString(1));
            ActorSet[1] = new SQLActor(SQLMode, 1, false, AutoCom, wDMLCom, wDMLRoll, RndInteger, RndString, dtDDL);
            int i = 2;
            while (i <= ThreadCount - 1) {
                this.addMessage("", 'I', "Start SQLActor" + Integer.toString(i));
                ActorSet[i] = new SQLActor(SQLMode, i, false, AutoCom, wDMLCom, wDMLRoll, RndInteger, RndString, dtDDL);
                Thread.sleep(SleepTime);
                ++i;
            }
            ActorSet[ThreadCount] = DDLThread ? new SQLActor(SQLMode, ThreadCount, true, AutoCom, 1, 0, RndInteger, RndString, dtDDL) : new SQLActor(SQLMode, ThreadCount, false, AutoCom, wDMLCom, wDMLRoll, RndInteger, RndString, dtDDL);
            Thread.sleep(SleepTime);
            SleepTime = 60000L * (long)AddTime;
            boolean oneActorHasAnError = false;
            boolean endTimeReached = false;
            long testActorsShouldStopAt = System.currentTimeMillis() + SleepTime;
            do {
                Thread.sleep(100L);
                if (testActorsShouldStopAt < System.currentTimeMillis()) {
                    endTimeReached = true;
                }
                j = 1;
                while (j <= ThreadCount) {
                    if (ActorSet[j].hasAnError) {
                        oneActorHasAnError = true;
                    }
                    ++j;
                }
            } while (!oneActorHasAnError && !endTimeReached);
            this.addMessage("", 'I', "Stop all threads");
            j = 1;
            while (j <= ThreadCount) {
                ActorSet[j].pleaseStop();
                ++j;
            }
            int k = 0;
            do {
                ++k;
                areAlive = false;
                int j2 = 1;
                while (j2 <= ThreadCount) {
                    areAlive |= ActorSet[j2].isAlive();
                    Thread.sleep(200L);
                    ++j2;
                }
            } while (areAlive && k < 100);
            if (areAlive) {
                StringBuffer listAllAliveThreads = new StringBuffer();
                listAllAliveThreads.append("The following threads are not stopped:\n");
                int j3 = 1;
                while (j3 <= ThreadCount) {
                    if (ActorSet[j3].isAlive()) {
                        listAllAliveThreads.append(" " + ActorSet[j3].name + " -> last sql stmt: '" + ActorSet[j3].sqlstmt + "'; stmtCounter: " + ActorSet[j3].StmtCount + "\n");
                    }
                    ++j3;
                }
                this.addMessage("Not all threads stopped", 'I', listAllAliveThreads.toString());
                this.addMessage("Not all threads stopped", 'I', "show tasks ->\n" + TestCase.getDatabase().executeDBMcmd("show tasks"));
                this.addMessage("Not all threads stopped", 'I', "show regions ->\n" + TestCase.getDatabase().executeDBMcmd("show regions"));
                this.addMessage("Not all threads stopped", 'I', "show all ->\n" + TestCase.getDatabase().executeDBMcmd("show all"));
                this.extractStatistics("Select * from LOCKSTATISTICS");
                this.extractStatistics("Select * from domain.sysmon_region");
                TestCase.getDatabase().executeDBMcmd("db_stop -dump");
                throw new TestCaseException("Not all threads stopped");
            }
            this.addMessage("", 'I', "All threads stopped...");
            if (oneActorHasAnError) {
                throw new Exception("At least one actor had an error.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TestCaseException("Error testing locking functionality: " + e.getClass() + " " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        String SQLMode = null;
        try {
            try {
                System.out.println(String.valueOf(SharedSQL_Test.getTestClassId()) + "; last update: " + lastUpdate);
                SQLMode = TestCase.getParameterString((String)"SQLMode", (String)"internal");
                if (!SQLMode.equalsIgnoreCase("oracle")) {
                    SQLMode = "internal";
                }
                this.addMessage("", 'I', "SQLMode is " + SQLMode);
                this.addMessage("", 'I', "##### Testing basic functionality");
                SharedSQL_Test.prepare(SQLMode);
                this.basicFunctionality(SQLMode, true);
                this.addMessage("", 'I', "##### Stress testing ");
                int TestCount = TestCase.getParameterInt((String)"TestCount", (int)1);
                int i = 1;
                while (i <= TestCount) {
                    boolean SharedSQL = TestCase.getParameterBoolean((String)("SharedSQL_" + i), (boolean)true);
                    int ThreadCount = TestCase.getParameterInt((String)("ThreadCount_" + i), (int)21);
                    boolean DDLThread = TestCase.getParameterBoolean((String)("DDLThread_" + i), (boolean)true);
                    int dtDDL = TestCase.getParameterInt((String)("DDLTimeDiff_" + i), (int)20);
                    boolean AutoCom = TestCase.getParameterBoolean((String)("AutoCommit_" + i), (boolean)false);
                    int wDMLCom = TestCase.getParameterInt((String)"wDMLCom_1", (int)20);
                    int wDMLRoll = TestCase.getParameterInt((String)("wDMLRoll_" + i), (int)2);
                    int TimePerThread = TestCase.getParameterInt((String)("TimePerThread_" + i), (int)1);
                    int RndInteger = TestCase.getParameterInt((String)("RndInteger_" + i), (int)1000);
                    int RndString = TestCase.getParameterInt((String)("RndString_" + i), (int)3);
                    int AddTime = TestCase.getParameterInt((String)("AddTime_" + i), (int)10);
                    System.out.println("Run now " + i + " of " + TestCount);
                    this.addMessage("", 'I', "### RUN " + i + "// SharedSQL: " + SharedSQL + "/ Threads: " + ThreadCount + "/ DDLThread: " + DDLThread + "/ DDLTimeDiff: " + dtDDL + "/ AutoCommit: " + AutoCom + "/ wDMLCom: " + wDMLCom + "/ wDMLRoll: " + wDMLRoll + "/ TimePerThread: " + TimePerThread + "/ RndInteger: " + RndInteger + "/ RndString: " + RndString + "/ AddTime: " + AddTime);
                    SharedSQL_Test.prepare(SQLMode);
                    this.lockingFunctionality(SQLMode, SharedSQL, ThreadCount, DDLThread, AutoCom, wDMLCom, wDMLRoll, TimePerThread, RndInteger, RndString, dtDDL, AddTime);
                    this.extractStatistics("Select * from COMMANDCACHESTATISTICS");
                    ++i;
                }
            }
            catch (Exception e) {
                mTestEndsWithoutError = false;
                if (e.getLocalizedMessage().indexOf("least one actor had an") != -1) {
                    this.addMessage("run exception", 'I', e.getClass() + "\n" + e.getLocalizedMessage());
                } else {
                    this.addMessage("run exception", 'E', e.getClass() + "\n" + e.getLocalizedMessage());
                }
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            this.extractStatistics("Select * from COMMANDCACHESTATISTICS");
            throw throwable;
        }
        {
            Object var16_18 = null;
            this.extractStatistics("Select * from COMMANDCACHESTATISTICS");
            return;
        }
    }

    private void extractStatistics(String sqlstmt) {
        this.extractStatistics(null, sqlstmt);
    }

    private void extractStatistics(Connection pConn, String sqlstmt) {
        ResultSet rs = null;
        boolean rsRow = false;
        String call_stmt = "";
        try {
            Connection mGetStatConnection = null;
            mGetStatConnection = pConn != null ? pConn : TestCase.getDatabase().connect(TestCase.getUser(), TestCase.getPassword());
            TestStatement statstmt = new TestStatement((TestCase)this, mGetStatConnection);
            call_stmt = sqlstmt;
            rs = statstmt.executeQuery(call_stmt);
            StringBuffer stBu = new StringBuffer();
            if (rs.next()) {
                int i = 1;
                while (i <= rs.getMetaData().getColumnCount()) {
                    if (rs.getMetaData().getColumnType(i) == -2) {
                        stBu.append(this.paddTo(rs.getMetaData().getColumnName(i), 66));
                    } else {
                        stBu.append(this.paddTo(rs.getMetaData().getColumnName(i), 15));
                    }
                    stBu.append(" ");
                    ++i;
                }
                stBu.append("\n");
                do {
                    i = 1;
                    while (i <= rs.getMetaData().getColumnCount()) {
                        if (rs.getMetaData().getColumnType(i) == -2) {
                            stBu.append(this.paddTo(ColumnDescriptor.hex2String((byte[])rs.getBytes(i)), 66));
                        } else if (rs.getObject(i) != null && rs.getObject(i).toString() != null) {
                            stBu.append(this.paddTo(rs.getObject(i).toString(), 15));
                        } else {
                            stBu.append(this.paddTo("NULL", 15));
                        }
                        stBu.append(" ");
                        ++i;
                    }
                    stBu.append("\n");
                } while (rs.next());
                mGetStatConnection.commit();
                statstmt.close();
                if (pConn == null) {
                    mGetStatConnection.close();
                }
                this.addMessage(SharedSQL_Test.getTestClassId(), 'I', "Value(s) of " + call_stmt + "\n" + stBu.toString());
            } else {
                this.addMessage(SharedSQL_Test.getTestClassId(), 'I', "no result for '" + call_stmt + "'");
            }
        }
        catch (SQLException sqle) {
            System.out.println("ERROR: Can't excute: " + call_stmt + "; get: " + sqle.getClass() + "  " + sqle.getErrorCode() + "  " + sqle.getMessage());
            this.addMessage(SharedSQL_Test.getTestClassId(), 'W', "Can't excute: " + call_stmt + "; get: " + sqle.getClass() + "  " + sqle.getErrorCode() + "  " + sqle.getMessage());
        }
        catch (TestDatabaseException tdbe) {
            this.addMessage(SharedSQL_Test.getTestClassId(), 'W', "Can't connect to Database. " + tdbe.getLocalizedMessage());
        }
    }

    private String paddTo(String str, int len) {
        int l = str.length();
        if (l < len) {
            char[] ca = new char[len - l];
            Arrays.fill(ca, ' ');
            return String.valueOf(str) + new String(ca);
        }
        if (l == len) {
            return str;
        }
        return str.substring(0, len);
    }

    static /* synthetic */ void access$2(String string, char c, String string2) {
        TestCase.addGlobalMessage((String)string, (char)c, (String)string2);
    }

    class SQLBasicAlter
    extends Thread {
        Connection mConnectionA = null;
        TestPreparedStatement mStmtA = null;

        SQLBasicAlter(String SQLMode) {
            Properties conProps = new Properties();
            try {
                conProps.put("user", TestCase.getUser());
                conProps.put("password", TestCase.getPassword());
                conProps.put("sqlmode", SQLMode);
                this.mConnectionA = TestCase.getDatabase().connect(conProps);
                this.mConnectionA.setAutoCommit(false);
                this.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void run() {
            ResultSet rs = null;
            try {
                this.mStmtA = new TestPreparedStatement(null, this.mConnectionA, "CREATE TABLE TABX (I INT)");
                this.mStmtA.executeUpdate();
                this.mConnectionA.commit();
                Thread.sleep(5000L);
                this.mStmtA = new TestPreparedStatement(null, this.mConnectionA, "ALTER TABLE TABX ADD (K INT)");
                this.mStmtA.executeUpdate();
                Thread.sleep(5000L);
                this.mConnectionA.commit();
                this.mStmtA = new TestPreparedStatement(null, this.mConnectionA, "SELECT * FROM LOCKSTATISTICS");
                rs = this.mStmtA.executeQuery();
                this.mConnectionA.commit();
                if (rs.next()) {
                    SharedSQL_Test.this.extractStatistics("SELECT * FROM LOCKSTATISTICS");
                    mTestEndsWithoutError = false;
                    throw new TestCaseException("There are existing locks");
                }
                this.mConnectionA.commit();
            }
            catch (Exception ex) {
                SharedSQL_Test.this.addMessage("", 'E', ex.getLocalizedMessage());
                mTestEndsWithoutError = false;
            }
        }
    }

    class SQLBasicSelect
    extends Thread {
        Connection mConnectionB = null;
        TestPreparedStatement mStmtB = null;

        SQLBasicSelect(String SQLMode) {
            Properties conProps = new Properties();
            try {
                conProps.put("user", TestCase.getUser());
                conProps.put("password", TestCase.getPassword());
                conProps.put("sqlmode", SQLMode);
                this.mConnectionB = TestCase.getDatabase().connect(conProps);
                this.mConnectionB.setAutoCommit(false);
                this.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void run() {
            try {
                Thread.sleep(2000L);
                this.mStmtB = new TestPreparedStatement(null, this.mConnectionB, "INSERT INTO TABX VALUES (1)");
                this.mStmtB.executeUpdate();
                this.mConnectionB.commit();
                Thread.sleep(5000L);
                this.mStmtB = new TestPreparedStatement(null, this.mConnectionB, "SELECT * FROM TABX");
                this.mStmtB.executeQuery();
                Thread.sleep(7000L);
                this.mConnectionB.commit();
            }
            catch (Exception ex) {
                SharedSQL_Test.this.addMessage("", 'E', ex.getLocalizedMessage());
                mTestEndsWithoutError = false;
            }
        }
    }

    class SQLActor
    extends Thread {
        boolean keepRuning;
        boolean hasAnError = false;
        String name;
        String SQLMode;
        int threadNr;
        long StmtCount;
        boolean doDDL;
        boolean autoCom;
        int wCom;
        int wRoll;
        int DDLTimeDiff;
        int CounterToRollOrCom;
        boolean drop;
        int randomInt;
        int randomStr;
        String sqlstmt = null;

        SQLActor(String Mode, int i, boolean DDL, boolean auto, int wC, int wR, int rInt, int rStr, int dtDDL) {
            this.SQLMode = Mode;
            this.keepRuning = true;
            this.threadNr = i;
            this.name = "SQLActor" + i;
            if (i < 10) {
                this.name = String.valueOf(this.name) + " ";
            }
            this.StmtCount = 0L;
            this.doDDL = DDL;
            this.autoCom = auto;
            this.wCom = wC;
            this.wRoll = wR;
            this.CounterToRollOrCom = RandomGenerator.randomInteger((int)1, (int)wC);
            this.randomInt = rInt;
            this.randomStr = rStr;
            this.drop = false;
            this.DDLTimeDiff = dtDDL;
            this.start();
        }

        public void run() {
            Connection con = null;
            try {
                Properties conProps = new Properties();
                conProps.put("user", TestCase.getUser());
                conProps.put("password", TestCase.getPassword());
                conProps.put("sqlmode", this.SQLMode);
                con = TestCase.getDatabase().connect(conProps);
                if (!this.doDDL) {
                    con.setAutoCommit(this.autoCom);
                } else {
                    con.setAutoCommit(true);
                }
                TestStatement whichTask = new TestStatement(null, con);
                ResultSet whichTaskRS = whichTask.executeQuery("select t.process, t.session from connectparameters c , transactions t where t.session = c.session");
                if (whichTaskRS.next()) {
                    this.name = String.valueOf(this.name) + " (Task: " + whichTaskRS.getString("PROCESS") + ", Session: " + whichTaskRS.getString("SESSION") + ")";
                } else {
                    SharedSQL_Test.access$2("Thread " + this.name, 'I', " Task and session id not readable.");
                }
                whichTaskRS.close();
                whichTask.close();
                con.commit();
                while (this.keepRuning) {
                    if (!this.doDDL) {
                        this.executeDML(con);
                        Thread.sleep(50L);
                        continue;
                    }
                    this.executeDDL(con);
                    Thread.sleep(1000L * (long)this.DDLTimeDiff);
                }
                con.commit();
                con.close();
                con = null;
                if (!this.doDDL) {
                    SharedSQL_Test.access$2("Thread " + this.name, 'I', " executed " + this.StmtCount + " SELECT/INSERT/UPDATE/DELETE Statements");
                } else {
                    SharedSQL_Test.access$2("Thread " + this.name, 'I', " executed " + this.StmtCount + " ALTER TABLE Statements");
                }
            }
            catch (Exception e) {
                SharedSQL_Test.this.handleException(e);
                this.hasAnError = true;
            }
        }

        public void pleaseStop() {
            this.keepRuning = false;
        }

        private void CommitOrRollback(Connection pConnection) throws TestCaseException {
            try {
                --this.CounterToRollOrCom;
                if (this.CounterToRollOrCom <= 0) {
                    int random = RandomGenerator.randomInteger((int)1, (int)100);
                    if (random <= this.wRoll) {
                        pConnection.rollback();
                    } else {
                        pConnection.commit();
                    }
                    this.CounterToRollOrCom = RandomGenerator.randomInteger((int)1, (int)this.wCom);
                }
            }
            catch (Exception e) {
                throw new TestCaseException("Error within Commit or Rollback: " + e.getClass() + " " + e.getMessage());
            }
        }

        private void executeDML(Connection pConnection) throws TestCaseException {
            block25: {
                TestPreparedStatement stmt = null;
                this.sqlstmt = "???";
                try {
                    int random = RandomGenerator.randomInteger((int)1, (int)13);
                    int n_exec = 1;
                    int Params = 1;
                    long DDLCount = 0L;
                    switch (random) {
                        case 1: {
                            int key = RandomGenerator.randomInteger((int)1, (int)this.randomInt);
                            this.sqlstmt = "SELECT * FROM TAB1 WHERE T = ? AND K = " + key;
                            n_exec = RandomGenerator.randomInteger((int)1, (int)10);
                            break;
                        }
                        case 2: {
                            int key = RandomGenerator.randomInteger((int)1, (int)this.randomInt);
                            this.sqlstmt = "SELECT * FROM TAB2 WHERE T = ? AND K = " + key;
                            n_exec = RandomGenerator.randomInteger((int)1, (int)10);
                            break;
                        }
                        case 3: {
                            String data = RandomGenerator.randomString((int)1);
                            data = String.valueOf(data) + '%';
                            this.sqlstmt = "SELECT * FROM TAB1 WHERE T = ? AND DATA LIKE '" + data + "'";
                            n_exec = RandomGenerator.randomInteger((int)1, (int)10);
                            break;
                        }
                        case 4: {
                            String data = RandomGenerator.randomString((int)1);
                            data = String.valueOf(data) + '%';
                            this.sqlstmt = "SELECT * FROM TAB2 WHERE T = ? AND DATA LIKE '" + data + "'";
                            n_exec = RandomGenerator.randomInteger((int)1, (int)10);
                            break;
                        }
                        case 5: {
                            int key = RandomGenerator.randomInteger((int)1, (int)this.randomInt);
                            String data = RandomGenerator.randomString((int)this.randomStr);
                            this.sqlstmt = "INSERT INTO TAB1 (T, K, DATA) VALUES (?, " + key + ", '" + data + "')";
                            break;
                        }
                        case 6: {
                            int key = RandomGenerator.randomInteger((int)1, (int)this.randomInt);
                            String data = RandomGenerator.randomString((int)this.randomStr);
                            this.sqlstmt = "INSERT INTO TAB2 (T, K, DATA) VALUES (?, " + key + ", '" + data + "')";
                            break;
                        }
                        case 7: {
                            int key = RandomGenerator.randomInteger((int)1, (int)this.randomInt);
                            String data = RandomGenerator.randomString((int)this.randomStr);
                            this.sqlstmt = "UPDATE TAB1 SET DATA = '" + data + "' WHERE T = ? AND K = " + key;
                            break;
                        }
                        case 8: {
                            int key = RandomGenerator.randomInteger((int)1, (int)this.randomInt);
                            String data = RandomGenerator.randomString((int)this.randomStr);
                            this.sqlstmt = "UPDATE TAB2 SET DATA = '" + data + "' WHERE T = ? AND K = " + key;
                            break;
                        }
                        case 9: {
                            int key = RandomGenerator.randomInteger((int)1, (int)this.randomInt);
                            this.sqlstmt = "DELETE FROM TAB1 WHERE T = ? AND K = " + key;
                            break;
                        }
                        case 10: {
                            int key = RandomGenerator.randomInteger((int)1, (int)this.randomInt);
                            this.sqlstmt = "DELETE FROM TAB2 WHERE T = ? AND K = " + key;
                            break;
                        }
                        case 11: {
                            int key = RandomGenerator.randomInteger((int)1, (int)this.randomInt);
                            this.sqlstmt = "SELECT * FROM TAB1 A, TAB2 B WHERE A.T = B.T AND A.K = B.K AND A.T = ? AND A.K < " + key + " ORDER BY B.K";
                            n_exec = RandomGenerator.randomInteger((int)1, (int)10);
                            break;
                        }
                        case 12: {
                            int key = RandomGenerator.randomInteger((int)1, (int)this.randomInt);
                            this.sqlstmt = "SELECT * FROM TAB1 WHERE T = ? AND K = ( SELECT MAX(K) FROM TAB2 WHERE T = ? AND K < " + key + " )";
                            Params = 2;
                            n_exec = RandomGenerator.randomInteger((int)1, (int)10);
                            break;
                        }
                        case 13: {
                            this.sqlstmt = this.SQLMode.equalsIgnoreCase("oracle") ? "SELECT K,DATA FROM TAB1 WHERE T = ? MINUS SELECT K,DATA FROM TAB2 WHERE T = ?" : "SELECT K,DATA FROM TAB1 WHERE T = ? EXCEPT SELECT K,DATA FROM TAB2 WHERE T = ?";
                            Params = 2;
                            n_exec = RandomGenerator.randomInteger((int)1, (int)10);
                        }
                    }
                    stmt = new TestPreparedStatement(null, pConnection, this.sqlstmt);
                    int i = 1;
                    while (i <= Params) {
                        stmt.setInt(i, this.threadNr);
                        ++i;
                    }
                    DDLCount = mDDLCount;
                    i = 1;
                    while (i <= n_exec && DDLCount == mDDLCount) {
                        if (this.threadNr == 0) {
                            Thread.sleep(1000L * (long)this.DDLTimeDiff);
                        }
                        stmt.execute();
                        ++this.StmtCount;
                        ++i;
                    }
                    if (!this.autoCom) {
                        if (DDLCount == mDDLCount) {
                            this.CommitOrRollback(pConnection);
                        } else {
                            pConnection.commit();
                        }
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    if (((SQLException)e).getErrorCode() == -1 || ((SQLException)e).getErrorCode() == 200 || ((SQLException)e).getErrorCode() == 250 || ((SQLException)e).getErrorCode() == -3007) break block25;
                    SharedSQL_Test.access$2("Thread " + this.name + ": Method executeCmd ", 'E', " execute failed: " + this.sqlstmt + " " + ((SQLException)e).getErrorCode() + " " + ((SQLException)e).getLocalizedMessage());
                    if (((SQLException)e).getErrorCode() == -807) {
                        this.keepRuning = false;
                    }
                    this.hasAnError = true;
                }
            }
        }

        private void executeDDL(Connection pConnection) throws TestCaseException {
            TestPreparedStatement stmt = null;
            this.sqlstmt = "???";
            try {
                if (this.drop) {
                    this.drop = false;
                    this.sqlstmt = "ALTER TABLE TAB1 DROP COLUMN DATAX";
                } else {
                    this.drop = true;
                    this.sqlstmt = "ALTER TABLE TAB1 ADD DATAX CHAR(10) DEFAULT NULL";
                }
                stmt = new TestPreparedStatement(null, pConnection, this.sqlstmt);
                if (stmt != null) {
                    ++mDDLCount;
                    stmt.executeUpdate();
                    ++this.StmtCount;
                    if (!this.autoCom) {
                        this.CommitOrRollback(pConnection);
                    }
                    stmt.close();
                }
            }
            catch (Exception e) {
                SharedSQL_Test.access$2("Thread " + this.name + ": Method executeAlter ", 'E', " execute failed: " + this.sqlstmt + " " + ((SQLException)e).getErrorCode());
                SharedSQL_Test.access$2("Thread " + this.name, 'T', "StmtCount = " + this.StmtCount);
                if (((SQLException)e).getErrorCode() == -807) {
                    this.keepRuning = false;
                    throw new TestCaseException("Time out -807 for thread " + this.name);
                }
                this.keepRuning = false;
                this.hasAnError = true;
            }
        }
    }
}

