/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.simple;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.utilities.Execute;
import java.io.File;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;

public class SDBInfo
extends TestCase {
    private static String prtFileDirOfSDBInfo = null;
    private static String indepProgPathToSDBInfo = null;
    private static String fileSep = File.separator;
    private static final SimpleDateFormat mDateFormat = new SimpleDateFormat("HH:mm:ss.SSS");

    public static String getTestClassId() {
        return "SDBInfo";
    }

    public static long getTimeout() {
        return 300000L;
    }

    public void run() {
        System.out.println("Run of " + SDBInfo.getTestClassId());
        File prtFile = new File(String.valueOf(prtFileDirOfSDBInfo) + fileSep + "wrk" + fileSep + "SDBINFO.PRT");
        StringBuffer sb = new StringBuffer();
        try {
            String progToCall = String.valueOf(indepProgPathToSDBInfo) + fileSep + "bin" + fileSep + "sdbinfo";
            Execute exc = null;
            if (System.getProperty("os.name").indexOf("Windows") != -1) {
                progToCall = String.valueOf(progToCall) + ".exe";
                exc = new Execute(progToCall, null, sb);
            } else {
                String[] cmdArr = new String[]{"sh", "-c", progToCall};
                exc = new Execute(cmdArr, null, sb);
            }
            this.addMessage(SDBInfo.getTestClassId(), 'I', "Try to call '" + progToCall + "'");
            exc.exec(new File(System.getProperty("jtest.root")));
            int rc = exc.getExitValue();
            if (rc == 0) {
                this.addMessage(SDBInfo.getTestClassId(), 'I', progToCall + " returned with no error (rc = 0).");
                if (prtFile.exists()) {
                    this.addMessage(SDBInfo.getTestClassId(), 'I', "The file '" + prtFile.toString() + "' exists and has a size of: " + prtFile.length() + " bytes. Last modified: " + mDateFormat.format(new Date(prtFile.lastModified())));
                } else {
                    this.addMessage(SDBInfo.getTestClassId(), 'E', "The file '" + prtFile.toString() + "' does not exist.");
                }
            } else {
                this.addMessage(SDBInfo.getTestClassId(), 'E', progToCall + " returned with error (rc = " + rc + ").");
                this.addMessage(SDBInfo.getTestClassId(), 'T', "stdout:\n" + sb.toString());
            }
        }
        catch (Exception ex) {
            this.addMessage(SDBInfo.getTestClassId(), 'E', "Catched an unexpected exception: " + ex.getMessage());
        }
    }

    public static void cleanUp() throws TestCaseException {
        System.out.println("End of " + SDBInfo.getTestClassId());
    }

    public static void prepare() throws TestCaseException {
        System.out.println("Start of the test " + SDBInfo.getTestClassId());
        try {
            indepProgPathToSDBInfo = TestCase.getDatabase().executeDBMcmd("dbm_getpath indepprogpath");
            if (indepProgPathToSDBInfo != null && indepProgPathToSDBInfo.indexOf("\n") != -1) {
                indepProgPathToSDBInfo = indepProgPathToSDBInfo.substring(0, indepProgPathToSDBInfo.indexOf("\n"));
            }
            prtFileDirOfSDBInfo = ((TestDatabaseSap)TestCase.getDatabase()).getIndepDataPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            File oldProtFileOfSDBInfo = new File(String.valueOf(prtFileDirOfSDBInfo) + fileSep + "wrk" + fileSep + "SDBINFO.PRT");
            if (oldProtFileOfSDBInfo.exists()) {
                oldProtFileOfSDBInfo.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getLogFile() {
        return null;
    }
}

