/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.optimizer;

import com.sap.sapdb.oltptest.optimizer.QualificationDescriptor;
import com.sap.sapdb.oltptest.optimizer.SequenceDescriptor;
import com.sap.sapdb.oltptest.optimizer.TableDescriptor;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.testcase.VerificationData;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;

public class GenerateEquiJoins
extends TestCase {
    private static int mNumberOfTables;
    private static int mNumberOfTuples;
    private static int mNumberOfDeadTuples;
    private static int mNumberOfEquivalentTuples;
    private TestStatement mStatement;
    private Connection mConnection;
    private static TableDescriptor[] mTables;
    private SequenceDescriptor mSequence;
    private static Vector mUniqueSequences;
    private static boolean mPrintTrace;
    private static boolean mLocked;
    private static int mJoinKey;

    static {
        mPrintTrace = false;
        mLocked = false;
        mJoinKey = 0;
    }

    void buildCartesianProduct(String PreviousValues, Vector Matrix, int MatrixIndex, SequenceDescriptor Seq) {
        Iterator CurrentValues = ((Vector)Matrix.elementAt(MatrixIndex)).iterator();
        while (CurrentValues.hasNext()) {
            if (MatrixIndex == Matrix.size() - 1) {
                Seq.mVerificationData.add(String.valueOf(PreviousValues) + (String)CurrentValues.next() + "')");
                continue;
            }
            this.buildCartesianProduct(String.valueOf(PreviousValues) + (String)CurrentValues.next() + "', '", Matrix, MatrixIndex + 1, Seq);
        }
    }

    private void executeQuery() {
        try {
            TestCase.addGlobalMessage((String)"executeQuery()", (char)'I', (String)("Select and check statement: " + this.mSequence.sqlSelectStatement));
            this.mStatement.executeQuery(this.mSequence.sqlSelectStatement);
            this.checkQuery(this.mStatement, (VerificationData)this.mSequence.mVerificationData, "Query");
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private boolean generateSequence() {
        this.mSequence = GenerateEquiJoins.generateUniqueSequence(mNumberOfTables);
        if (this.mSequence == null) {
            return false;
        }
        String FieldList = "";
        String FromList = "";
        String WhereClause = "";
        String LastTabName = "";
        int j = 0;
        while (j < this.mSequence.tableSequence.size()) {
            String TabName = GenerateEquiJoins.mTables[((Integer)this.mSequence.tableSequence.elementAt((int)j)).intValue()].tableName;
            FieldList = String.valueOf(FieldList) + TabName + ".ID,";
            FromList = String.valueOf(FromList) + TabName + ",";
            if (j > 0) {
                WhereClause = String.valueOf(WhereClause) + LastTabName + ".COL" + j + "=" + TabName + ".COL" + j + " AND ";
            }
            QualificationDescriptor Qualifier = (QualificationDescriptor)this.mSequence.mQualifications.elementAt(j);
            switch (Qualifier.mType) {
                case 1: {
                    WhereClause = String.valueOf(WhereClause) + TabName + ".VAL_INT = " + Qualifier.mEqualityValueInt + " AND ";
                    break;
                }
                case 3: {
                    WhereClause = String.valueOf(WhereClause) + "(" + TabName + ".VAL_INT BETWEEN " + Qualifier.mMinValueInt + " AND " + Qualifier.mMaxValueInt + ") AND ";
                    break;
                }
                case 2: {
                    WhereClause = String.valueOf(WhereClause) + TabName + ".VAL_CHR = '" + Qualifier.mEqualityValueStr + "' AND ";
                    break;
                }
                case 4: {
                    WhereClause = String.valueOf(WhereClause) + TabName + ".VAL_CHR LIKE '" + Qualifier.mLikeValueStr + "%' AND ";
                }
            }
            LastTabName = TabName;
            ++j;
        }
        FieldList = FieldList.substring(0, FieldList.length() - 1);
        FromList = FromList.substring(0, FromList.length() - 1);
        WhereClause = WhereClause.substring(0, WhereClause.length() - 5);
        this.mSequence.sqlSelectStatement = "SELECT " + FieldList + " FROM " + FromList + " WHERE " + WhereClause + " ORDER BY " + FieldList;
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean generateTables() {
        statement = null;
        connection = null;
        FieldLen = Integer.toString((GenerateEquiJoins.mNumberOfTuples + GenerateEquiJoins.mNumberOfDeadTuples) * GenerateEquiJoins.mNumberOfEquivalentTuples).length() + 10;
        GenerateEquiJoins.mTables = new TableDescriptor[GenerateEquiJoins.mNumberOfTables];
        try {
            try {
                connection = TestCase.getDatabase().connect(TestCase.getUser(), TestCase.getPassword());
                statement = new TestStatement(null, connection);
                i = 0;
                block9: while (i < GenerateEquiJoins.mNumberOfTables) {
                    GenerateEquiJoins.mTables[i] = new TableDescriptor(i + 1);
                    sqlStatement = "CREATE TABLE " + GenerateEquiJoins.mTables[i].tableName + " (ID CHAR(" + (FieldLen + 5) + ") PRIMARY KEY, VAL_CHR CHAR(10), VAL_INT INTEGER, COL1 CHAR(" + FieldLen + ")";
                    j = 0;
                    while (true) {
                        if (j >= GenerateEquiJoins.mNumberOfTables - 2) {
                            sqlStatement = String.valueOf(sqlStatement) + ")";
                            TestCase.addGlobalMessage((String)"generateTables()", (char)'I', (String)("Generated CREATE TABLE statement for table: " + GenerateEquiJoins.mTables[i].tableName));
                            if (GenerateEquiJoins.mPrintTrace) {
                                System.out.println("Init: " + sqlStatement);
                            }
                            GenerateEquiJoins.mTables[i].sqlCreateStatement = sqlStatement;
                            statement.enableExceptions(false);
                            statement.executeUpdate("DROP TABLE " + GenerateEquiJoins.mTables[i].tableName);
                            statement.enableExceptions(true);
                            statement.executeUpdate(sqlStatement);
                            ++i;
                            continue block9;
                        }
                        sqlStatement = String.valueOf(sqlStatement) + ", COL" + (j + 2) + " CHAR(" + FieldLen + ")";
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                var7_7 = null;
                try {
                    connection.close();
                    statement.close();
                    return false;
                }
                catch (Exception var9_10) {
                    // empty catch block
                }
                return false;
            }
        }
        catch (Throwable var8_13) {
            var7_8 = null;
            ** try [egrp 2[TRYBLOCK] [3 : 365->380)] { 
lbl47:
            // 1 sources

            connection.close();
            statement.close();
            throw var8_13;
lbl50:
            // 1 sources

            catch (Exception var9_11) {
                // empty catch block
            }
            throw var8_13;
        }
        {
            var7_9 = null;
        }
        try {}
        catch (Exception var9_12) {
            return true;
        }
        connection.close();
        statement.close();
        return true;
    }

    private void generateTuples() {
        int i = 0;
        int NumberOfTuples = 0;
        int NumberOfDeadTuples = 0;
        int CurrentCol = 0;
        String InsertCommand = "";
        String LastVal = "";
        SequenceDescriptor Seq = null;
        Vector TempMatrix = new Vector(mNumberOfTables);
        int ResCounter = 0;
        double TuplePropability = 100.0 / ((double)(mNumberOfTuples + mNumberOfDeadTuples) / (double)mNumberOfTuples);
        TestCase.addGlobalMessage((String)"generateTuples()", (char)'I', (String)("Propability for selected tuples vs. last tuples: " + TuplePropability + " %"));
        try {
            while (i < mNumberOfTuples + mNumberOfDeadTuples) {
                boolean IsDeadTuple;
                if (Math.random() * 100.0 <= TuplePropability && NumberOfTuples < mNumberOfTuples) {
                    ++NumberOfTuples;
                    ++i;
                    Seq = this.mSequence;
                    IsDeadTuple = false;
                } else {
                    ++NumberOfDeadTuples;
                    ++i;
                    Seq = GenerateEquiJoins.generateUniqueSequence(mNumberOfTables);
                    IsDeadTuple = true;
                    if (Seq == null) continue;
                }
                CurrentCol = 0;
                TempMatrix.clear();
                int NewResCounter = 1;
                Iterator Iter = Seq.tableSequence.iterator();
                while (Iter.hasNext()) {
                    int TabIndex = (Integer)Iter.next();
                    String TabName = GenerateEquiJoins.mTables[TabIndex].tableName;
                    String CurrentVal = "K" + GenerateEquiJoins.nextJoinKey();
                    QualificationDescriptor Qualifier = (QualificationDescriptor)Seq.mQualifications.elementAt(CurrentCol++);
                    int NumberOfEquivalentTuples = QualificationDescriptor.randomInteger(1, mNumberOfEquivalentTuples);
                    Vector<String> TempValues = new Vector<String>(NumberOfEquivalentTuples);
                    NewResCounter *= NumberOfEquivalentTuples;
                    int j = 0;
                    while (j < NumberOfEquivalentTuples) {
                        String QualValues;
                        String NextKey = mTables[TabIndex].getNextKey();
                        Qualifier.generateNext();
                        switch (Qualifier.mType) {
                            case 1: 
                            case 3: {
                                QualValues = "NULL, " + Qualifier.getNextValue();
                                break;
                            }
                            case 2: 
                            case 4: {
                                QualValues = "'" + Qualifier.getNextValue() + "', NULL";
                                break;
                            }
                            default: {
                                QualValues = "NULL, NULL";
                            }
                        }
                        InsertCommand = CurrentCol == 1 ? "INSERT INTO " + TabName + "(ID, VAL_CHR, VAL_INT, COL1) VALUES ('" + NextKey + "', " + QualValues + ", '" + CurrentVal + "')" : (!Iter.hasNext() ? "INSERT INTO " + TabName + "(ID, VAL_CHR, VAL_INT, COL" + (CurrentCol - 1) + ") VALUES ('" + NextKey + "', " + QualValues + ", '" + LastVal + "')" : "INSERT INTO " + TabName + "(ID, VAL_CHR, VAL_INT, COL" + (CurrentCol - 1) + ", COL" + CurrentCol + ") VALUES ('" + NextKey + "', " + QualValues + ", '" + LastVal + "', '" + CurrentVal + "')");
                        TempValues.add(NextKey);
                        this.printTrace(InsertCommand);
                        if (mPrintTrace) {
                            TestCase.addGlobalMessage((String)"generateTuples()", (char)'I', (String)("Creating tuples with: " + InsertCommand));
                        }
                        this.mStatement.executeUpdate(InsertCommand);
                        ++j;
                    }
                    LastVal = CurrentVal;
                    TempMatrix.add(TempValues);
                }
                if (IsDeadTuple) continue;
                this.buildCartesianProduct("('", TempMatrix, 0, Seq);
                this.printTrace("ResCounter: " + (ResCounter += NewResCounter));
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private static synchronized SequenceDescriptor generateUniqueSequence(int NumberOfTables) {
        String SequenceString = "";
        int NumberOfFails = 0;
        boolean IsUniqueSequence = false;
        Vector<Integer> TableIndexes = new Vector<Integer>(NumberOfTables);
        SequenceDescriptor Seq = new SequenceDescriptor();
        while (!IsUniqueSequence && NumberOfFails < 10) {
            int SeqLength = (int)(Math.random() * (double)(NumberOfTables - 2)) + 2;
            SequenceString = "";
            Seq.tableSequence.clear();
            TableIndexes.clear();
            int j = 0;
            while (j < NumberOfTables) {
                TableIndexes.add(new Integer(j));
                ++j;
            }
            j = 0;
            while (j < SeqLength) {
                int TempPos = (int)(Math.random() * (double)TableIndexes.size());
                String TabName = GenerateEquiJoins.mTables[((Integer)TableIndexes.elementAt((int)TempPos)).intValue()].tableName;
                SequenceString = String.valueOf(SequenceString) + TabName;
                Seq.tableSequence.add((Integer)TableIndexes.elementAt(TempPos));
                Seq.mQualifications.add(new QualificationDescriptor());
                TableIndexes.remove(TempPos);
                ++j;
            }
            IsUniqueSequence = true;
            j = 0;
            while (j < mUniqueSequences.size()) {
                if (SequenceString.indexOf((String)mUniqueSequences.elementAt(j)) != -1) {
                    IsUniqueSequence = false;
                }
                ++j;
            }
            if (IsUniqueSequence) continue;
            ++NumberOfFails;
        }
        if (!IsUniqueSequence) {
            return null;
        }
        mUniqueSequences.add(SequenceString);
        return Seq;
    }

    private static synchronized boolean IsLocked() {
        return mLocked;
    }

    private static synchronized boolean Lock() {
        if (mLocked) {
            return false;
        }
        mLocked = true;
        return true;
    }

    private static final synchronized int nextJoinKey() {
        return mJoinKey++;
    }

    public static void prepare() throws TestCaseException {
        mUniqueSequences = new Vector();
    }

    private void printResults() {
        if (mPrintTrace) {
            this.printTrace(this.mSequence.sqlSelectStatement);
            Iterator Iter = this.mSequence.mReferenceTuples.iterator();
            while (Iter.hasNext()) {
                this.printTrace((String)Iter.next());
            }
        }
    }

    private void printTrace(String TraceMessage) {
        if (mPrintTrace) {
            System.out.println(TraceMessage);
        }
    }

    private static boolean readParameters() {
        mNumberOfTables = TestCase.getParameterInt((String)"NumberOfTables", (int)4);
        mNumberOfTuples = TestCase.getParameterInt((String)"NumberOfTuples", (int)50);
        mNumberOfDeadTuples = TestCase.getParameterInt((String)"NumberOfDeadTuples", (int)0);
        mNumberOfEquivalentTuples = TestCase.getParameterInt((String)"NumberOfEquivalentTuples", (int)5);
        mPrintTrace = TestCase.getParameterBoolean((String)"PrintTrace", (boolean)false);
        TestCase.addGlobalMessage((String)"readParameters()", (char)'I', (String)("\n       mNumberOfTables           = " + mNumberOfTables + "\n       mNumberOfTuples           = " + mNumberOfTuples + "\n       mNumberOfDeadTuples       = " + mNumberOfDeadTuples + "\n       mNumberOfEquivalentTuples = " + mNumberOfEquivalentTuples + "\n       mPrintTrace               = " + mPrintTrace));
        if (mNumberOfTables < 2) {
            TestCase.addGlobalMessage((String)"IllegalParameter", (char)'E', (String)("Illegal number of Tables: " + mNumberOfTables + ". Has to be at least 2"));
            return false;
        }
        if (mNumberOfTuples < 1) {
            TestCase.addGlobalMessage((String)"IllegalParameter", (char)'E', (String)("Illegal number of Tuples: " + mNumberOfTuples));
            return false;
        }
        if (mNumberOfEquivalentTuples < 1) {
            TestCase.addGlobalMessage((String)"IllegalParameter", (char)'E', (String)("Illegal number of equivalent tuples: " + mNumberOfEquivalentTuples));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                if (GenerateEquiJoins.Lock()) {
                    TestCase.addGlobalMessage((String)"run()", (char)'I', (String)"Thread is locked during table creation!");
                    if (!GenerateEquiJoins.readParameters()) {
                        throw new TestCaseException("Illegal parameters");
                    }
                    if (!GenerateEquiJoins.generateTables()) {
                        throw new TestCaseException("Error during table creation");
                    }
                    GenerateEquiJoins.Unlock();
                    TestCase.addGlobalMessage((String)"run()", (char)'I', (String)"Thread is unlocked after table creation!");
                }
                this.WaitForUnlock();
                this.mConnection = TestCase.getDatabase().connect(TestCase.getUser(), TestCase.getPassword());
                this.mStatement = new TestStatement((TestCase)this, this.mConnection);
                if (this.generateSequence()) {
                    this.generateTuples();
                    this.printResults();
                    this.executeQuery();
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            try {
                GenerateEquiJoins.Unlock();
                this.mStatement.close();
                this.mConnection.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        GenerateEquiJoins.Unlock();
        this.mStatement.close();
        this.mConnection.close();
    }

    private static void Unlock() {
        mLocked = false;
    }

    private void WaitForUnlock() throws Exception {
        while (GenerateEquiJoins.IsLocked()) {
            Thread.sleep(50L);
        }
    }
}

